/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.edshipyard;

import com.fs.starfarer.api.BaseModPlugin;
import com.fs.starfarer.api.EveryFrameScript;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.PluginPick;
import com.fs.starfarer.api.campaign.CampaignPlugin;
import com.fs.starfarer.api.campaign.LocationAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.combat.AutofireAIPlugin;
import com.fs.starfarer.api.combat.MissileAIPlugin;
import com.fs.starfarer.api.combat.MissileAPI;
import com.fs.starfarer.api.combat.ShipAIPlugin;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.WeaponAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.impl.campaign.DerelictShipEntityPlugin;
import com.fs.starfarer.api.impl.campaign.intel.bar.events.BarEventManager;
import com.fs.starfarer.api.impl.campaign.procgen.themes.BaseThemeGenerator;
import com.fs.starfarer.api.impl.campaign.procgen.themes.SalvageSpecialAssigner;
import com.fs.starfarer.api.impl.campaign.rulecmd.salvage.special.ShipRecoverySpecial;
import com.fs.starfarer.api.util.Misc;
import data.scripts.edshipyard.FleetRepairOptimizationsBonusScript;
import data.scripts.edshipyard.ai.Dummy_AI;
import data.scripts.edshipyard.ai.Maltese_AI;
import data.scripts.edshipyard.ai.Terrier_AI;
import data.scripts.edshipyard.ai.TrainModuleShipAI;
import data.scripts.edshipyard.ai.WurgandalModuleShipAI;
import data.scripts.edshipyard.campaign.EdDistressEncounter;
import data.scripts.edshipyard.campaign.EdFleetManager;
import data.scripts.edshipyard.campaign.intel.bar.events.EDSubmarketBarEventCreator;
import data.scripts.edshipyard.util.QuestUtils;
import data.scripts.edshipyard.util.Utils;
import data.scripts.edshipyard.weapons.ai.MawAutofireAI;
import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.magiclib.util.MagicCampaign;

public class ED_modPlugin
extends BaseModPlugin {
    public static Logger log = Global.getLogger(ED_modPlugin.class);

    public PluginPick<MissileAIPlugin> pickMissileAI(MissileAPI missile, ShipAPI launchingShip) {
        return null;
    }

    public PluginPick<ShipAIPlugin> pickShipAI(FleetMemberAPI member, ShipAPI ship) {
        switch (ship.getHullSpec().getHullId()) {
            case "edshipyard_maltese": {
                return new PluginPick((Object)new Maltese_AI(ship), CampaignPlugin.PickPriority.MOD_GENERAL);
            }
            case "edshipyard_terrier": {
                return new PluginPick((Object)new Terrier_AI(ship), CampaignPlugin.PickPriority.MOD_GENERAL);
            }
            case "edshipyard_retriever_shield": {
                return new PluginPick((Object)new Dummy_AI(), CampaignPlugin.PickPriority.MOD_GENERAL);
            }
            case "edshipyard_newfoundland_combatfreighter": {
                return new PluginPick((Object)new TrainModuleShipAI(ship), CampaignPlugin.PickPriority.MOD_GENERAL);
            }
        }
        if (ship.getHullSpec().getHullId().startsWith("edshipyard_wurg_")) {
            return new PluginPick((Object)new WurgandalModuleShipAI(ship), CampaignPlugin.PickPriority.MOD_GENERAL);
        }
        return super.pickShipAI(member, ship);
    }

    public void onNewGameAfterEconomyLoad() {
        this.ensureInitialGameState();
    }

    public void onGameLoad(boolean newGame) {
        this.ensureInitialGameState();
        if (QuestUtils.getHasSubMarketBeenBought()) {
            this.removeQuestObjects();
        } else {
            this.ensureQuestObjects();
        }
        if (!Global.getSector().hasScript(EdFleetManager.class)) {
            Global.getSector().addScript((EveryFrameScript)new EdFleetManager());
        }
        if (!Global.getSector().hasScript(EdDistressEncounter.class)) {
            Global.getSector().addScript((EveryFrameScript)new EdDistressEncounter());
        }
        Global.getSector().addTransientScript((EveryFrameScript)new FleetRepairOptimizationsBonusScript());
    }

    public void afterGameSave() {
    }

    public void beforeGameSave() {
        this.removeQuestObjects();
    }

    private void ensureInitialGameState() {
        if (!Global.getSector().getMemoryWithoutUpdate().getBoolean("$EdShipyardInit")) {
            for (MarketAPI market : Global.getSector().getEconomy().getMarketsCopy()) {
                if (!this.needsEdSubmarket(market)) continue;
                market.addSubmarket("ed_shipyard");
                log.info((Object)("Adding ED Shipyards Submarket to: " + market.getPrimaryEntity().getFullName() + " in " + market.getPrimaryEntity().getStarSystem().getBaseName()));
            }
            SectorEntityToken shipLocation = ED_modPlugin.findSuitableLocationForShip();
            if (shipLocation != null) {
                ED_modPlugin.addDerelict(shipLocation, "edshipyard_saluki_x");
            }
            Global.getSector().getMemoryWithoutUpdate().set("$EdShipyardInit", (Object)true);
        }
        for (MarketAPI market : Global.getSector().getEconomy().getMarketsCopy()) {
            if (!market.getName().contains("Prism Freeport") || market.hasSubmarket("ed_shipyard")) continue;
            market.addSubmarket("ed_shipyard");
            log.info((Object)("Adding ED Shipyards Submarket to: " + market.getPrimaryEntity().getFullName() + " in " + market.getPrimaryEntity().getStarSystem().getBaseName()));
        }
    }

    private boolean needsEdSubmarket(MarketAPI market) {
        if (!Utils.isIndependentOwned(market) || market.getSize() < 5) {
            return false;
        }
        if (!market.hasIndustry("heavyindustry") && !market.hasIndustry("orbitalworks") && market.getSize() < 6) {
            return false;
        }
        if (market.getSubmarketsCopy().size() > 4) {
            return false;
        }
        return !market.hasSubmarket("ed_shipyard");
    }

    private void ensureQuestObjects() {
        if (!BarEventManager.getInstance().hasEventCreator(EDSubmarketBarEventCreator.class)) {
            BarEventManager.getInstance().addEventCreator((BarEventManager.GenericBarEventCreator)new EDSubmarketBarEventCreator());
        }
    }

    private void removeQuestObjects() {
        for (BarEventManager.GenericBarEventCreator barEventCreator : new ArrayList(BarEventManager.getInstance().getCreators())) {
            if (!(barEventCreator instanceof EDSubmarketBarEventCreator)) continue;
            BarEventManager.getInstance().getCreators().remove(barEventCreator);
        }
    }

    public static SectorEntityToken findSuitableLocationForShip() {
        try {
            ArrayList<String> desiredEntities = new ArrayList<String>();
            desiredEntities.add("planet");
            desiredEntities.add("jump_point");
            ArrayList<String> seek_themes = new ArrayList<String>();
            seek_themes.add("procgen_no_theme");
            ArrayList<String> avoid_themes = new ArrayList<String>();
            avoid_themes.add("theme_already_occupied");
            avoid_themes.add("theme_already_colonized");
            return MagicCampaign.findSuitableTarget(new ArrayList(), new ArrayList(), (String)"CLOSE", seek_themes, avoid_themes, desiredEntities, (boolean)true, (boolean)true, (boolean)true);
        }
        catch (RuntimeException e) {
            log.warn((Object)"Unable to locate suitable system for secret ship", (Throwable)e);
            return null;
        }
    }

    public static SectorEntityToken addDerelict(SectorEntityToken focus, String variantId) {
        DerelictShipEntityPlugin.DerelictShipData params = new DerelictShipEntityPlugin.DerelictShipData(new ShipRecoverySpecial.PerShipData(variantId, ShipRecoverySpecial.ShipCondition.PRISTINE), false);
        SectorEntityToken ship = BaseThemeGenerator.addSalvageEntity((LocationAPI)focus.getStarSystem(), (String)"wreck", (String)"neutral", (Object)params);
        ship.setDiscoverable(Boolean.valueOf(true));
        float orbitRadius = 250.0f;
        float orbitDays = orbitRadius / (10.0f + (float)Math.random() * 5.0f);
        ship.setCircularOrbit(focus, (float)Math.random() * 360.0f, orbitRadius, orbitDays);
        SalvageSpecialAssigner.ShipRecoverySpecialCreator creator = new SalvageSpecialAssigner.ShipRecoverySpecialCreator(null, 0, 0, false, null, null);
        Misc.setSalvageSpecial((SectorEntityToken)ship, (Object)creator.createSpecial(ship, null));
        log.info((Object)("Creating derelict ship " + variantId + " in system: " + focus.getStarSystem().getBaseName() + " around entity: " + focus.getFullName() + " of constellation: " + focus.getStarSystem().getConstellation().getName()));
        return ship;
    }

    public PluginPick<AutofireAIPlugin> pickWeaponAutofireAI(WeaponAPI weapon) {
        switch (weapon.getId()) {
            case "edshipyard_MAW": {
                return new PluginPick((Object)new MawAutofireAI(weapon), CampaignPlugin.PickPriority.MOD_SPECIFIC);
            }
        }
        return null;
    }
}

