/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.edshipyard.ai;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.ShipAIConfig;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipwideAIFlags;
import com.fs.starfarer.api.combat.WeaponAPI;
import com.fs.starfarer.api.util.IntervalUtil;
import data.scripts.edshipyard.ai.BaseShipAI;
import data.scripts.edshipyard.util.StolenUtils;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import org.lazywizard.lazylib.CollisionUtils;
import org.lazywizard.lazylib.MathUtils;
import org.lazywizard.lazylib.VectorUtils;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class Terrier_AI
extends BaseShipAI {
    private final ShipwideAIFlags flags = new ShipwideAIFlags();
    private final ShipAIConfig config = new ShipAIConfig();
    private ShipAPI carrier;
    ShipAPI target;
    boolean targetHasChanged;
    Vector2f shipLastVelocity = new Vector2f();
    Vector2f targetLastVelocity = new Vector2f();
    WeaponAPI weapon;
    int reloadAmount;
    Vector2f targetOffset;
    Random rng = new Random();
    float distToCarrier;
    boolean firstRun = true;
    boolean doingMx = false;
    boolean returning = false;
    float targetFacingOffset = Float.MIN_VALUE;
    float range = 4000.0f;
    float origMass;
    WeaponAPI arms;
    int armsFrame = 0;
    private final IntervalUtil interval = new IntervalUtil(0.25f, 0.33f);
    private final IntervalUtil countdown = new IntervalUtil(4.0f, 4.0f);
    private final float AMMO_RESTORE_SMALL = 1.0f;
    private final float AMMO_RESTORE_MEDIUM = 0.25f;
    private final float AMMO_RESTORE_LARGE = 0.1f;
    private final float RELOAD_RANGE = 10.0f;

    Vector2f getDestination() {
        return new Vector2f();
    }

    public Terrier_AI(ShipAPI ship) {
        super(ship);
        this.origMass = ship.getMass();
    }

    @Override
    public void advance(float amount) {
        if (this.carrier == null) {
            this.init();
        }
        if (this.ship.isLanding()) {
            this.countdown.advance(amount);
            if (this.countdown.intervalElapsed()) {
                this.ship.getWing().getSource().land(this.ship);
                return;
            }
        }
        if (this.needsRefit()) {
            this.arms.getAnimation().setFrame(15);
        } else {
            this.arms.getAnimation().setFrame(Math.min(15, this.armsFrame));
        }
        this.interval.advance(amount);
        this.distToCarrier = (float)((double)MathUtils.getDistanceSquared((Vector2f)this.carrier.getLocation(), (Vector2f)this.ship.getLocation()) / Math.pow(this.target.getCollisionRadius(), 2.0));
        if (this.interval.intervalElapsed()) {
            super.advance(amount);
            if (this.returning && !this.ship.isLanding() && this.distToCarrier < 1.0f) {
                this.ship.beginLandingAnimation(this.carrier);
            }
        }
        if (this.target == null) {
            return;
        }
        this.goToDestination();
    }

    @Override
    public boolean needsRefit() {
        return this.ship.getFluxTracker().getFluxLevel() >= 1.0f;
    }

    public void cancelCurrentManeuver() {
    }

    @Override
    public void evaluateCircumstances() {
        if (this.carrier == null || !this.carrier.isAlive()) {
            StolenUtils.destroy((CombatEntityAPI)this.ship);
            return;
        }
        this.setTarget(this.chooseTarget());
        if (this.targetHasChanged || this.firstRun || this.target == this.carrier && !this.returning) {
            if (this.target == this.carrier) {
                this.targetOffset = this.ship.getWing().getSource().getLandingLocation(this.ship);
                if (!this.returning) {
                    this.targetOffset = this.randomizePointOnEntity(this.targetOffset, this.target.getCollisionRadius() / 2.0f, (CombatEntityAPI)this.target);
                }
                this.targetOffset = StolenUtils.toRelative((CombatEntityAPI)this.target, this.targetOffset);
            } else {
                this.targetOffset = StolenUtils.toRelative((CombatEntityAPI)this.target, this.randomizePointOnEntity(this.target.getLocation(), this.target.getCollisionRadius(), (CombatEntityAPI)this.target));
            }
            this.firstRun = false;
        }
        if (!(this.target.getPhaseCloak() != null && this.target.getPhaseCloak().isOn() || this.returning || this.doingMx || !(MathUtils.getDistance((CombatEntityAPI)this.ship, (CombatEntityAPI)this.target) < 10.0f))) {
            this.restoreAmmo();
        }
    }

    Vector2f randomizePointOnEntity(Vector2f pointToRand, float radius, CombatEntityAPI entity) {
        Vector2f retVar;
        while (!CollisionUtils.isPointWithinBounds((Vector2f)(retVar = MathUtils.getRandomPointInCircle((Vector2f)pointToRand, (float)radius)), (CombatEntityAPI)entity)) {
        }
        return retVar;
    }

    Vector2f randomizePointOffEntity(Vector2f pointToRand, float radius, CombatEntityAPI entity) {
        Vector2f retVar;
        while (CollisionUtils.isPointWithinBounds((Vector2f)(retVar = MathUtils.getRandomPointInCircle((Vector2f)pointToRand, (float)radius)), (CombatEntityAPI)entity)) {
        }
        return retVar;
    }

    void restoreAmmo() {
        if (this.weapon != null && this.weapon.getAmmo() < this.weapon.getMaxAmmo()) {
            this.weapon.setAmmo(Math.min(this.weapon.getAmmo() + this.reloadAmount, this.weapon.getMaxAmmo()));
            this.doingMx = true;
        } else {
            this.weapon = null;
            WeaponAPI tempW = null;
            List weapons = this.target.getAllWeapons();
            for (WeaponAPI w : weapons) {
                if (!w.usesAmmo() || w.getAmmo() >= w.getMaxAmmo() || w.getSlot().isDecorative() || w.getSlot().isBuiltIn()) continue;
                this.reloadAmount = w.getSlot().getSlotSize() == WeaponAPI.WeaponSize.LARGE ? (int)((float)w.getMaxAmmo() * 0.1f) : (w.getSlot().getSlotSize() == WeaponAPI.WeaponSize.MEDIUM ? (int)((float)w.getMaxAmmo() * 0.25f) : (int)((float)w.getMaxAmmo() * 1.0f));
                if (this.reloadAmount <= 0) continue;
                if (w.getAmmoPerSecond() == 0.0f && w.getAmmo() + this.reloadAmount <= w.getMaxAmmo()) {
                    this.weapon = w;
                    break;
                }
                if (tempW == null) {
                    tempW = w;
                    continue;
                }
                if (tempW.getAmmo() / tempW.getMaxAmmo() <= w.getAmmo() / w.getMaxAmmo()) continue;
                tempW = w;
            }
            this.weapon = tempW;
            if (this.weapon == null) {
                this.setTarget(this.chooseTarget());
            }
        }
    }

    ShipAPI chooseTarget() {
        if (this.needsRefit()) {
            this.returning = true;
            return this.carrier;
        }
        this.returning = false;
        if (this.carrier.getShipTarget() != null && this.carrier.getOwner() == this.carrier.getShipTarget().getOwner() && !this.carrier.getShipTarget().isDrone() && !this.carrier.getShipTarget().isFighter()) {
            return this.carrier.getShipTarget();
        }
        this.weapon = null;
        this.reloadAmount = 0;
        LinkedList<ShipAPI> finalList = new LinkedList<ShipAPI>();
        for (ShipAPI s : Global.getCombatEngine().getShips()) {
            float d = MathUtils.getDistance((CombatEntityAPI)this.carrier, (CombatEntityAPI)s);
            if (s.isFighter() || s.isDrone() || s.isHulk() || d > this.range || s.getOwner() != this.carrier.getOwner()) continue;
            ShipAPI mainbodys = s;
            ShipAPI mainbodyc = this.carrier;
            if (s.isStationModule()) {
                mainbodys = s.getParentStation();
            }
            if (this.carrier.isStationModule()) {
                mainbodyc = this.carrier.getParentStation();
            }
            if (mainbodys == mainbodyc) continue;
            if (finalList.isEmpty()) {
                finalList.add(s);
                continue;
            }
            int i = 0;
            boolean added = false;
            for (ShipAPI ss : finalList) {
                float dd = MathUtils.getDistance((CombatEntityAPI)this.carrier, (CombatEntityAPI)ss);
                if (d < dd) {
                    finalList.add(i, s);
                    added = true;
                    break;
                }
                ++i;
            }
            if (added) continue;
            finalList.add(s);
        }
        WeaponAPI tempW = null;
        ShipAPI tempS = null;
        for (ShipAPI s : finalList) {
            List weapons = s.getAllWeapons();
            for (WeaponAPI w : weapons) {
                if (!w.usesAmmo() || w.getAmmo() >= w.getMaxAmmo() || w.getSlot().isDecorative() || w.getSlot().isBuiltIn()) continue;
                this.reloadAmount = w.getSlot().getSlotSize() == WeaponAPI.WeaponSize.LARGE ? (int)((float)w.getMaxAmmo() * 0.1f) : (w.getSlot().getSlotSize() == WeaponAPI.WeaponSize.MEDIUM ? (int)((float)w.getMaxAmmo() * 0.25f) : (int)((float)w.getMaxAmmo() * 1.0f));
                if (this.reloadAmount <= 0) continue;
                if (w.getAmmoPerSecond() == 0.0f && w.getAmmo() + this.reloadAmount <= w.getMaxAmmo()) {
                    this.weapon = w;
                    return s;
                }
                if (tempW == null) {
                    tempW = w;
                } else if (tempW.getAmmo() / tempW.getMaxAmmo() > w.getAmmo() / w.getMaxAmmo()) {
                    tempW = w;
                }
                tempS = s;
            }
            if (tempS == null) continue;
            break;
        }
        this.weapon = tempW;
        if (tempS == null) {
            tempS = this.carrier;
        }
        return tempS;
    }

    void setTarget(ShipAPI t) {
        if (this.target == t) {
            this.targetHasChanged = false;
            return;
        }
        this.targetHasChanged = true;
        this.target = t;
        this.ship.setShipTarget(t);
    }

    void goToDestination() {
        Vector2f to = StolenUtils.toAbsolute((CombatEntityAPI)this.target, this.targetOffset);
        Vector2f toEst = new Vector2f((ReadableVector2f)to);
        if (this.doingMx) {
            if (this.arms != null) {
                ++this.armsFrame;
                if (this.armsFrame > 15) {
                    this.returning = true;
                    this.ship.setMass(this.origMass * 0.2f);
                    this.doingMx = false;
                    this.ship.getFluxTracker().setCurrFlux(this.ship.getFluxTracker().getMaxFlux());
                    Global.getSoundPlayer().playSound("reloaddrone", MathUtils.getRandomNumberInRange((float)0.95f, (float)1.05f) * 1.0f, 1.0f, this.ship.getLocation(), this.ship.getVelocity());
                }
            }
        } else {
            float mySpeed = (float)Math.max(1.0, Math.sqrt(this.ship.getVelocity().lengthSquared()));
            float distToTarget = MathUtils.getDistance((Vector2f)to, (Vector2f)this.ship.getLocation());
            float estTimeTilHit = distToTarget / mySpeed;
            if (this.target == this.carrier && this.distToCarrier < 1.0f || this.ship.isLanding()) {
                float f = 1.0f - Math.min(1.0f, this.distToCarrier);
                if (!this.returning) {
                    f *= 0.1f;
                }
                this.turnToward(this.target.getFacing());
                this.ship.getLocation().x = (to.x * (f * 0.1f) + this.ship.getLocation().x * (2.0f - f * 0.1f)) / 2.0f;
                this.ship.getLocation().y = (to.y * (f * 0.1f) + this.ship.getLocation().y * (2.0f - f * 0.1f)) / 2.0f;
                this.ship.getVelocity().x = (this.target.getVelocity().x * f + this.ship.getVelocity().x * (2.0f - f)) / 2.0f;
                this.ship.getVelocity().y = (this.target.getVelocity().y * f + this.ship.getVelocity().y * (2.0f - f)) / 2.0f;
            } else {
                Vector2f vTarget = new Vector2f(this.target.getVelocity().x + (this.target.getVelocity().x - this.targetLastVelocity.x), this.target.getVelocity().y + (this.target.getVelocity().y - this.targetLastVelocity.y));
                Vector2f vShip = new Vector2f(this.ship.getVelocity().x + (this.ship.getVelocity().x - this.shipLastVelocity.x), this.ship.getVelocity().y + (this.ship.getVelocity().y - this.shipLastVelocity.y));
                Vector2f estTargetPosChange = (Vector2f)new Vector2f((ReadableVector2f)vTarget).scale(estTimeTilHit);
                Vector2f.add((Vector2f)to, (Vector2f)estTargetPosChange, (Vector2f)toEst);
                distToTarget = MathUtils.getDistance((Vector2f)toEst, (Vector2f)this.ship.getLocation());
                estTimeTilHit = distToTarget / mySpeed;
                estTargetPosChange = (Vector2f)new Vector2f((ReadableVector2f)vTarget).scale(estTimeTilHit * 0.9f);
                Vector2f.sub((Vector2f)estTargetPosChange, (Vector2f)((Vector2f)new Vector2f((ReadableVector2f)vShip).scale(estTimeTilHit * 0.9f)), (Vector2f)estTargetPosChange);
                Vector2f.add((Vector2f)to, (Vector2f)estTargetPosChange, (Vector2f)toEst);
                float angleDifToEst = Math.abs(MathUtils.getShortestRotation((float)VectorUtils.getAngle((Vector2f)this.ship.getLocation(), (Vector2f)to), (float)VectorUtils.getAngle((Vector2f)this.ship.getLocation(), (Vector2f)toEst)));
                if (angleDifToEst < 140.0f) {
                    to = toEst;
                }
                Vector2f velocityVector = new Vector2f((ReadableVector2f)this.ship.getLocation());
                Vector2f.add((Vector2f)velocityVector, (Vector2f)vShip, (Vector2f)velocityVector);
                float angleDif = Math.abs(MathUtils.getShortestRotation((float)VectorUtils.getAngle((Vector2f)this.ship.getLocation(), (Vector2f)velocityVector), (float)VectorUtils.getAngle((Vector2f)this.ship.getLocation(), (Vector2f)to)));
                if (angleDif > 90.0f && mySpeed > 60.0f) {
                    this.decelerate();
                } else {
                    this.accelerate();
                }
                if (angleDif > 10.0f) {
                    this.turnToward(to);
                }
                this.strafeToward(to);
            }
            this.shipLastVelocity = new Vector2f((ReadableVector2f)this.ship.getVelocity());
            this.targetLastVelocity = new Vector2f((ReadableVector2f)this.target.getVelocity());
        }
    }

    public ShipwideAIFlags getAIFlags() {
        return this.flags;
    }

    @Override
    public void setDoNotFireDelay(float amount) {
    }

    public ShipAIConfig getConfig() {
        return this.config;
    }

    @Override
    public void init() {
        this.target = this.carrier = this.ship.getWing().getSourceShip();
        this.armsFrame = 0;
        this.targetOffset = StolenUtils.toRelative((CombatEntityAPI)this.carrier, this.carrier.getLocation());
        this.range = this.ship.getWing().getRange();
        List weapons = this.ship.getAllWeapons();
        if (weapons != null && !weapons.isEmpty()) {
            for (WeaponAPI w : weapons) {
                if (!w.getSlot().isDecorative()) continue;
                this.arms = w;
                return;
            }
        }
    }
}

