/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.edshipyard.ai;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.ShipAIConfig;
import com.fs.starfarer.api.combat.ShipAIPlugin;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipCommand;
import com.fs.starfarer.api.combat.ShipwideAIFlags;
import com.fs.starfarer.api.combat.WeaponGroupAPI;
import com.fs.starfarer.util.IntervalTracker;
import data.scripts.edshipyard.shipsystems.ai.TargetMissilesAI;
import java.util.List;

public class TrainModuleShipAI
implements ShipAIPlugin {
    private final ShipwideAIFlags _aiFlags = new ShipwideAIFlags();
    private final ShipAPI _module;
    private final IntervalTracker _interval = new IntervalTracker(0.18f, 0.22f);

    public TrainModuleShipAI(ShipAPI ship) {
        this._module = ship;
    }

    public void enableGuns() {
        List weaponGroups = this._module.getWeaponGroupsCopy();
        for (int i = 0; i < weaponGroups.size(); ++i) {
            if (((WeaponGroupAPI)weaponGroups.get(i)).isAutofiring()) continue;
            this._module.giveCommand(ShipCommand.TOGGLE_AUTOFIRE, null, i);
            return;
        }
    }

    public void advance(float amount) {
        ShipAPI parent = this._module.getParentStation();
        if (parent == null) {
            return;
        }
        if (this._module.isAlive() && !this._module.getFluxTracker().isVenting() && this._module.getFluxTracker().getCurrFlux() > 1000.0f && (parent.getFluxTracker().isVenting() || this._module.getFluxLevel() > 0.95f)) {
            this._module.giveCommand(ShipCommand.VENT_FLUX, null, 0);
            return;
        }
        this._interval.advance(amount);
        if (!this._interval.intervalElapsed()) {
            return;
        }
        this.enableGuns();
        if (TargetMissilesAI.useSystem(this._module)) {
            this._module.useSystem();
        }
        if (parent.getShipTarget() != null && parent.getShipTarget() != this._module.getShipTarget()) {
            this._module.setShipTarget(parent.getShipTarget());
        }
        if (this._module.hasLaunchBays()) {
            if (!(parent.getAllWings().size() != 0 || Global.getCombatEngine().getPlayerShip() == parent && Global.getCombatEngine().isUIAutopilotOn())) {
                parent.setPullBackFighters(false);
            }
            if (this._module.isPullBackFighters() ^ parent.isPullBackFighters()) {
                this._module.giveCommand(ShipCommand.PULL_BACK_FIGHTERS, null, 0);
            }
            if (this._module.getAIFlags() != null) {
                if ((Global.getCombatEngine().getPlayerShip() == parent || parent.getAIFlags() == null) && parent.getShipTarget() != null) {
                    this._module.getAIFlags().setFlag(ShipwideAIFlags.AIFlags.CARRIER_FIGHTER_TARGET, 1.0f, (Object)parent.getShipTarget());
                } else if (parent.getAIFlags() != null && parent.getAIFlags().hasFlag(ShipwideAIFlags.AIFlags.CARRIER_FIGHTER_TARGET) && parent.getAIFlags().getCustom(ShipwideAIFlags.AIFlags.CARRIER_FIGHTER_TARGET) != null) {
                    this._module.getAIFlags().setFlag(ShipwideAIFlags.AIFlags.CARRIER_FIGHTER_TARGET, 1.0f, parent.getAIFlags().getCustom(ShipwideAIFlags.AIFlags.CARRIER_FIGHTER_TARGET));
                } else if (parent.getShipTarget() != null) {
                    this._module.getAIFlags().setFlag(ShipwideAIFlags.AIFlags.CARRIER_FIGHTER_TARGET, 1.0f, (Object)parent.getShipTarget());
                }
            }
        }
    }

    public void setDoNotFireDelay(float amount) {
    }

    public void forceCircumstanceEvaluation() {
    }

    public boolean needsRefit() {
        return false;
    }

    public ShipwideAIFlags getAIFlags() {
        return this._aiFlags;
    }

    public void cancelCurrentManeuver() {
    }

    public ShipAIConfig getConfig() {
        return new ShipAIConfig();
    }
}

