/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.edshipyard.ai;

import com.fs.starfarer.api.combat.ShipAIConfig;
import com.fs.starfarer.api.combat.ShipAIPlugin;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipCommand;
import com.fs.starfarer.api.combat.ShipwideAIFlags;
import com.fs.starfarer.api.combat.WeaponGroupAPI;
import java.util.List;

public class WurgandalModuleShipAI
implements ShipAIPlugin {
    private final ShipwideAIFlags AIFlags = new ShipwideAIFlags();
    private final ShipAPI _module;
    public boolean _shieldsEnabled = true;
    public boolean _gunsEnabled = true;

    public WurgandalModuleShipAI(ShipAPI ship) {
        this._module = ship;
    }

    public void setShieldsEnabled(boolean _shieldsEnabled) {
        this._shieldsEnabled = _shieldsEnabled;
    }

    public void setGunsEnabled(boolean _gunsEnabled) {
        this._gunsEnabled = _gunsEnabled;
    }

    public void disableGuns() {
        List weaponGroups = this._module.getWeaponGroupsCopy();
        for (int i = 0; i < weaponGroups.size(); ++i) {
            if (!((WeaponGroupAPI)weaponGroups.get(i)).isAutofiring()) continue;
            this._module.giveCommand(ShipCommand.TOGGLE_AUTOFIRE, null, i);
            return;
        }
    }

    public void enableGuns() {
        List weaponGroups = this._module.getWeaponGroupsCopy();
        for (int i = 0; i < weaponGroups.size(); ++i) {
            if (((WeaponGroupAPI)weaponGroups.get(i)).isAutofiring()) continue;
            this._module.giveCommand(ShipCommand.TOGGLE_AUTOFIRE, null, i);
            return;
        }
    }

    public void disableShields() {
        if (this._module.getShield() == null || !this._module.getShield().isOn()) {
            return;
        }
        this._module.getShield().toggleOff();
    }

    public void enableShields() {
        if (this._module.getShield() == null || this._module.getShield().isOn()) {
            return;
        }
        this._module.getShield().toggleOn();
    }

    public void advance(float amount) {
        ShipAPI parent = this._module.getParentStation();
        if (parent == null) {
            return;
        }
        if (this._shieldsEnabled && parent.getShield() != null && parent.getShield().isOn()) {
            this.enableShields();
        } else {
            this.disableShields();
        }
        if (this._gunsEnabled) {
            this.enableGuns();
        } else {
            this.disableGuns();
        }
    }

    public void setDoNotFireDelay(float amount) {
    }

    public void forceCircumstanceEvaluation() {
    }

    public boolean needsRefit() {
        return false;
    }

    public ShipwideAIFlags getAIFlags() {
        return this.AIFlags;
    }

    public void cancelCurrentManeuver() {
    }

    public ShipAIConfig getConfig() {
        return new ShipAIConfig();
    }
}

