/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.edshipyard.campaign.intel.bar.events;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.RepLevel;
import com.fs.starfarer.api.campaign.TextPanelAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.econ.SubmarketAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.impl.campaign.DebugFlags;
import com.fs.starfarer.api.impl.campaign.intel.bar.PortsideBarEvent;
import com.fs.starfarer.api.impl.campaign.intel.bar.events.BarEventManager;
import com.fs.starfarer.api.impl.campaign.intel.bar.events.BaseBarEventWithPerson;
import com.fs.starfarer.api.impl.campaign.rulecmd.AddRemoveCommodity;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.MutableValue;
import data.scripts.edshipyard.util.QuestUtils;
import java.util.Map;
import org.apache.log4j.Logger;

public class EDSubmarketBarEvent
extends BaseBarEventWithPerson {
    public static Logger log = Global.getLogger(EDSubmarketBarEvent.class);
    private static final int COST = 1000000;

    public boolean shouldShowAtMarket(MarketAPI market) {
        if (!super.shouldShowAtMarket(market)) {
            return false;
        }
        if (DebugFlags.BAR_DEBUG) {
            return true;
        }
        log.info((Object)("Has Submarket been bought: " + QuestUtils.getHasSubMarketBeenBought() + " HasEdSubmarket: " + this.hasEdSubmarket(market) + " RelationshipIsGoodEnough: " + Global.getSector().getFaction("independent").ensureAtWorst("player", RepLevel.COOPERATIVE) + " Market Size: " + market.getSize() + " Market Is Player Owned: " + market.isPlayerOwned() + " Market Has heavyindustry: " + market.hasIndustry("heavyindustry") + " Market Has orbitalworks: " + market.hasIndustry("orbitalworks")));
        if (QuestUtils.getHasSubMarketBeenBought()) {
            return false;
        }
        if (this.hasEdSubmarket(market)) {
            return false;
        }
        if (Global.getSector().getFaction("independent").ensureAtWorst("player", RepLevel.COOPERATIVE)) {
            return false;
        }
        if (market.getSize() < 6) {
            return false;
        }
        if (!market.hasIndustry("heavyindustry") && !market.hasIndustry("orbitalworks")) {
            return false;
        }
        return market.isPlayerOwned();
    }

    private boolean hasEdSubmarket(MarketAPI market) {
        boolean ret = false;
        for (SubmarketAPI sbm : market.getSubmarketsCopy()) {
            if (!sbm.getSpecId().equals("ed_shipyard")) continue;
            ret = true;
            break;
        }
        return ret;
    }

    public void addPromptAndOption(InteractionDialogAPI dialog, Map<String, MemoryAPI> memoryMap) {
        super.addPromptAndOption(dialog, memoryMap);
        this.regen(dialog.getInteractionTarget().getMarket());
        dialog.getTextPanel().addPara("An Eccentric Designs representative waves at you confidently, seems like they have been expecting you.");
        dialog.getOptionPanel().addOption("See what kind of deal the ED representative has for you.", (Object)this);
    }

    public void init(InteractionDialogAPI dialog, Map<String, MemoryAPI> memoryMap) {
        super.init(dialog, memoryMap);
        this.done = false;
        dialog.getVisualPanel().showPersonInfo(this.person, true);
        this.optionSelected(null, (Object)OptionId.INIT);
    }

    public void optionSelected(String optionText, Object optionData) {
        if (optionData instanceof OptionId) {
            this.dialog.getOptionPanel().clearOptions();
            MutableValue purse = Global.getSector().getPlayerFleet().getCargo().getCredits();
            switch ((OptionId)((Object)optionData)) {
                case INIT: {
                    this.dialog.getTextPanel().addPara("You walk over and see what the " + this.getManOrWoman() + " is offering.");
                    this.dialog.getTextPanel().addPara("\"The success of " + this.market.getPrimaryEntity().getName() + " has not gone unnoticed by the ED Shipyards board, you should be proud of what you\u2019ve achieved here " + Global.getSector().getPlayerPerson().getNameString() + ", and we at ED Shipyards would like to be a part of that success.  Given the special nature of our relationship, we\u2019d like to make you an offer.  For a small investment, we\u2019ll construct an ED Shipyards market here that will help keep this colony supplied and defended.  So " + Global.getSector().getPlayerFaction().getDisplayName() + " will get a place to shop for the best ED Shipyards has to offer as well as protection, we get access to your advanced construction facilities.  Keep in mind however, we can only do this once for your empire, so be sure this is the location you'd like.\n\nIt\u2019s a win-win, a real two plus two equals five!\"");
                    String desc = "\"It can be yours for just " + Misc.getDGSCredits((float)1000000.0f) + " \"";
                    this.dialog.getTextPanel().addPara(desc, Misc.getTextColor(), Misc.getHighlightColor(), new String[]{Misc.getDGSCredits((float)1000000.0f)});
                    this.dialog.getOptionPanel().addOption("Pay " + Misc.getDGSCredits((float)1000000.0f) + " for the ED market (uses no slots)", (Object)OptionId.BUY);
                    this.dialog.getOptionPanel().addOption("Not right now, thanks", (Object)OptionId.LEAVE);
                    if (!(1000000.0f > purse.get())) break;
                    this.dialog.getOptionPanel().setEnabled((Object)OptionId.BUY, false);
                    this.dialog.getOptionPanel().setTooltip((Object)OptionId.BUY, "You don't have enough credits.");
                    break;
                }
                case BUY: {
                    purse.subtract(1000000.0f);
                    AddRemoveCommodity.addCreditsLossText((int)1000000, (TextPanelAPI)this.dialog.getTextPanel());
                    this.market.addSubmarket("ed_shipyard");
                    Global.getLogger(EDSubmarketBarEvent.class).info((Object)("Adding ED Shipyards Submarket to: " + this.market.getPrimaryEntity().getFullName() + " in " + this.market.getPrimaryEntity().getStarSystem().getBaseName()));
                    QuestUtils.setHasSubMarketBeenBought(true);
                    this.dialog.getTextPanel().addPara("\"Great doing business with you " + Global.getSector().getPlayerPerson().getNameString() + "\"");
                    this.dialog.getOptionPanel().addOption("Leave", (Object)OptionId.LEAVE);
                    BarEventManager.getInstance().notifyWasInteractedWith((PortsideBarEvent)this);
                    break;
                }
                case LEAVE: {
                    this.noContinue = true;
                    this.done = true;
                }
            }
        }
    }

    private static enum OptionId {
        INIT,
        BUY,
        LEAVE;

    }
}

