/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.edshipyard.rulecmd;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.Script;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.FleetAssignment;
import com.fs.starfarer.api.campaign.ai.FleetAssignmentDataAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import data.scripts.edshipyard.rulecmd.EDMagicBountyCommand;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;
import org.apache.log4j.Logger;
import org.magiclib.bounty.ActiveBounty;
import org.magiclib.bounty.MagicBountyIntel;

public class DestroyTradeFleetBountyCommand
extends EDMagicBountyCommand {
    private static final String BountyId = "edshipyard_DestroyTradeFleet";
    public static Logger log = Global.getLogger(DestroyTradeFleetBountyCommand.class);

    @Override
    public String getBountyId() {
        return BountyId;
    }

    @Override
    public boolean processBounty(ActiveBounty bounty) {
        ActiveBounty.Stage bountyStage = bounty.getStage();
        MagicBountyIntel intel = bounty.getIntel();
        if (bountyStage == ActiveBounty.Stage.Accepted) {
            try {
                Random r = new Random();
                final CampaignFleetAPI fleet = bounty.getFleet();
                Script fillCargoScript = new Script(){

                    public void run() {
                        try {
                            Random r = new Random();
                            fleet.getCargo().clear();
                            fleet.getCargo().addItems(CargoAPI.CargoItemType.RESOURCES, (Object)"gamma_core", 1.0f);
                            fleet.getCargo().addItems(CargoAPI.CargoItemType.RESOURCES, (Object)"heavy_machinery", 100.0f * r.nextFloat() + 20.0f);
                            fleet.getCargo().addItems(CargoAPI.CargoItemType.RESOURCES, (Object)"rare_metals", 100.0f * r.nextFloat() + 20.0f);
                            fleet.getCargo().addItems(CargoAPI.CargoItemType.RESOURCES, (Object)"metals", 200.0f * r.nextFloat() + 30.0f);
                            fleet.getCargo().addItems(CargoAPI.CargoItemType.RESOURCES, (Object)"volatiles", 50.0f * r.nextFloat() + 10.0f);
                            fleet.getCargo().addItems(CargoAPI.CargoItemType.RESOURCES, (Object)"organics", 300.0f * r.nextFloat() + 30.0f);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                };
                MarketAPI sourceMarket = ((FleetAssignmentDataAPI)bounty.getFleet().getAssignmentsCopy().get(0)).getTarget().getMarket();
                ArrayList<MarketAPI> markets = new ArrayList<MarketAPI>();
                for (MarketAPI market : Global.getSector().getEconomy().getMarketsCopy()) {
                    if (!market.getFactionId().equals("independent") || market.getId().equals(sourceMarket.getId())) continue;
                    markets.add(market);
                }
                Collections.shuffle(markets);
                MarketAPI destMarket = (MarketAPI)markets.get(0);
                fleet.clearAssignments();
                for (int i = 0; i < 150; ++i) {
                    fleet.addAssignment(FleetAssignment.ORBIT_PASSIVE, sourceMarket.getPrimaryEntity(), (float)(1.0 + 2.0 * Math.random()), "loading goods from " + sourceMarket.getName(), fillCargoScript);
                    fleet.addAssignment(FleetAssignment.DELIVER_RESOURCES, destMarket.getPrimaryEntity(), 1000.0f, "delivering goods from " + sourceMarket.getName() + " to " + destMarket.getName());
                    fleet.addAssignment(FleetAssignment.ORBIT_PASSIVE, destMarket.getPrimaryEntity(), (float)(1.0 + 2.0 * Math.random()), "preparing to depart for " + sourceMarket.getName());
                    fleet.addAssignment(FleetAssignment.GO_TO_LOCATION, sourceMarket.getPrimaryEntity(), 1000.0f, "returning to " + sourceMarket.getName() + " after delivering goods to " + destMarket.getName());
                }
            }
            catch (Exception e) {
                log.error((Object)"Error in DestroyTradeFleetBountyCommand.processBounty", (Throwable)e);
            }
        }
        return true;
    }
}

