/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.edshipyard.shipsystems;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.CollisionClass;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipSystemAPI;
import com.fs.starfarer.api.impl.combat.BaseShipSystemScript;
import com.fs.starfarer.api.plugins.ShipSystemStatsScript;
import com.fs.starfarer.api.util.IntervalUtil;
import java.awt.Color;

public class FieldShieldControlStats
extends BaseShipSystemScript {
    private ShipAPI ship;
    private ShipAPI module;
    private boolean shieldWasOnLastFrame = false;
    private boolean activated = false;
    private float accumulation = 0.0f;
    private final IntervalUtil tracker = new IntervalUtil(0.1f, 0.1f);
    public final String shieldModule = "edshipyard_retriever_shield";

    public boolean isUsable(ShipSystemAPI system, ShipAPI ship) {
        return ship != null && ship.isAlive() && this.module != null && this.module.isAlive() && !this.module.getFluxTracker().isOverloadedOrVenting();
    }

    public void init(MutableShipStatsAPI stats) {
        this.ship = (ShipAPI)stats.getEntity();
        if (this.ship != null && this.ship.isAlive() && this.ship.getChildModulesCopy() != null) {
            for (ShipAPI m : this.ship.getChildModulesCopy()) {
                if (!m.getHullSpec().getBaseHullId().equals("edshipyard_retriever_shield")) continue;
                this.module = m;
                break;
            }
        }
    }

    public void apply(MutableShipStatsAPI stats, String id, ShipSystemStatsScript.State state, float effectLevel) {
        if (this.ship == null) {
            this.init(stats);
            return;
        }
        if (!this.ship.isAlive()) {
            return;
        }
        if (this.module == null || !this.module.isAlive() || this.module.getShield() == null) {
            return;
        }
        if (Global.getCombatEngine().isPaused()) {
            return;
        }
        this.module.setCollisionClass(CollisionClass.FIGHTER);
        if (this.module.getShield().isOn()) {
            float hardflux = this.module.getFluxTracker().getHardFlux();
            this.tracker.advance(Global.getCombatEngine().getElapsedInLastFrame());
            if (this.tracker.intervalElapsed()) {
                hardflux += 40.0f;
            }
            this.accumulation += hardflux;
            float multiplier = (this.accumulation + 20000.0f) / 20000.0f;
            this.ship.getFluxTracker().increaseFlux(hardflux * multiplier, true);
            this.module.getFluxTracker().setHardFlux(0.0f);
            this.module.getShield().setInnerColor(new Color((int)Math.min(254.0f, 40.0f * multiplier + 20.0f), 50, 150, 175));
        } else {
            this.accumulation = 0.0f;
        }
        this.toggleShieldIfNecessary(state);
        if (this.module.getShield().isOn() != this.shieldWasOnLastFrame) {
            Global.getSoundPlayer().playSound("kfp", 0.5f, 0.75f, this.ship.getLocation(), this.ship.getVelocity());
        }
        this.shieldWasOnLastFrame = this.module.getShield().isOn();
    }

    private void toggleShieldIfNecessary(ShipSystemStatsScript.State state) {
        if (this.module.getFluxTracker().isOverloadedOrVenting() && this.module.getShield().isOn()) {
            this.module.getShield().toggleOff();
            return;
        }
        if (this.ship.getFluxTracker().isOverloadedOrVenting() && this.module.getShield().isOn()) {
            this.module.getShield().toggleOff();
            return;
        }
        if (state == ShipSystemStatsScript.State.ACTIVE) {
            if (!this.activated) {
                this.activated = true;
                if (this.module.getShield().isOn()) {
                    this.module.getShield().toggleOff();
                } else {
                    this.module.getShield().toggleOn();
                }
            }
        } else {
            this.activated = false;
        }
    }
}

