/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.edshipyard.shipsystems;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipSystemAPI;
import com.fs.starfarer.api.combat.WeaponAPI;
import com.fs.starfarer.api.impl.combat.BaseShipSystemScript;
import com.fs.starfarer.api.plugins.ShipSystemStatsScript;
import java.util.ArrayList;
import java.util.Random;
import org.lazywizard.lazylib.MathUtils;
import org.lwjgl.util.vector.Vector2f;

public class GrandSalvoStats
extends BaseShipSystemScript {
    private ShipAPI ship;
    private Random rng;
    private CombatEngineAPI engine;
    private ArrayList<Float> times;
    private ArrayList<Integer> currentFrames;
    private ArrayList<Integer> extraFrames;
    private ArrayList<WeaponAPI> guns;
    private float curTime = 0.0f;
    private float shootingTime = 0.0f;
    private float rof;

    public void init(MutableShipStatsAPI stats) {
        this.ship = (ShipAPI)stats.getEntity();
        this.engine = Global.getCombatEngine();
        this.rng = new Random();
        this.times = new ArrayList();
        this.currentFrames = new ArrayList();
        this.extraFrames = new ArrayList();
        this.guns = new ArrayList();
        ArrayList<WeaponAPI> weapons = new ArrayList<WeaponAPI>();
        for (WeaponAPI w : this.ship.getAllWeapons()) {
            if (!w.isDecorative() || !w.getDisplayName().contains("Hellborn")) continue;
            this.currentFrames.add(0);
            this.extraFrames.add(0);
            weapons.add(w);
        }
        float waitTime = 0.0f;
        if (!weapons.isEmpty()) {
            waitTime = 1.0f / (float)weapons.size();
        }
        block1: for (int i = 0; i < this.currentFrames.size(); ++i) {
            for (WeaponAPI w : weapons) {
                if (!w.getSlot().getId().contains(i + 1 + "")) continue;
                this.guns.add(w);
                this.times.add(Float.valueOf((float)(-i) * waitTime));
                continue block1;
            }
        }
        this.rof = 0.05f;
        this.rof *= 1.0f / this.ship.getMutableStats().getBallisticRoFMult().getModifiedValue();
        this.rof *= 1.0f / this.ship.getMutableStats().getTimeMult().getModifiedValue();
    }

    public void apply(MutableShipStatsAPI stats, String id, ShipSystemStatsScript.State state, float effectLevel) {
        float time;
        int i;
        if (this.ship == null) {
            this.init(stats);
        }
        if (this.engine == null) {
            return;
        }
        if (this.engine.isPaused()) {
            return;
        }
        if (state == ShipSystemStatsScript.State.IN) {
            this.curTime += Global.getCombatEngine().getElapsedInLastFrame();
            for (i = 0; i < this.times.size(); ++i) {
                time = this.times.get(i).floatValue() + this.curTime;
                if (time <= 0.0f) {
                    this.currentFrames.set(i, 0);
                    continue;
                }
                if (time > 1.0f) {
                    if ((float)this.extraFrames.get(i).intValue() > Math.min(1.0f, (1.0f - effectLevel) * 5.0f)) {
                        this.extraFrames.set(i, 0);
                        this.currentFrames.set(i, this.currentFrames.get(i) + 1);
                        if (this.currentFrames.get(i) < 54) continue;
                        this.currentFrames.set(i, 50);
                        continue;
                    }
                    this.extraFrames.set(i, this.extraFrames.get(i) + 1);
                    continue;
                }
                if (this.currentFrames.get(i) == 0) {
                    Global.getSoundPlayer().playSound("system_fast_missile_racks", 1.0f, 1.0f, this.ship.getLocation(), this.ship.getVelocity());
                }
                this.currentFrames.set(i, (int)Math.min(50.0f, time * 50.0f));
            }
            this.shootingTime = 0.0f;
        } else if (state == ShipSystemStatsScript.State.ACTIVE) {
            for (i = 0; i < this.times.size(); ++i) {
                this.currentFrames.set(i, this.currentFrames.get(i) + 1);
                if (this.currentFrames.get(i) < 54) continue;
                this.currentFrames.set(i, 50);
            }
            this.curTime = 0.0f;
            this.shootingTime += Global.getCombatEngine().getElapsedInLastFrame();
            while (this.shootingTime > this.rof) {
                this.shootingTime -= this.rof;
                for (i = 0; i < this.guns.size(); ++i) {
                    Global.getSoundPlayer().playSound("hellbore_fire", 1.0f, 1.0f, this.ship.getLocation(), this.ship.getVelocity());
                    float aim = this.guns.get(i).getArcFacing() + this.ship.getFacing();
                    this.engine.spawnProjectile(this.ship, this.guns.get(i), "edshipyard_BIGGUN", MathUtils.getPoint((Vector2f)this.guns.get(i).getLocation(), (float)65.0f, (float)aim), aim - 10.0f + this.rng.nextFloat() * 20.0f, new Vector2f());
                }
            }
        } else if (this.currentFrames.get(this.currentFrames.size() - 1) > 0) {
            this.curTime += Global.getCombatEngine().getElapsedInLastFrame();
            for (i = 0; i < this.times.size(); ++i) {
                time = this.times.get(i).floatValue() + this.curTime;
                if (time >= 3.0f) {
                    this.currentFrames.set(i, 0);
                    continue;
                }
                if (time < 2.0f) {
                    if ((float)this.extraFrames.get(i).intValue() > Math.min(1.0f, (1.0f - effectLevel) * 10.0f)) {
                        this.extraFrames.set(i, 0);
                        this.currentFrames.set(i, this.currentFrames.get(i) + 1);
                        if (this.currentFrames.get(i) < 54) continue;
                        this.currentFrames.set(i, 50);
                        continue;
                    }
                    this.extraFrames.set(i, this.extraFrames.get(i) + 1);
                    continue;
                }
                if (this.currentFrames.get(i) >= 50) {
                    Global.getSoundPlayer().playSound("system_reserve_wing", 1.0f, 1.0f, this.ship.getLocation(), this.ship.getVelocity());
                }
                this.currentFrames.set(i, (int)Math.max(0.0f, 50.0f - (time - 2.0f) * 50.0f));
            }
        } else {
            this.curTime = 0.0f;
        }
        for (i = 0; i < this.guns.size(); ++i) {
            this.guns.get(i).getAnimation().setFrame(Math.max(this.currentFrames.get(i), 0));
        }
    }

    public String getInfoText(ShipSystemAPI system, ShipAPI ship) {
        if (!this.isUsable(system, ship)) {
            return "RELOADING";
        }
        return null;
    }
}

