/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.edshipyard.shipsystems;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.CollisionClass;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.DamageAPI;
import com.fs.starfarer.api.combat.DamageType;
import com.fs.starfarer.api.combat.DamagingProjectileAPI;
import com.fs.starfarer.api.combat.MissileAPI;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ViewportAPI;
import com.fs.starfarer.api.combat.WeaponAPI;
import com.fs.starfarer.api.combat.listeners.DamageTakenModifier;
import com.fs.starfarer.api.impl.combat.BaseShipSystemScript;
import com.fs.starfarer.api.loading.ProjectileSpawnType;
import com.fs.starfarer.api.plugins.ShipSystemStatsScript;
import com.fs.starfarer.api.util.IntervalUtil;
import com.fs.starfarer.api.util.Misc;
import data.scripts.edshipyard.shipsystems.GravityGunShipSystemUtil;
import data.scripts.edshipyard.util.Area;
import data.scripts.edshipyard.util.DebugRender;
import data.scripts.edshipyard.util.Quadrilateral;
import java.awt.Color;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import org.dark.shaders.distortion.DistortionAPI;
import org.dark.shaders.distortion.DistortionShader;
import org.dark.shaders.distortion.RippleDistortion;
import org.lazywizard.lazylib.MathUtils;
import org.lazywizard.lazylib.VectorUtils;
import org.lazywizard.lazylib.combat.CombatUtils;
import org.lazywizard.lazylib.combat.entities.SimpleEntity;
import org.lazywizard.lazylib.opengl.ColorUtils;
import org.lazywizard.lazylib.opengl.DrawUtils;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.Vector2f;

public class GravityGunShipSystem
extends BaseShipSystemScript {
    private static final float PullForceUnitsPerSecond = 25000.0f;
    private static final float REDUCED_EXPLOSION_MULT = 0.01f;
    private static final float SingularityWidth = 12.0f;
    public static final Color JITTER_COLOR = new Color(245, 1, 1, 110);
    private boolean fullEffect = false;
    private boolean zeroEffect = true;
    private boolean discharging = false;
    private ShipSystemStatsScript.State lastState = ShipSystemStatsScript.State.IDLE;
    private final IntervalUtil singularityCoreInterval = new IntervalUtil(0.03f, 0.03f);
    private final IntervalUtil pullInterval = new IntervalUtil(0.05f, 0.05f);
    private final String LocalDataKey = "GravityGunShipSystem-" + UUID.randomUUID();

    private LocalData getLocalData() {
        LocalData localData = (LocalData)Global.getCombatEngine().getCustomData().get(this.LocalDataKey);
        if (localData == null) {
            localData = new LocalData();
            Global.getCombatEngine().getCustomData().put(this.LocalDataKey, localData);
        }
        return localData;
    }

    public void apply(MutableShipStatsAPI stats, String id, ShipSystemStatsScript.State state, float effectLevel) {
        ShipAPI thisShip = (ShipAPI)stats.getEntity();
        if (thisShip == null) {
            return;
        }
        if (!thisShip.hasListenerOfClass(ShipExplosionDamageReducerListener.class)) {
            thisShip.addListener((Object)new ShipExplosionDamageReducerListener());
            List modules = thisShip.getChildModulesCopy();
            if (modules != null) {
                for (ShipAPI module : modules) {
                    if (module == null) continue;
                    module.addListener((Object)new ShipExplosionDamageReducerListener());
                }
            }
        }
        LocalData localData = this.getLocalData();
        float amount = Global.getCombatEngine().getElapsedInLastFrame();
        if (state == ShipSystemStatsScript.State.ACTIVE || state == ShipSystemStatsScript.State.IN || state == ShipSystemStatsScript.State.OUT) {
            stats.getEngineDamageTakenMult().modifyMult(id, 1.0f - effectLevel * 0.7f);
        }
        Quadrilateral pullArea = GravityGunShipSystemUtil.getPullArea(thisShip);
        Quadrilateral pushArea = GravityGunShipSystemUtil.getPushArea(thisShip);
        Area stopArea = GravityGunShipSystemUtil.getStopArea(thisShip);
        HashMap<CombatEntityAPI, GravityGunShipSystemUtil.DistanceAnglePair> thisFrameStoppedEntityLocation = new HashMap<CombatEntityAPI, GravityGunShipSystemUtil.DistanceAnglePair>();
        if (state == ShipSystemStatsScript.State.IN || state == ShipSystemStatsScript.State.ACTIVE) {
            this.discharging = false;
            if (this.zeroEffect) {
                Global.getSoundPlayer().playSound("ed_riptide_beamenable", 1.0f, 1.5f, thisShip.getLocation(), new Vector2f());
            }
            this.renderPullEffects(amount, effectLevel, thisShip, pullArea);
            this.renderSingularityCore(state, amount, effectLevel, thisShip);
            for (CombatEntityAPI entity : CombatUtils.getEntitiesWithinRange((Vector2f)thisShip.getLocation(), (float)1900.0f)) {
                if (entity == null || entity == thisShip || !GravityGunShipSystemUtil.isValidForBeamToAffect(entity)) continue;
                if (stopArea.contains(entity)) {
                    entity.getVelocity().x = thisShip.getVelocity().x;
                    entity.getVelocity().y = thisShip.getVelocity().y;
                    DebugRender.renderIfDebug(entity.getLocation(), Color.black);
                    GravityGunShipSystemUtil.DistanceAnglePair lastLocation = (GravityGunShipSystemUtil.DistanceAnglePair)localData.lastFrameStoppedEntityLocation.get(entity);
                    if (lastLocation != null) {
                        this.setShipLocation(entity, lastLocation, thisShip);
                        thisFrameStoppedEntityLocation.put(entity, lastLocation);
                        continue;
                    }
                    thisFrameStoppedEntityLocation.put(entity, this.getEntityOffsetFromCenter(entity, thisShip));
                    continue;
                }
                if (!pullArea.containsPoint(entity.getLocation())) continue;
                CombatUtils.applyForce((CombatEntityAPI)entity, (float)VectorUtils.getAngle((Vector2f)entity.getLocation(), (Vector2f)thisShip.getLocation()), (float)(25000.0f * amount * effectLevel));
                DebugRender.renderIfDebug(entity.getLocation(), Color.red);
                if (!(entity instanceof MissileAPI) || entity.getCollisionClass() != CollisionClass.MISSILE_NO_FF) continue;
                entity.setCollisionClass(CollisionClass.MISSILE_FF);
            }
        } else if (state == ShipSystemStatsScript.State.OUT && this.fullEffect && this.lastState != ShipSystemStatsScript.State.OUT) {
            this.discharging = true;
            Global.getSoundPlayer().playSound("ed_riptide_dischargepowerup", 1.0f, 2.0f, thisShip.getLocation(), new Vector2f());
            thisShip.setJitter((Object)this, JITTER_COLOR, 0.75f, 3, 50.0f);
            stats.getBeamWeaponDamageMult().modifyMult(id, 2.0f);
            thisShip.setWeaponGlow(2.0f, Misc.setAlpha((Color)JITTER_COLOR, (int)200), EnumSet.of(WeaponAPI.WeaponType.ENERGY));
            for (int i = 0; i < 4; ++i) {
                this.renderCoreArc(thisShip);
            }
        } else if (state == ShipSystemStatsScript.State.OUT && this.lastState != ShipSystemStatsScript.State.OUT && (double)effectLevel > 0.3) {
            Global.getSoundPlayer().playSound("ed_riptide_beamdisable", 1.0f, 1.5f, thisShip.getLocation(), new Vector2f());
        }
        pullArea.renderIfDebug(Color.GREEN);
        pushArea.renderIfDebug(Color.BLUE);
        stopArea.renderIfDebug(Color.RED);
        this.fullEffect = (double)effectLevel > 0.998 && (state == ShipSystemStatsScript.State.IN || state == ShipSystemStatsScript.State.ACTIVE);
        this.zeroEffect = (double)effectLevel < 0.1 && state == ShipSystemStatsScript.State.OUT;
        localData.lastFrameStoppedEntityLocation = thisFrameStoppedEntityLocation;
        this.lastState = state;
    }

    public void unapply(MutableShipStatsAPI stats, String id) {
        if (stats == null || id == null) {
            return;
        }
        if (this.discharging) {
            this.discharging = false;
            ShipAPI thisShip = (ShipAPI)stats.getEntity();
            thisShip.setWeaponGlow(0.0f, Misc.setAlpha((Color)JITTER_COLOR, (int)200), EnumSet.of(WeaponAPI.WeaponType.ENERGY));
            Quadrilateral pullArea = GravityGunShipSystemUtil.getPullArea(thisShip);
            Quadrilateral pushArea = GravityGunShipSystemUtil.getPushArea(thisShip);
            Area stopArea = GravityGunShipSystemUtil.getStopArea(thisShip);
            this.renderPushEffects(thisShip, pushArea, pullArea);
            Random r = new Random();
            for (CombatEntityAPI entity : CombatUtils.getEntitiesWithinRange((Vector2f)thisShip.getLocation(), (float)620.0f)) {
                if (entity == null || entity == thisShip || !GravityGunShipSystemUtil.isValidForBeamToAffect(entity) || !pushArea.containsPoint(entity.getLocation()) && !stopArea.contains(entity)) continue;
                Vector2f delta = Vector2f.sub((Vector2f)entity.getLocation(), (Vector2f)thisShip.getLocation(), null);
                delta.normalise(delta);
                float ejectSpeed = this.getEjectSpeed(entity) + r.nextFloat() * 100.0f;
                delta.scale(ejectSpeed *= this.getEjectSpeedMultiplier(entity));
                Vector2f.add((Vector2f)delta, (Vector2f)entity.getVelocity(), (Vector2f)entity.getVelocity());
                float rotationSpeed = r.nextFloat() * 15.0f + 20.0f;
                if (r.nextBoolean()) {
                    rotationSpeed *= -1.0f;
                }
                entity.setAngularVelocity(rotationSpeed);
            }
            thisShip.getFluxTracker().beginOverloadWithTotalBaseDuration(2.0f);
            Global.getSoundPlayer().playSound("ed_riptide_discharge", 1.0f, 1.5f, thisShip.getLocation(), new Vector2f());
        }
        stats.getEngineDamageTakenMult().unmodify(id);
    }

    private float getEjectSpeed(CombatEntityAPI entityAPI) {
        if (entityAPI instanceof ShipAPI && ((ShipAPI)entityAPI).isAlive()) {
            ShipAPI ship = (ShipAPI)entityAPI;
            switch (ship.getHullSize()) {
                case FIGHTER: {
                    return 475.0f;
                }
                case FRIGATE: {
                    return 400.0f;
                }
                case DESTROYER: {
                    return 370.0f;
                }
                case CRUISER: {
                    return 320.0f;
                }
                case CAPITAL_SHIP: {
                    return 300.0f;
                }
            }
            return 450.0f;
        }
        return 475.0f;
    }

    private float getEjectSpeedMultiplier(CombatEntityAPI entityAPI) {
        return entityAPI.getOwner() == 100 ? 1.5f : 1.0f;
    }

    private GravityGunShipSystemUtil.DistanceAnglePair getEntityOffsetFromCenter(CombatEntityAPI entity, ShipAPI thisShip) {
        float angle = VectorUtils.getAngle((Vector2f)thisShip.getLocation(), (Vector2f)entity.getLocation());
        float distance = MathUtils.getDistance((Vector2f)thisShip.getLocation(), (Vector2f)entity.getLocation());
        return new GravityGunShipSystemUtil.DistanceAnglePair(distance, angle - thisShip.getFacing(), entity.getFacing() - thisShip.getFacing());
    }

    private void setShipLocation(CombatEntityAPI entity, GravityGunShipSystemUtil.DistanceAnglePair oldOffset, ShipAPI thisShip) {
        double angleAsRadians = Math.toRadians(thisShip.getFacing() + oldOffset.angle);
        double xIdent = Math.cos(angleAsRadians);
        double yIdent = Math.sin(angleAsRadians);
        Vector2f location = entity.getLocation();
        location.x = (float)(oldOffset.distance * xIdent + (double)thisShip.getLocation().x);
        location.y = (float)(oldOffset.distance * yIdent + (double)thisShip.getLocation().y);
        entity.setFacing(oldOffset.entityFacing + thisShip.getFacing());
    }

    private void renderPushEffects(ShipAPI thisShip, Quadrilateral pushArea, Quadrilateral pullArea) {
        CombatEngineAPI engine;
        int i;
        for (i = 0; i < 100; ++i) {
            Vector2f pointLoc = pushArea.getRandomPointInArea();
            Vector2f vel = Vector2f.sub((Vector2f)pointLoc, (Vector2f)thisShip.getLocation(), null).normalise(null);
            double speedScalar = 800.0 * (Math.random() + 0.2);
            vel.x = (float)((double)vel.x * speedScalar);
            vel.y = (float)((double)vel.y * speedScalar);
            CombatEngineAPI engine2 = Global.getCombatEngine();
            engine2.addSmoothParticle(pointLoc, Vector2f.add((Vector2f)vel, (Vector2f)thisShip.getVelocity(), (Vector2f)vel), 6.0f + (float)Math.random() * 6.0f, Math.max(1.0f, (float)(Math.random() + 0.3)), 0.4f + (float)Math.random(), Color.WHITE);
        }
        for (i = 0; i < 7; ++i) {
            engine = Global.getCombatEngine();
            engine.spawnEmpArc(thisShip, pushArea.getRandomPointInArea(), null, (CombatEntityAPI)new SimpleEntity(pushArea.getRandomPointInArea()), DamageType.ENERGY, 0.0f, 100.0f, 10000.0f, null, 10.0f, Color.CYAN, Color.WHITE);
        }
        for (i = 0; i < 4; ++i) {
            engine = Global.getCombatEngine();
            engine.spawnEmpArc(thisShip, pushArea.getRandomPointInArea(), null, (CombatEntityAPI)new SimpleEntity(pullArea.getRandomPointInArea()), DamageType.ENERGY, 0.0f, 100.0f, 10000.0f, null, 10.0f, Color.CYAN, Color.WHITE);
        }
        float fadeTime = 0.5f;
        float size = 120.0f;
        RippleDistortion ripple = new RippleDistortion(this.getCoreLocation(thisShip), thisShip.getVelocity());
        ripple.setSize(size);
        ripple.setIntensity(size * 0.3f);
        ripple.setFrameRate(60.0f / fadeTime);
        ripple.fadeInSize(fadeTime * 1.2f);
        ripple.fadeOutIntensity(fadeTime);
        ripple.setSize(size * 0.2f);
        DistortionShader.addDistortion((DistortionAPI)ripple);
    }

    private Vector2f getCoreLocation(ShipAPI thisShip) {
        Vector2f location = thisShip.getLocation();
        double angleAsRadians = Math.toRadians(thisShip.getFacing());
        float distance = -41.0f;
        return new Vector2f(location.x + (float)((double)distance * Math.cos(angleAsRadians)), location.y + (float)((double)distance * Math.sin(angleAsRadians)));
    }

    private void renderSingularityCore(ShipSystemStatsScript.State state, float amount, float effectLevel, ShipAPI thisShip) {
        if (state != ShipSystemStatsScript.State.IN && state != ShipSystemStatsScript.State.ACTIVE) {
            return;
        }
        this.singularityCoreInterval.advance(amount);
        CombatEngineAPI engine = Global.getCombatEngine();
        Vector2f location = this.getCoreLocation(thisShip);
        ViewportAPI viewport = Global.getCombatEngine().getViewport();
        GL11.glPushAttrib((int)1048575);
        int width = (int)((float)Display.getWidth() * Display.getPixelScaleFactor());
        int height = (int)((float)Display.getHeight() * Display.getPixelScaleFactor());
        GL11.glViewport((int)0, (int)0, (int)width, (int)height);
        GL11.glMatrixMode((int)5889);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        GL11.glOrtho((double)viewport.getLLX(), (double)(viewport.getLLX() + viewport.getVisibleWidth()), (double)viewport.getLLY(), (double)(viewport.getLLY() + viewport.getVisibleHeight()), (double)-1.0, (double)1.0);
        GL11.glMatrixMode((int)5888);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glEnable((int)2848);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glTranslatef((float)0.01f, (float)0.01f, (float)0.0f);
        ColorUtils.glColor((Color)Color.BLACK);
        DrawUtils.drawCircle((float)location.x, (float)location.y, (float)(12.0f * effectLevel), (int)30, (boolean)true);
        GL11.glDisable((int)3042);
        GL11.glMatrixMode((int)5888);
        GL11.glPopMatrix();
        GL11.glMatrixMode((int)5889);
        GL11.glPopMatrix();
        GL11.glPopAttrib();
        if (!this.singularityCoreInterval.intervalElapsed()) {
            return;
        }
        if (Math.random() + (double)effectLevel > 1.2) {
            Vector2f particleStart = MathUtils.getPointOnCircumference((Vector2f)location, (float)30.0f, (float)((float)Math.random() * 360.0f));
            Vector2f vel = Vector2f.sub((Vector2f)location, (Vector2f)particleStart, null);
            vel = vel.normalise(vel);
            vel.x *= 100.0f;
            vel.y *= 100.0f;
            engine.addSmoothParticle(particleStart, Vector2f.add((Vector2f)vel, (Vector2f)thisShip.getVelocity(), (Vector2f)vel), 3.0f + (float)Math.random() * 3.0f, 1.0f, 0.3f, Color.WHITE);
            if (Math.random() > 0.98) {
                this.renderCoreArc(thisShip);
            }
        }
    }

    private void renderCoreArc(ShipAPI thisShip) {
        CombatEngineAPI engine = Global.getCombatEngine();
        Vector2f location = this.getCoreLocation(thisShip);
        engine.spawnEmpArc(thisShip, MathUtils.getPointOnCircumference((Vector2f)location, (float)30.0f, (float)((float)Math.random() * 360.0f)), null, (CombatEntityAPI)new SimpleEntity(location), DamageType.ENERGY, 0.0f, 0.0f, 10000.0f, null, 10.0f, Color.WHITE, Color.WHITE);
    }

    private void renderPullEffects(float amount, float effectLevel, ShipAPI thisShip, Quadrilateral pullArea) {
        this.pullInterval.advance(amount);
        if (!this.pullInterval.intervalElapsed()) {
            return;
        }
        for (int i = 0; i < 15; ++i) {
            if (Math.random() + (double)effectLevel < 0.7) continue;
            Vector2f pointLoc = pullArea.getRandomPointInArea();
            Vector2f vel = Vector2f.sub((Vector2f)thisShip.getLocation(), (Vector2f)pointLoc, null).normalise(null);
            double speedScalar = 500.0 * (Math.random() + 0.2) * (double)effectLevel;
            vel.x = (float)((double)vel.x * speedScalar);
            vel.y = (float)((double)vel.y * speedScalar);
            CombatEngineAPI engine = Global.getCombatEngine();
            engine.addSmoothParticle(pointLoc, Vector2f.add((Vector2f)vel, (Vector2f)thisShip.getVelocity(), (Vector2f)vel), 6.0f + (float)Math.random() * 6.0f, Math.max(1.0f, (float)(Math.random() + 0.3)), 0.4f, Color.WHITE);
        }
    }

    private class LocalData {
        private Map<CombatEntityAPI, GravityGunShipSystemUtil.DistanceAnglePair> lastFrameStoppedEntityLocation = new HashMap<CombatEntityAPI, GravityGunShipSystemUtil.DistanceAnglePair>();

        private LocalData() {
        }
    }

    public static class ShipExplosionDamageReducerListener
    implements DamageTakenModifier {
        public String modifyDamageTaken(Object param, CombatEntityAPI target, DamageAPI damage, Vector2f point, boolean shieldHit) {
            DamagingProjectileAPI proj;
            if (param instanceof DamagingProjectileAPI && (proj = (DamagingProjectileAPI)param).getDamageType().equals((Object)DamageType.HIGH_EXPLOSIVE) && proj.getProjectileSpecId() == null && !proj.getSource().isAlive() && proj.getSpawnType().equals((Object)ProjectileSpawnType.OTHER) && MathUtils.getDistance((Vector2f)proj.getSpawnLocation(), (Vector2f)proj.getSource().getLocation()) < 8.0f) {
                String statModId = this.getClass().getName();
                damage.getModifier().modifyMult(statModId, 0.01f);
                return statModId;
            }
            return null;
        }
    }
}

