/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.edshipyard.shipsystems;

import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import data.scripts.edshipyard.util.Area;
import data.scripts.edshipyard.util.Quadrilateral;
import java.awt.Color;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.Vector2f;

public class GravityGunShipSystemUtil {
    public static final int PullRange = 1700;
    public static final int PullWidth = 58;
    public static final int PushRange = 420;
    public static final int PushWidth = 200;
    public static final int StopRange = 170;

    public static Quadrilateral getPullArea(ShipAPI ship) {
        float pullStartOffset = 160.0f;
        return GravityGunShipSystemUtil.getRectangle(GravityGunShipSystemUtil.getLocationInFront(pullStartOffset, ship), 1700.0f - pullStartOffset, 58.0f, ship.getFacing());
    }

    public static Quadrilateral getPushArea(ShipAPI ship) {
        float pushStartOffset = 100.0f;
        return GravityGunShipSystemUtil.getRectangle(GravityGunShipSystemUtil.getLocationInFront(pushStartOffset, ship), 420.0f - pushStartOffset, 200.0f, ship.getFacing());
    }

    public static Area getStopArea(ShipAPI ship) {
        Vector2f start = ship.getLocation();
        float angle = ship.getFacing();
        Area ret = new Area(470.0f, start);
        ret.boxes.add(GravityGunShipSystemUtil.getRectangle(start, 170.0f, 200.0f, angle));
        ArrayList<Vector2f> points = new ArrayList<Vector2f>();
        double angleAsRadians = Math.toRadians(angle);
        float xIdent = (float)Math.cos(angleAsRadians);
        float yIdent = (float)Math.sin(angleAsRadians);
        start = Vector2f.add((Vector2f)start, (Vector2f)new Vector2f(xIdent * 150.0f, yIdent * 150.0f), null);
        points.add(start);
        angleAsRadians = Math.toRadians(angle + 90.0f);
        float xNormalIdent = (float)Math.cos(angleAsRadians);
        float yNormalIdent = (float)Math.sin(angleAsRadians);
        float xOffsetFromCenter = xNormalIdent * 24.0f;
        float yOffsetFromCenter = yNormalIdent * 24.0f;
        int max = 4;
        for (int i = 1; i <= max; ++i) {
            points.add(new Vector2f(start.x + xOffsetFromCenter * (float)i, start.y + yOffsetFromCenter * (float)i));
            points.add(new Vector2f(start.x - xOffsetFromCenter * (float)i, start.y - yOffsetFromCenter * (float)i));
        }
        int boxAngle = 20;
        float xUpRightOffsetFromCenter = (float)Math.cos(Math.toRadians(angle - (float)boxAngle)) * 40.0f;
        float yUpRightOffsetFromCenter = (float)Math.sin(Math.toRadians(angle - (float)boxAngle)) * 40.0f;
        float xUpLeftOffsetFromCenter = (float)Math.cos(Math.toRadians(angle + (float)boxAngle)) * 40.0f;
        float yUpLeftOffsetFromCenter = (float)Math.sin(Math.toRadians(angle + (float)boxAngle)) * 40.0f;
        Vector2f leftStart = (Vector2f)points.get(points.size() - 1);
        Vector2f rightStart = (Vector2f)points.get(points.size() - 2);
        ret.boxes.add(GravityGunShipSystemUtil.getRectangle(leftStart, 110.0f, 40.0f, angle - (float)boxAngle));
        ret.boxes.add(GravityGunShipSystemUtil.getRectangle(rightStart, 110.0f, 40.0f, angle + (float)boxAngle));
        for (int i = 1; i < 4; ++i) {
            points.add(new Vector2f(leftStart.x + xUpRightOffsetFromCenter * (float)i, leftStart.y + yUpRightOffsetFromCenter * (float)i));
            points.add(new Vector2f(rightStart.x + xUpLeftOffsetFromCenter * (float)i, rightStart.y + yUpLeftOffsetFromCenter * (float)i));
        }
        ret.points.addAll(points);
        return ret;
    }

    private static Quadrilateral getRectangle(Vector2f start, float range, float width, float angle) {
        double angleAsRadians = Math.toRadians(angle);
        float xIdent = (float)Math.cos(angleAsRadians);
        float yIdent = (float)Math.sin(angleAsRadians);
        start = Vector2f.add((Vector2f)start, (Vector2f)new Vector2f(xIdent * 15.0f, yIdent * 15.0f), null);
        angleAsRadians = Math.toRadians(angle + 90.0f);
        float xNormalIdent = (float)Math.cos(angleAsRadians);
        float yNormalIdent = (float)Math.sin(angleAsRadians);
        float xOffsetFromCenter = xNormalIdent * width;
        float yOffsetFromCenter = yNormalIdent * width;
        Quadrilateral ret = new Quadrilateral();
        ret.bottomLeft = new Vector2f(start.x + xOffsetFromCenter, start.y + yOffsetFromCenter);
        ret.bottomRight = new Vector2f(start.x - xOffsetFromCenter, start.y - yOffsetFromCenter);
        ret.topLeft = Vector2f.add((Vector2f)ret.bottomLeft, (Vector2f)new Vector2f(xIdent * range, yIdent * range), null);
        ret.topRight = Vector2f.add((Vector2f)ret.bottomRight, (Vector2f)new Vector2f(xIdent * range, yIdent * range), null);
        return ret;
    }

    public static boolean isValidForBeamToAffect(CombatEntityAPI entityAPI) {
        if (entityAPI instanceof ShipAPI) {
            ShipAPI ship = (ShipAPI)entityAPI;
            if (ship.getParentStation() != null || ship.getVariant().getHullMods().contains("axialrotation")) {
                return false;
            }
            if (ship.isPhased()) {
                return false;
            }
        }
        return true;
    }

    public static Color getColorAtLocation(int x, int y) {
        ByteBuffer RGB = ByteBuffer.allocateDirect(3);
        try {
            GL11.glReadPixels((int)x, (int)y, (int)1, (int)1, (int)6407, (int)5121, (ByteBuffer)RGB);
            return new Color((float)RGB.get(0) / 255.0f, (float)RGB.get(1) / 255.0f, (float)RGB.get(2) / 255.0f);
        }
        catch (RuntimeException e) {
            return Color.BLACK;
        }
    }

    public static Vector2f getLocationInFront(float distance, ShipAPI ship) {
        double angleAsRadians = Math.toRadians(ship.getFacing());
        return new Vector2f(ship.getLocation().x + (float)((double)distance * Math.cos(angleAsRadians)), ship.getLocation().y + (float)((double)distance * Math.sin(angleAsRadians)));
    }

    static class DistanceAnglePair {
        public double distance;
        public float angle;
        public float entityFacing;

        public DistanceAnglePair(float distance, float angle, float entityFacing) {
            this.distance = distance;
            this.angle = angle;
            this.entityFacing = entityFacing;
        }

        public String toString() {
            return "DistanceAnglePair{distance=" + this.distance + ", angle=" + this.angle + ", entityFacing=" + this.entityFacing + '}';
        }
    }
}

