/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.edshipyard.shipsystems;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipwideAIFlags;
import com.fs.starfarer.api.impl.combat.BaseShipSystemScript;
import com.fs.starfarer.api.plugins.ShipSystemStatsScript;
import com.fs.starfarer.api.util.IntervalUtil;
import data.scripts.edshipyard.util.StolenUtils;
import java.awt.Color;
import java.util.Random;

public class IllusionStats
extends BaseShipSystemScript {
    public final Color JITTER_COLOR = new Color(125, 50, 150, 255);
    public final Color GLOW_COLOR = new Color(175, 75, 175);
    public ShipAPI ship;
    public Random rng;
    public CombatEngineAPI engine;
    public int team;
    public boolean glitched;
    private final IntervalUtil interval = new IntervalUtil(2.0f, 5.0f);

    public void init(MutableShipStatsAPI stats) {
        this.ship = (ShipAPI)stats.getEntity();
        this.engine = Global.getCombatEngine();
        this.rng = new Random();
        this.glitched = false;
        this.team = this.ship.getOwner();
    }

    public void apply(MutableShipStatsAPI stats, String id, ShipSystemStatsScript.State state, float effectLevel) {
        if (this.ship == null) {
            this.init(stats);
        }
        if (this.engine == null) {
            return;
        }
        if (!this.ship.isAlive()) {
            this.engine.removeEntity((CombatEntityAPI)this.ship);
        }
        float amount = Global.getCombatEngine().getElapsedInLastFrame();
        if (this.engine.isPaused()) {
            amount = 0.0f;
            return;
        }
        this.interval.advance(amount);
        if (this.interval.intervalElapsed() && this.rng.nextFloat() > 0.75f) {
            this.ship.getAIFlags().setFlag(ShipwideAIFlags.AIFlags.BACK_OFF, this.rng.nextFloat() * 5.0f);
            this.ship.getAIFlags().setFlag(ShipwideAIFlags.AIFlags.BACKING_OFF, this.rng.nextFloat() * 5.0f);
            this.ship.getAIFlags().setFlag(ShipwideAIFlags.AIFlags.RUN_QUICKLY, this.rng.nextFloat() * 5.0f);
            this.ship.getAIFlags().setFlag(ShipwideAIFlags.AIFlags.PHASE_ATTACK_RUN_TIMEOUT, this.rng.nextFloat() * 5.0f);
            this.ship.getAIFlags().setFlag(ShipwideAIFlags.AIFlags.DO_NOT_PURSUE, this.rng.nextFloat() * 5.0f);
            this.ship.getAIFlags().removeFlag(ShipwideAIFlags.AIFlags.HARASS_MOVE_IN);
            this.ship.getAIFlags().removeFlag(ShipwideAIFlags.AIFlags.IN_ATTACK_RUN);
        }
        if (this.glitched) {
            if (effectLevel <= 0.0f) {
                StolenUtils.setArmorPercentage(this.ship, 1.0f);
                this.ship.setHitpoints(this.ship.getMaxHitpoints());
                this.ship.setPhased(false);
                this.engine.removeEntity((CombatEntityAPI)this.ship);
                this.glitched = false;
            } else {
                this.ship.setJitter((Object)this.ship, this.JITTER_COLOR, 1.0f - effectLevel * 0.5f, 8, this.ship.getCollisionRadius() * (1.1f - effectLevel) * 2.5f);
            }
        } else if (StolenUtils.getArmorPercent(this.ship) < 1.0f) {
            this.glitched = true;
            this.ship.setPhased(true);
            this.ship.beginLandingAnimation(this.ship.getDroneSource());
            this.ship.useSystem();
        }
    }
}

