/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.edshipyard.shipsystems;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.CollisionClass;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.DamageType;
import com.fs.starfarer.api.combat.MissileAPI;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipSystemAPI;
import com.fs.starfarer.api.impl.combat.BaseShipSystemScript;
import com.fs.starfarer.api.plugins.ShipSystemStatsScript;
import com.fs.starfarer.api.util.IntervalUtil;
import data.dcr.edshipyard.DamageReportManagerV1;
import data.scripts.edshipyard.util.Utils;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.lazywizard.lazylib.CollisionUtils;
import org.lazywizard.lazylib.MathUtils;
import org.lazywizard.lazylib.VectorUtils;
import org.lazywizard.lazylib.combat.CombatUtils;
import org.lwjgl.util.vector.Vector2f;

public class MagneticBurstStats
extends BaseShipSystemScript {
    public ShipAPI target;
    public ShipAPI lockedTarget;
    public final float BASE_RANGE = 700.0f;
    public final float RADIUS_PER_BOLT = 25.0f;
    public final float DAMAGE_PER_BOLT = 50.0f;
    public final float EMP_PER_BOLT = 200.0f;
    public final float BLAST_AREA_RADIUS_SCALE = 3.0f;
    public final float BLAST_AREA_FLAT = 300.0f;
    public final float BLAST_MISSILE_DAMAGE = 200.0f;
    public final float BLAST_MAX_DAMAGE = 1000.0f;
    public final float BLAST_MISSILE_EMP = 200.0f;
    public final int BLAST_MAX_MISSILE_TARGETS = 15;
    private final Color EMP_CORE_COLOR_STANDARD = new Color(255, 175, 225, 255);
    private final Color EMP_FRINGE_COLOR_STANDARD = new Color(255, 175, 225, 200);
    private final Color JITTER_UNDER_COLOR_STANDARD = new Color(255, 175, 225, 100);
    private final Color JITTER_OVER_COLOR_STANDARD = new Color(255, 175, 225, 225);
    private final IntervalUtil interval = new IntervalUtil(0.25f, 0.33f);
    private boolean fired = false;

    private int isTargetValid(ShipAPI ship, ShipAPI target) {
        if (target == null || ship == null || target.getOwner() == 100) {
            return 2;
        }
        float range = 700.0f + 200.0f * (float)this.getSize(ship);
        if (MathUtils.getDistance((CombatEntityAPI)ship, (CombatEntityAPI)target) > range) {
            return 1;
        }
        if (target.getOwner() == ship.getOwner()) {
            return 3;
        }
        if (!target.isAlive()) {
            return 4;
        }
        if (target.isStation()) {
            return 5;
        }
        if (target.isStationModule()) {
            return 6;
        }
        if (target.isFighter() || target.isDrone()) {
            return 7;
        }
        return 0;
    }

    private int getSize(ShipAPI test) {
        switch (test.getHullSize()) {
            case CAPITAL_SHIP: {
                return 4;
            }
            case CRUISER: {
                return 3;
            }
            case DESTROYER: {
                return 2;
            }
        }
        return 1;
    }

    public String getInfoText(ShipSystemAPI system, ShipAPI ship) {
        switch (system.getState()) {
            case COOLDOWN: {
                return "COOLING DOWN";
            }
            case IN: {
                return "CHARGING UP";
            }
            case OUT: {
                return "COOLING DOWN";
            }
            case ACTIVE: {
                return "ACTIVE";
            }
            case IDLE: {
                break;
            }
            default: {
                return null;
            }
        }
        if (ship != null && ship.isAlive()) {
            this.target = ship.getShipTarget();
        }
        if (this.target == null) {
            return "READY [NO TARGET]";
        }
        switch (this.isTargetValid(ship, this.target)) {
            case 1: {
                return "OUT OF RANGE";
            }
            case 2: {
                return "INVALID TARGET";
            }
            case 3: {
                return "TARGET IS AN ALLY";
            }
            case 4: {
                return "TARGET IS DEAD";
            }
            case 5: {
                return "STATIONS ARE INVALID";
            }
            case 6: {
                return "MODULES ARE INVALID";
            }
            case 7: {
                return "FIGHTERS ARE INVALID";
            }
        }
        return "READY [TARGET LOCKED]";
    }

    public void apply(MutableShipStatsAPI stats, String id, ShipSystemStatsScript.State state, float effectLevel) {
        ShipAPI ship = (ShipAPI)stats.getEntity();
        if (ship == null) {
            return;
        }
        Color JITTER_UNDER_COLOR = this.JITTER_UNDER_COLOR_STANDARD;
        float jitterScale = 1.0f;
        float pitchScale = 0.5f;
        float soundVol = 0.35f;
        float jitterLevel = effectLevel;
        if (state == ShipSystemStatsScript.State.OUT) {
            jitterLevel *= jitterLevel;
        }
        float maxRangeBonus = 30.0f * jitterScale;
        float jitterRangeBonus = (0.5f + jitterLevel) / 1.5f * maxRangeBonus;
        Color jitterUnderColor = new Color(JITTER_UNDER_COLOR.getRed(), JITTER_UNDER_COLOR.getGreen(), JITTER_UNDER_COLOR.getBlue(), MagneticBurstStats.clamp255(Math.round(jitterLevel * (float)JITTER_UNDER_COLOR.getAlpha())));
        ship.setJitterUnder((Object)this, jitterUnderColor, effectLevel, Math.round(20.0f * jitterScale), 5.0f, 5.0f + jitterRangeBonus);
        ship.setJitter((Object)this, this.JITTER_OVER_COLOR_STANDARD, 0.4f + effectLevel / 2.0f, 1, 0.0f, 1.0f + jitterRangeBonus);
        stats.getArmorDamageTakenMult().modifyMult(id, 1.0f - effectLevel, "MAGNETIC FIELD SHIELD");
        stats.getHullDamageTakenMult().modifyMult(id, 0.5f - effectLevel * 0.5f);
        if (state == ShipSystemStatsScript.State.IN) {
            this.interval.advance(Global.getCombatEngine().getElapsedInLastFrame());
            if (this.interval.intervalElapsed()) {
                Global.getSoundPlayer().playSound("ed_mag1", MathUtils.getRandomNumberInRange((float)0.95f, (float)1.05f) * pitchScale, soundVol, ship.getLocation(), ship.getVelocity());
                if (Math.random() < (double)effectLevel) {
                    if (this.lockedTarget != null && this.lockedTarget.isAlive()) {
                        this.applyEffectToTarget(ship, this.lockedTarget, 1, 2, 250.0f, true);
                    } else {
                        List<ShipAPI> targets = this.findTargets(ship);
                        int lightning = (int)effectLevel * 3 + 1;
                        for (ShipAPI t : targets) {
                            this.applyEffectToTarget(ship, t, 1, 2, -50.0f, false);
                            if (--lightning > 0) continue;
                            break;
                        }
                        this.zapNearbyMissiles(ship);
                    }
                }
            }
            this.fired = false;
            if (this.lockedTarget != null && this.lockedTarget.isAlive()) {
                this.lockedTarget.setJitterUnder((Object)this, jitterUnderColor, effectLevel / 2.0f + 0.5f, Math.round(20.0f * jitterScale), 5.0f, 5.0f + jitterRangeBonus);
            } else {
                this.target = ship.getShipTarget();
                if (this.isTargetValid(ship, this.target) == 0) {
                    this.lockedTarget = this.target;
                }
            }
        } else if (state == ShipSystemStatsScript.State.ACTIVE && !this.fired) {
            if (this.lockedTarget != null && this.lockedTarget.isAlive()) {
                if (this.lockedTarget.isPhased() && this.lockedTarget.getPhaseCloak() != null) {
                    this.lockedTarget.getPhaseCloak().deactivate();
                }
                int size = this.getSize(this.lockedTarget) + this.getSize(ship);
                this.applyEffectToTarget(ship, this.lockedTarget, size * 3 + 3, size * 3 + 5, 1500.0f, true);
                this.lockedTarget = null;
            } else {
                List<ShipAPI> targets = this.findTargets(ship);
                if (!targets.isEmpty()) {
                    for (ShipAPI t : targets) {
                        this.applyEffectToTarget(ship, t, 5, 8, -200.0f, false);
                    }
                }
            }
            this.zapNearbyMissiles(ship);
            this.fired = true;
            if (ship.isPhased()) {
                ship.getPhaseCloak().deactivate();
            }
        }
    }

    public ShipSystemStatsScript.StatusData getStatusData(int index, ShipSystemStatsScript.State state, float effectLevel) {
        switch (state) {
            case IN: 
            case ACTIVE: 
            case OUT: {
                if (index != 0) break;
                return new ShipSystemStatsScript.StatusData("Armor strengthened", false);
            }
        }
        return null;
    }

    public boolean isUsable(ShipSystemAPI system, ShipAPI ship) {
        boolean hasTarget;
        if (ship == null) {
            return false;
        }
        this.target = ship.getShipTarget();
        if (this.isTargetValid(ship, this.target) == 0) {
            return true;
        }
        List<ShipAPI> targets = this.findTargets(ship);
        boolean bl = hasTarget = targets != null && !targets.isEmpty();
        if (!hasTarget) {
            float shipRadius = MagneticBurstStats.effectiveRadius(ship);
            float blastArea = shipRadius * 3.0f + 300.0f;
            List allMissiles = CombatUtils.getMissilesWithinRange((Vector2f)ship.getLocation(), (float)blastArea);
            for (MissileAPI missile : allMissiles) {
                if (missile.getOwner() == ship.getOwner()) continue;
                hasTarget = true;
                break;
            }
        }
        return hasTarget;
    }

    public void unapply(MutableShipStatsAPI stats, String id) {
        stats.getArmorDamageTakenMult().unmodify(id);
        stats.getHullDamageTakenMult().unmodify(id);
    }

    public static float effectiveRadius(ShipAPI ship) {
        if (ship.getSpriteAPI() == null || ship.isPiece()) {
            return ship.getCollisionRadius();
        }
        float fudgeFactor = 1.5f;
        return (ship.getSpriteAPI().getWidth() / 2.0f + ship.getSpriteAPI().getHeight() / 2.0f) * 0.5f * fudgeFactor;
    }

    protected void zapNearbyMissiles(ShipAPI ship) {
        float falloff;
        float shipRadius = MagneticBurstStats.effectiveRadius(ship);
        Color EMP_CORE_COLOR = this.EMP_CORE_COLOR_STANDARD;
        Color EMP_FRINGE_COLOR = this.EMP_FRINGE_COLOR_STANDARD;
        float blastDamage = 200.0f;
        float blastEMP = 200.0f;
        float blastArea = shipRadius * 3.0f + 300.0f;
        float blastMaxDamage = 1000.0f;
        int blastMaxTargets = 15;
        float totalDamage = 0.0f;
        int missileTargets = 0;
        List allMissiles = CombatUtils.getMissilesWithinRange((Vector2f)ship.getLocation(), (float)blastArea);
        Collections.shuffle(allMissiles);
        for (MissileAPI missile : allMissiles) {
            if (missile.getOwner() == ship.getOwner()) continue;
            float contribution = 0.1f;
            falloff = 1.0f - MathUtils.getDistance((CombatEntityAPI)ship, (CombatEntityAPI)missile) / blastArea;
            if (missile.getCollisionClass() == CollisionClass.NONE) continue;
            totalDamage += Math.min(missile.getHitpoints(), blastDamage * falloff) * contribution;
            if (++missileTargets < blastMaxTargets && !(totalDamage >= blastMaxDamage)) continue;
            break;
        }
        float attenuation = 1.0f;
        if (totalDamage > blastMaxDamage) {
            attenuation *= blastMaxDamage / totalDamage;
        }
        totalDamage = 0.0f;
        missileTargets = 0;
        for (MissileAPI missile : allMissiles) {
            if (missile.getOwner() == ship.getOwner()) continue;
            falloff = 1.0f - MathUtils.getDistance((CombatEntityAPI)ship, (CombatEntityAPI)missile) / blastArea;
            if (missile.getCollisionClass() == CollisionClass.NONE) continue;
            ++missileTargets;
            MissileAPI empTarget = missile;
            Vector2f point = null;
            for (int max = 10; point == null && max > 0; --max) {
                point = MathUtils.getRandomPointInCircle((Vector2f)ship.getLocation(), (float)shipRadius);
                if (CollisionUtils.isPointWithinBounds((Vector2f)point, (CombatEntityAPI)ship)) continue;
                point = null;
            }
            if (point == null) {
                point = MathUtils.getRandomPointInCircle((Vector2f)ship.getLocation(), (float)shipRadius);
            }
            float damage = blastDamage * falloff * attenuation;
            float emp = blastEMP * falloff * attenuation;
            Global.getCombatEngine().spawnEmpArc(ship, point, (CombatEntityAPI)ship, (CombatEntityAPI)empTarget, DamageType.ENERGY, damage, emp, 10000.0f, null, (float)Math.sqrt(blastDamage * falloff * attenuation), EMP_FRINGE_COLOR, EMP_CORE_COLOR);
            if (missileTargets < blastMaxTargets && !(totalDamage >= blastMaxDamage)) continue;
            break;
        }
    }

    protected void applyEffectToTarget(ShipAPI ship, ShipAPI target, int minBolts, int maxBolts, float forcePerBolt, boolean applyToSource) {
        if (target == ship) {
            return;
        }
        float shipRadius = MagneticBurstStats.effectiveRadius(ship);
        float targetRadius = MagneticBurstStats.effectiveRadius(target);
        float range = 700.0f + 200.0f * (float)this.getSize(ship);
        Color EMP_CORE_COLOR = this.EMP_CORE_COLOR_STANDARD;
        Color EMP_FRINGE_COLOR = this.EMP_FRINGE_COLOR_STANDARD;
        float falloffRange = range * 0.9f;
        float radiusPerBolt = 25.0f;
        float damagePerBolt = 50.0f;
        float empPerBolt = 200.0f;
        int retries = 10;
        float empScale = 1.0f;
        int particlesPerBolt = 10;
        float particleScale = 1.0f;
        float volumeScale = 1.0f;
        float falloff = 1.0f - MathUtils.getDistance((CombatEntityAPI)ship, (Vector2f)target.getLocation()) / falloffRange;
        int bolts = Math.max(minBolts, Math.min(maxBolts, Math.round(targetRadius / radiusPerBolt)));
        ShipAPI empTarget = target;
        for (int i = 0; i <= bolts; ++i) {
            Vector2f point = null;
            for (int max = retries; point == null && max > 0; --max) {
                point = MathUtils.getRandomPointInCircle((Vector2f)ship.getLocation(), (float)shipRadius);
                if (CollisionUtils.isPointWithinBounds((Vector2f)point, (CombatEntityAPI)ship)) continue;
                point = null;
            }
            if (point == null) {
                point = MathUtils.getRandomPointInCircle((Vector2f)ship.getLocation(), (float)shipRadius);
            }
            Global.getCombatEngine().spawnEmpArc(ship, point, (CombatEntityAPI)ship, (CombatEntityAPI)empTarget, DamageType.ENERGY, damagePerBolt * falloff, empPerBolt * falloff, 10000.0f, null, 20.0f * empScale * falloff, EMP_FRINGE_COLOR, EMP_CORE_COLOR);
            DamageReportManagerV1.addDamageClarification(damagePerBolt * falloff, empPerBolt * falloff, DamageType.ENERGY, (CombatEntityAPI)ship, (CombatEntityAPI)target, "Magnetic Burst");
            for (int x = 0; x < particlesPerBolt; ++x) {
                Global.getCombatEngine().addHitParticle(MathUtils.getPointOnCircumference((Vector2f)target.getLocation(), (float)(MathUtils.getRandomNumberInRange((float)0.0f, (float)(targetRadius * 0.5f)) * particleScale), (float)MathUtils.getRandomNumberInRange((float)0.0f, (float)360.0f)), MathUtils.getPointOnCircumference(null, (float)(MathUtils.getRandomNumberInRange((float)100.0f, (float)400.0f) * particleScale), (float)MathUtils.getRandomNumberInRange((float)0.0f, (float)360.0f)), 7.0f * particleScale, 1.0f * falloff, MathUtils.getRandomNumberInRange((float)1.0f, (float)2.0f) * particleScale * falloff, EMP_CORE_COLOR);
            }
        }
        float volume = 1.0f * ((float)bolts / (float)maxBolts) * volumeScale * falloff;
        Global.getSoundPlayer().playSound("ed_shock", 1.0f, volume, target.getLocation(), target.getVelocity());
        CombatUtils.applyForce((CombatEntityAPI)Utils.getRoot(target), (Vector2f)VectorUtils.getDirectionalVector((Vector2f)target.getLocation(), (Vector2f)ship.getLocation()), (float)(forcePerBolt * (float)bolts * falloff));
        if (applyToSource) {
            CombatUtils.applyForce((CombatEntityAPI)Utils.getRoot(ship), (Vector2f)VectorUtils.getDirectionalVector((Vector2f)ship.getLocation(), (Vector2f)target.getLocation()), (float)(forcePerBolt * (float)bolts * falloff));
        }
    }

    public static int clamp255(int x) {
        return Math.max(0, Math.min(255, x));
    }

    protected List<ShipAPI> findTargets(ShipAPI ship) {
        float range = 700.0f + 200.0f * (float)this.getSize(ship);
        ArrayList<ShipAPI> targets = new ArrayList<ShipAPI>();
        for (ShipAPI target : CombatUtils.getShipsWithinRange((Vector2f)ship.getLocation(), (float)(range + ship.getCollisionRadius()))) {
            if (target.isShuttlePod() || !target.isAlive() || target.isStation() || target.isStationModule() || ship.getOwner() == target.getOwner() || target.getOwner() == 100) continue;
            targets.add(target);
        }
        return targets;
    }
}

