/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.edshipyard.shipsystems;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.WeaponAPI;
import com.fs.starfarer.api.impl.combat.BaseShipSystemScript;
import com.fs.starfarer.api.plugins.ShipSystemStatsScript;
import com.fs.starfarer.api.util.IntervalUtil;
import data.scripts.edshipyard.util.StolenUtils;
import java.awt.Color;
import java.util.List;
import java.util.Random;
import org.lazywizard.lazylib.MathUtils;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class SteamDriveStats
extends BaseShipSystemScript {
    public float SPEED_BONUS = 125.0f;
    private final IntervalUtil tracker = new IntervalUtil(1.0f, 1.0f);
    private final Color color = new Color(255, 75, 175, 255);
    private final Random rng = new Random();
    boolean releaseSound = false;
    boolean whistleSound = false;

    public void apply(MutableShipStatsAPI stats, String id, ShipSystemStatsScript.State state, float effectLevel) {
        if (state == ShipSystemStatsScript.State.OUT) {
            this.releaseSound = false;
            this.whistleSound = false;
        } else {
            stats.getMaxSpeed().modifyFlat(id, this.SPEED_BONUS * effectLevel);
            stats.getAcceleration().modifyPercent(id, this.SPEED_BONUS * 3.0f * effectLevel);
            stats.getTurnAcceleration().modifyMult(id, 1.0f - effectLevel);
            stats.getMaxTurnRate().modifyMult(id, 1.0f - effectLevel);
        }
        CombatEngineAPI engine = Global.getCombatEngine();
        if (engine.isPaused()) {
            return;
        }
        if (stats.getEntity() instanceof ShipAPI) {
            ShipAPI ship = (ShipAPI)stats.getEntity();
            if (state == ShipSystemStatsScript.State.IN) {
                if (!this.releaseSound) {
                    Global.getSoundPlayer().playSound("ed_steam_release", 1.0f, 1.0f, ship.getLocation(), ship.getVelocity());
                    this.releaseSound = true;
                    float angle = ship.getFacing();
                    List weaps = ship.getAllWeapons();
                    for (WeaponAPI w : weaps) {
                        if (!w.isDecorative()) continue;
                        for (int i = 0; i < 24; ++i) {
                            engine.addSmokeParticle(w.getLocation(), MathUtils.getPoint((Vector2f)new Vector2f(), (float)(100.0f + 150.0f * this.rng.nextFloat()), (float)(w.getSlot().getAngle() + angle + 24.0f * this.rng.nextFloat() - 12.0f)), 15.0f * (0.6f + 0.3f * this.rng.nextFloat()) * 3.0f, 0.1f + 0.01f * (float)i, 2.0f, new Color(170, 170, 200, 20));
                        }
                    }
                }
            } else if (state == ShipSystemStatsScript.State.ACTIVE && !this.whistleSound) {
                this.tracker.advance(Global.getCombatEngine().getElapsedInLastFrame());
                if (this.tracker.intervalElapsed()) {
                    Vector2f endPoint = new Vector2f((ReadableVector2f)ship.getLocation());
                    endPoint.x = (float)((double)endPoint.x + Math.cos(Math.toRadians(ship.getFacing())) * 1000.0);
                    endPoint.y = (float)((double)endPoint.y + Math.sin(Math.toRadians(ship.getFacing())) * 1000.0);
                    ShipAPI target = StolenUtils.getFirstNonFighterOnSegment(ship.getLocation(), endPoint, (CombatEntityAPI)ship);
                    if (target != null) {
                        Global.getSoundPlayer().playSound("ed_steam_whistle", 0.75f, 1.6f, ship.getLocation(), ship.getVelocity());
                        this.whistleSound = true;
                    }
                }
            }
            ship.getEngineController().fadeToOtherColor((Object)this, this.color, new Color(0, 0, 0, 0), effectLevel, 0.67f);
            ship.getEngineController().extendFlame((Object)this, 2.0f * effectLevel, 0.0f * effectLevel, 0.0f * effectLevel);
            List modules = ship.getChildModulesCopy();
            if (modules != null) {
                for (ShipAPI m : modules) {
                    m.getEngineController().fadeToOtherColor((Object)this, this.color, new Color(0, 0, 0, 0), effectLevel, 0.67f);
                    m.getEngineController().extendFlame((Object)this, 2.0f * effectLevel, 0.0f * effectLevel, 0.0f * effectLevel);
                }
            }
            float angle = ship.getFacing();
            float smokeSizeValue = 1.0f + effectLevel;
            Global.getSoundPlayer().playLoop("ed_steam_loop", (Object)ship, 1.0f, 0.3f + 0.3f * effectLevel, ship.getLocation(), ship.getVelocity());
            List weaps = ship.getAllWeapons();
            for (WeaponAPI w : weaps) {
                if (!w.isDecorative()) continue;
                engine.addSmokeParticle(w.getLocation(), MathUtils.getPoint((Vector2f)new Vector2f(), (float)(200.0f + 50.0f * this.rng.nextFloat()), (float)(w.getSlot().getAngle() + angle + 16.0f * this.rng.nextFloat() - 8.0f)), 15.0f * (0.6f + 0.3f * this.rng.nextFloat()) * smokeSizeValue, 0.15f, 1.0f, new Color(170, 170, 200, 20));
                engine.addSmokeParticle(w.getLocation(), MathUtils.getPoint((Vector2f)new Vector2f(), (float)(200.0f + 50.0f * this.rng.nextFloat()), (float)(w.getSlot().getAngle() + angle + 16.0f * this.rng.nextFloat() - 8.0f)), 15.0f * (0.6f + 0.3f * this.rng.nextFloat()) * smokeSizeValue, 0.1f, 1.0f, new Color(170, 170, 200, 20));
            }
        }
    }

    public void unapply(MutableShipStatsAPI stats, String id) {
        stats.getMaxSpeed().unmodify(id);
        stats.getAcceleration().unmodify(id);
        stats.getTurnAcceleration().unmodify(id);
        stats.getMaxTurnRate().unmodify(id);
    }

    public ShipSystemStatsScript.StatusData getStatusData(int index, ShipSystemStatsScript.State state, float effectLevel) {
        if (index == 0) {
            return new ShipSystemStatsScript.StatusData("+" + (int)(this.SPEED_BONUS * effectLevel) + " top speed", false);
        }
        return null;
    }
}

