/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.edshipyard.shipsystems;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.WeaponAPI;
import com.fs.starfarer.api.impl.combat.BaseShipSystemScript;
import com.fs.starfarer.api.plugins.ShipSystemStatsScript;
import com.fs.starfarer.api.util.IntervalUtil;
import java.awt.Color;
import java.util.ArrayList;
import java.util.EnumSet;
import org.dark.shaders.distortion.DistortionAPI;
import org.dark.shaders.distortion.DistortionShader;
import org.dark.shaders.distortion.RippleDistortion;
import org.lwjgl.util.vector.Vector2f;

public class WurgOverdriveStats
extends BaseShipSystemScript {
    public static final float WURG_SENSOR_RANGE_PERCENT = 100.0f;
    public static final float WURG_WEAPON_RANGE_PERCENT = 25.0f;
    public static final float WURG_WEAPON_DAMAGE_PERCENT = 25.0f;
    public static final float WURG_WEAPON_INCREASED_FLUX_PERCENT = 75.0f;
    public static final float WURG_ENGINE_PERCENT = 35.0f;
    public static final float WURG_SHIELD_PERCENT = 25.0f;
    private ShipAPI ship;
    private ShipAPI ShieldModuleL;
    private ShipAPI ShieldModuleR;
    private ShipAPI WeaponModuleL;
    private ShipAPI WeaponModuleR;
    private ShipAPI HangarModuleL;
    private ShipAPI HangarModuleR;
    private ShipAPI EngineModuleB;
    private ArrayList<WeaponAPI> eyes;
    private Color _defaultInnerColor;
    private Color _defaultRingColor;
    private boolean _overloaded = false;
    private final ArrayList<MutableShipStatsAPI> parentAndChildrenStats = new ArrayList();
    public static final String wurg_SML = "edshipyard_wurg_jawleft";
    public static final String wurg_SMR = "edshipyard_wurg_jawright";
    public static final String wurg_WML = "edshipyard_wurg_weaponleft";
    public static final String wurg_WMR = "edshipyard_wurg_weaponright";
    public static final String wurg_HML = "edshipyard_wurg_hangarleft";
    public static final String wurg_HMR = "edshipyard_wurg_hangarright";
    public static final String wurg_BTC = "edshipyard_wurg_buttocks";
    private static final Color JITTER_UNDER_COLOR = new Color(225, 175, 225, 125);
    private static final Color OVERDRIVE_SHIELD_RING_COLOR = new Color(225, 255, 255, 255);
    private static final Color OVERDRIVE_SHIELD_INNER_COLOR = new Color(255, 100, 255, 75);
    private static final Vector2f ZERO = new Vector2f();
    private final IntervalUtil interval = new IntervalUtil(1.0f, 1.0f);
    private int currentFrame;

    private void init(MutableShipStatsAPI stats) {
        if (this.ship == null) {
            this.ship = (ShipAPI)stats.getEntity();
            this.parentAndChildrenStats.clear();
            this.parentAndChildrenStats.add(this.ship.getMutableStats());
            this.currentFrame = 0;
            for (ShipAPI m : this.ship.getChildModulesCopy()) {
                switch (m.getHullSpec().getBaseHullId()) {
                    case "edshipyard_wurg_jawleft": {
                        this.ShieldModuleL = m;
                        this.parentAndChildrenStats.add(m.getMutableStats());
                        break;
                    }
                    case "edshipyard_wurg_jawright": {
                        this.ShieldModuleR = m;
                        this.parentAndChildrenStats.add(m.getMutableStats());
                        break;
                    }
                    case "edshipyard_wurg_weaponleft": {
                        this.WeaponModuleL = m;
                        this.parentAndChildrenStats.add(m.getMutableStats());
                        break;
                    }
                    case "edshipyard_wurg_weaponright": {
                        this.WeaponModuleR = m;
                        this.parentAndChildrenStats.add(m.getMutableStats());
                        break;
                    }
                    case "edshipyard_wurg_hangarleft": {
                        this.HangarModuleL = m;
                        this.parentAndChildrenStats.add(m.getMutableStats());
                        break;
                    }
                    case "edshipyard_wurg_hangarright": {
                        this.HangarModuleR = m;
                        this.parentAndChildrenStats.add(m.getMutableStats());
                        break;
                    }
                    case "edshipyard_wurg_buttocks": {
                        this.EngineModuleB = m;
                        this.parentAndChildrenStats.add(m.getMutableStats());
                    }
                }
            }
            this.eyes = new ArrayList();
            for (WeaponAPI w : this.ship.getAllWeapons()) {
                if (!w.isDecorative() || !w.getDisplayName().contains("Eye")) continue;
                this.eyes.add(w);
            }
            this._defaultInnerColor = Color.WHITE;
            this._defaultRingColor = Color.WHITE;
            if (this.ShieldModuleL != null && this.ShieldModuleL.getShield() != null) {
                this._defaultInnerColor = this.ShieldModuleL.getShield().getInnerColor();
                this._defaultRingColor = this.ShieldModuleL.getShield().getRingColor();
            }
        }
    }

    public void apply(MutableShipStatsAPI stats, String id, ShipSystemStatsScript.State state, float effectLevel) {
        this.init(stats);
        this.jitter(effectLevel);
        if (state == ShipSystemStatsScript.State.IDLE) {
            this._overloaded = false;
        }
        if (state == ShipSystemStatsScript.State.COOLDOWN || state == ShipSystemStatsScript.State.IDLE) {
            this.unapply(stats, id);
            return;
        }
        for (WeaponAPI w : this.eyes) {
            w.getAnimation().setFrame(this.currentFrame);
        }
        if (state == ShipSystemStatsScript.State.ACTIVE) {
            if (this.currentFrame < 19) {
                ++this.currentFrame;
            }
        } else if (this.currentFrame > 0) {
            --this.currentFrame;
        }
        if (this.ship.getFluxLevel() > 0.99f && !this._overloaded) {
            this.ship.getFluxTracker().beginOverloadWithTotalBaseDuration(10.0f);
            this.ship.setCurrentCR(this.ship.getCurrentCR() - 0.05f);
            this._overloaded = true;
            return;
        }
        for (MutableShipStatsAPI componentStats : this.parentAndChildrenStats) {
            this.applyToShip(componentStats, id, effectLevel);
        }
    }

    public void unapply(MutableShipStatsAPI stats, String id) {
        for (MutableShipStatsAPI componentStats : this.parentAndChildrenStats) {
            this.unapplyToShip(componentStats, id);
        }
    }

    private void jitter(float effectLevel) {
        float amount = Global.getCombatEngine().getElapsedInLastFrame();
        if (Global.getCombatEngine().isPaused()) {
            amount = 0.0f;
        }
        this.interval.advance(amount);
        if (this.interval.intervalElapsed()) {
            float shipRadius = WurgOverdriveStats.effectiveRadius(this.ship);
            Vector2f offset = new Vector2f(-6.0f, 0.0f);
            Vector2f centerLocation = Vector2f.add((Vector2f)this.ship.getLocation(), (Vector2f)offset, (Vector2f)new Vector2f());
            float startSize = shipRadius * 1.5f * effectLevel;
            float endSize = shipRadius * 2.0f * effectLevel + 200.0f;
            RippleDistortion ripple = new RippleDistortion(centerLocation, ZERO);
            ripple.setSize(endSize);
            ripple.setIntensity(1.0f * (2.0f * effectLevel));
            ripple.setFrameRate(199.99998f);
            ripple.fadeInSize(0.3f * endSize / (endSize - startSize));
            ripple.fadeOutIntensity(0.5f);
            ripple.setSize(startSize);
            DistortionShader.addDistortion((DistortionAPI)ripple);
            Global.getSoundPlayer().playSound("wurg_sensor", 1.0f, 0.3f + effectLevel * 0.2f, this.ship.getLocation(), this.ship.getVelocity());
            float jitterScale = 1.0f;
            float jitterLevel = 0.5f + 0.5f * effectLevel;
            float maxRangeBonus = 30.0f * jitterScale;
            float jitterRangeBonus = (0.5f + jitterLevel) / 1.5f * maxRangeBonus;
            this.ship.setJitterUnder((Object)this, JITTER_UNDER_COLOR, jitterLevel, Math.round(5.0f * jitterScale), 0.0f, 3.0f + jitterRangeBonus);
            if (this.ShieldModuleL != null && this.ShieldModuleL.isAlive()) {
                this.ShieldModuleL.setJitterUnder((Object)this, JITTER_UNDER_COLOR, jitterLevel, Math.round(4.0f * jitterScale), 0.0f, 3.0f + jitterRangeBonus);
            }
            if (this.ShieldModuleR != null && this.ShieldModuleR.isAlive()) {
                this.ShieldModuleR.setJitterUnder((Object)this, JITTER_UNDER_COLOR, jitterLevel, Math.round(4.0f * jitterScale), 0.0f, 3.0f + jitterRangeBonus);
            }
            if (this.WeaponModuleL != null && this.WeaponModuleL.isAlive()) {
                this.WeaponModuleL.setJitterUnder((Object)this, JITTER_UNDER_COLOR, jitterLevel, Math.round(3.0f * jitterScale), 0.0f, 3.0f + jitterRangeBonus);
            }
            if (this.WeaponModuleR != null && this.WeaponModuleR.isAlive()) {
                this.WeaponModuleR.setJitterUnder((Object)this, JITTER_UNDER_COLOR, jitterLevel, Math.round(3.0f * jitterScale), 0.0f, 3.0f + jitterRangeBonus);
            }
            if (this.HangarModuleL != null && this.HangarModuleL.isAlive()) {
                this.HangarModuleL.setJitterUnder((Object)this, JITTER_UNDER_COLOR, jitterLevel, Math.round(4.0f * jitterScale), 0.0f, 3.0f + jitterRangeBonus);
            }
            if (this.HangarModuleR != null && this.HangarModuleR.isAlive()) {
                this.HangarModuleR.setJitterUnder((Object)this, JITTER_UNDER_COLOR, jitterLevel, Math.round(4.0f * jitterScale), 0.0f, 3.0f + jitterRangeBonus);
            }
            if (this.EngineModuleB != null && this.EngineModuleB.isAlive()) {
                this.EngineModuleB.setJitterUnder((Object)this, JITTER_UNDER_COLOR, jitterLevel, Math.round(4.0f * jitterScale), 0.0f, 3.0f + jitterRangeBonus);
            }
        }
    }

    private void applyToShip(MutableShipStatsAPI stats, String id, float effectLevel) {
        if (stats != null) {
            ShipAPI componentShip = (ShipAPI)stats.getEntity();
            if (componentShip != null) {
                componentShip.setWeaponGlow(effectLevel, JITTER_UNDER_COLOR, EnumSet.of(WeaponAPI.WeaponType.BALLISTIC, WeaponAPI.WeaponType.ENERGY));
                if (componentShip.getShield() != null) {
                    componentShip.getShield().setInnerColor(OVERDRIVE_SHIELD_INNER_COLOR);
                    componentShip.getShield().setRingColor(OVERDRIVE_SHIELD_RING_COLOR);
                }
            }
            stats.getSightRadiusMod().modifyPercent(id, 100.0f * effectLevel);
            stats.getBallisticWeaponRangeBonus().modifyPercent(id, 25.0f * effectLevel);
            stats.getEnergyWeaponRangeBonus().modifyPercent(id, 25.0f * effectLevel);
            stats.getBallisticWeaponDamageMult().modifyPercent(id, 25.0f * effectLevel);
            stats.getEnergyWeaponDamageMult().modifyPercent(id, 25.0f * effectLevel);
            stats.getBallisticWeaponFluxCostMod().modifyPercent(id, 75.0f * effectLevel);
            stats.getEnergyWeaponFluxCostMod().modifyPercent(id, 75.0f * effectLevel);
            stats.getMaxSpeed().modifyPercent(id, 35.0f * effectLevel);
            stats.getAcceleration().modifyPercent(id, 35.0f * effectLevel);
            stats.getDeceleration().modifyPercent(id, 35.0f * effectLevel);
            stats.getTurnAcceleration().modifyPercent(id, 70.0f * effectLevel);
            stats.getShieldDamageTakenMult().modifyPercent(id, 75.0f);
            stats.getShieldUpkeepMult().modifyPercent(id, 50.0f);
        }
    }

    private void unapplyToShip(MutableShipStatsAPI stats, String id) {
        if (stats != null) {
            ShipAPI componentShip = (ShipAPI)stats.getEntity();
            if (componentShip != null) {
                componentShip.setWeaponGlow(0.0f, JITTER_UNDER_COLOR, EnumSet.of(WeaponAPI.WeaponType.BALLISTIC, WeaponAPI.WeaponType.ENERGY));
                if (componentShip.getShield() != null) {
                    componentShip.getShield().setInnerColor(this._defaultInnerColor);
                    componentShip.getShield().setRingColor(this._defaultRingColor);
                }
            }
            stats.getSightRadiusMod().unmodify(id);
            stats.getBallisticWeaponRangeBonus().unmodify(id);
            stats.getEnergyWeaponRangeBonus().unmodify(id);
            stats.getBallisticWeaponDamageMult().unmodify(id);
            stats.getEnergyWeaponDamageMult().unmodify(id);
            stats.getBallisticWeaponFluxCostMod().unmodify(id);
            stats.getEnergyWeaponFluxCostMod().unmodify(id);
            stats.getMaxSpeed().unmodify(id);
            stats.getAcceleration().unmodify(id);
            stats.getDeceleration().unmodify(id);
            stats.getTurnAcceleration().unmodify(id);
            stats.getMaxTurnRate().unmodify(id);
            stats.getShieldDamageTakenMult().unmodify(id);
            stats.getShieldUpkeepMult().unmodify(id);
        }
    }

    public static float effectiveRadius(ShipAPI ship) {
        if (ship.getSpriteAPI() == null || ship.isPiece()) {
            return ship.getCollisionRadius();
        }
        float fudgeFactor = 1.5f;
        return (ship.getSpriteAPI().getWidth() / 2.0f + ship.getSpriteAPI().getHeight() / 2.0f) * 0.5f * fudgeFactor;
    }

    public ShipSystemStatsScript.StatusData getStatusData(int index, ShipSystemStatsScript.State state, float effectLevel) {
        float sensorRangePercent = 100.0f * effectLevel;
        float weaponRangePercent = 25.0f * effectLevel;
        float weaponDamagePercent = 25.0f * effectLevel;
        float fluxConsumption = 75.0f * effectLevel;
        if (index == 0) {
            return new ShipSystemStatsScript.StatusData("sensor range +" + (int)sensorRangePercent + "%", false);
        }
        if (index == 1) {
            return null;
        }
        if (index == 2) {
            return new ShipSystemStatsScript.StatusData("weapon range +" + (int)weaponRangePercent + "%", false);
        }
        if (index == 3) {
            return new ShipSystemStatsScript.StatusData("weapon damage +" + (int)weaponDamagePercent + "%", false);
        }
        if (index == 4) {
            return new ShipSystemStatsScript.StatusData("flux consumption +" + (int)fluxConsumption + "%", false);
        }
        return null;
    }
}

