/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.edshipyard.shipsystems.ai;

import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipCommand;
import com.fs.starfarer.api.combat.ShipSystemAIScript;
import com.fs.starfarer.api.combat.ShipSystemAPI;
import com.fs.starfarer.api.combat.ShipwideAIFlags;
import data.scripts.edshipyard.util.StolenUtils;
import org.lwjgl.util.vector.Vector2f;

public class DoppelswapAI
implements ShipSystemAIScript {
    private CombatEngineAPI engine;
    private ShipwideAIFlags flags;
    private ShipAPI ship;

    public void advance(float amount, Vector2f missileDangerDir, Vector2f collisionDangerDir, ShipAPI target) {
        if (this.engine == null) {
            return;
        }
        if (this.engine.isPaused()) {
            return;
        }
        if (this.ship.getCurrFlux() + 100.0f > this.ship.getMaxFlux()) {
            return;
        }
        if (this.ship.getFluxLevel() < 0.8f) {
            this.flags.setFlag(ShipwideAIFlags.AIFlags.DO_NOT_VENT);
        } else {
            this.flags.unsetFlag(ShipwideAIFlags.AIFlags.DO_NOT_VENT);
        }
        float incomming = StolenUtils.estimateIncomingDamage(this.ship, 0.5f);
        if (incomming > 0.0f) {
            ShipAPI doppel = null;
            float minthreat = incomming;
            for (ShipAPI drone : this.ship.getDeployedDrones()) {
                float inc;
                if (!drone.isAlive() || drone.isPhased() || !(minthreat > (inc = StolenUtils.estimateIncomingDamage(drone, 0.5f)))) continue;
                minthreat = inc;
                doppel = drone;
            }
            if (doppel != null) {
                this.ship.giveCommand(ShipCommand.TOGGLE_SHIELD_OR_PHASE_CLOAK, null, 0);
            }
        }
    }

    public void init(ShipAPI ship, ShipSystemAPI system, ShipwideAIFlags flags, CombatEngineAPI engine) {
        this.ship = ship;
        this.flags = flags;
        this.engine = engine;
    }
}

