/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.edshipyard.shipsystems.ai;

import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipCommand;
import com.fs.starfarer.api.combat.ShipSystemAIScript;
import com.fs.starfarer.api.combat.ShipSystemAPI;
import com.fs.starfarer.api.combat.ShipwideAIFlags;
import com.fs.starfarer.api.util.IntervalUtil;
import org.lazywizard.lazylib.combat.CombatUtils;
import org.lwjgl.util.vector.Vector2f;

public class FieldShieldControlAI
implements ShipSystemAIScript {
    private CombatEngineAPI engine;
    private ShipwideAIFlags flags;
    private ShipAPI ship;
    private ShipAPI module;
    private final IntervalUtil tracker = new IntervalUtil(1.0f, 1.0f);
    public final String shieldModule = "edshipyard_retriever_shield";

    public void advance(float amount, Vector2f missileDangerDir, Vector2f collisionDangerDir, ShipAPI target) {
        if (this.engine == null) {
            return;
        }
        if (this.engine.isPaused()) {
            return;
        }
        if (this.module == null) {
            for (ShipAPI m : this.ship.getChildModulesCopy()) {
                if (!m.getHullSpec().getBaseHullId().equals("edshipyard_retriever_shield")) continue;
                this.module = m;
                break;
            }
            return;
        }
        if (!this.module.isAlive() || this.module.getFluxTracker().isOverloadedOrVenting()) {
            return;
        }
        this.tracker.advance(amount);
        if (this.tracker.intervalElapsed()) {
            if (this.module.getShield().isOn()) {
                this.shieldIsOn();
            } else if (this.module.getShield().isOff()) {
                this.shieldIsOff();
            }
        }
    }

    private boolean isEnemyNearby() {
        for (ShipAPI nearby : CombatUtils.getShipsWithinRange((Vector2f)this.module.getLocation(), (float)3000.0f)) {
            if (nearby.getHullSize() == ShipAPI.HullSize.FIGHTER || !nearby.isAlive() || nearby.getOwner() == this.ship.getOwner()) continue;
            return true;
        }
        return false;
    }

    private boolean isFriendlyNearby() {
        for (ShipAPI nearby : CombatUtils.getShipsWithinRange((Vector2f)this.module.getLocation(), (float)1500.0f)) {
            if (nearby.getHullSize() == ShipAPI.HullSize.FIGHTER || !nearby.isAlive() || nearby.getOwner() != this.ship.getOwner()) continue;
            return true;
        }
        return false;
    }

    private void shieldIsOn() {
        if (this.ship.getFluxLevel() >= 0.75f || this.module.getFluxLevel() >= 0.9f || !this.isEnemyNearby() || !this.isFriendlyNearby()) {
            this.ship.giveCommand(ShipCommand.TOGGLE_SHIELD_OR_PHASE_CLOAK, null, 0);
        }
    }

    private void shieldIsOff() {
        if (this.ship.getFluxLevel() < 0.75f && this.module.getFluxLevel() < 0.9f && this.isEnemyNearby() && this.isFriendlyNearby()) {
            this.ship.giveCommand(ShipCommand.TOGGLE_SHIELD_OR_PHASE_CLOAK, null, 0);
        }
    }

    public void init(ShipAPI ship, ShipSystemAPI system, ShipwideAIFlags flags, CombatEngineAPI engine) {
        this.ship = ship;
        this.flags = flags;
        this.engine = engine;
    }
}

