/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.edshipyard.shipsystems.ai;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.CollisionClass;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.DamageType;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipSystemAIScript;
import com.fs.starfarer.api.combat.ShipSystemAPI;
import com.fs.starfarer.api.combat.ShipwideAIFlags;
import com.fs.starfarer.api.combat.WeaponAPI;
import com.fs.starfarer.api.util.IntervalUtil;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.combat.entities.Ship;
import data.dcr.edshipyard.DamageReportManagerV1;
import java.awt.Color;
import java.util.List;
import org.dark.shaders.distortion.DistortionAPI;
import org.dark.shaders.distortion.DistortionShader;
import org.dark.shaders.distortion.RippleDistortion;
import org.lazywizard.lazylib.MathUtils;
import org.lazywizard.lazylib.combat.AIUtils;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class SelfDestructAI
implements ShipSystemAIScript {
    private static final float TELEPORT_RANGE = 1500.0f;
    private CombatEngineAPI engine;
    private ShipAPI ship;
    private final IntervalUtil tracker = new IntervalUtil(0.25f, 0.5f);

    public void advance(float amount, Vector2f missileDangerDir, Vector2f collisionDangerDir, ShipAPI target) {
        if (this.engine == null || this.engine.isPaused()) {
            return;
        }
        this.tracker.advance(amount);
        if (this.tracker.intervalElapsed() && AIUtils.canUseSystemThisFrame((ShipAPI)this.ship)) {
            this.ship.setCollisionClass(CollisionClass.FIGHTER);
            Ship parent = ((Ship)this.ship).getLaunchingShip();
            if (parent == null) {
                return;
            }
            if ((parent = parent.getParentStation()) == null) {
                return;
            }
            target = parent.getShipTarget();
            if (target == null) {
                return;
            }
            this.ship.setShipTarget(target);
            if (target.getOwner() == parent.getOwner() || !target.isAlive() || target.isAlly()) {
                return;
            }
            if (MathUtils.getDistance((CombatEntityAPI)this.ship, (CombatEntityAPI)target) > 1500.0f) {
                return;
            }
            if (target.getVelocity().length() > 15.0f || target.getPhaseCloak() != null) {
                return;
            }
            if (!this.isShipStressed(target)) {
                return;
            }
            Vector2f teleportLocation = MathUtils.getPointOnCircumference((Vector2f)new Vector2f((ReadableVector2f)target.getLocation()), (float)(target.getCollisionRadius() / 2.0f), (float)((float)Math.random() * 360.0f));
            float shipRadius = 30.0f;
            float startSize = shipRadius * 1.5f;
            float endSize = shipRadius * 2.0f + 200.0f;
            RippleDistortion ripple = new RippleDistortion(new Vector2f((ReadableVector2f)target.getLocation()), Misc.ZERO);
            ripple.setSize(endSize);
            ripple.setIntensity(endSize * 0.05f);
            ripple.setFrameRate(15.0f);
            ripple.fadeInSize(0.3f * endSize / (endSize - startSize));
            ripple.fadeOutIntensity(0.3f);
            ripple.setSize(startSize);
            DistortionShader.addDistortion((DistortionAPI)ripple);
            Global.getSoundPlayer().playSound("kfp", MathUtils.getRandomNumberInRange((float)0.95f, (float)1.05f) * 0.5f, 0.75f, new Vector2f((ReadableVector2f)target.getLocation()), Misc.ZERO);
            this.ship.getLocation().set((ReadableVector2f)teleportLocation);
            this.ship.getVelocity().scale(0.0f);
            this.ship.useSystem();
            float damage = 400.0f;
            float empDamage = 800.0f;
            this.engine.spawnEmpArc((ShipAPI)parent, new Vector2f((ReadableVector2f)target.getLocation()), (CombatEntityAPI)this.ship, (CombatEntityAPI)target, DamageType.ENERGY, damage, empDamage, 500.0f, null, 5.0f, Color.WHITE, Color.WHITE);
            this.engine.spawnEmpArc((ShipAPI)parent, new Vector2f((ReadableVector2f)target.getLocation()), (CombatEntityAPI)this.ship, (CombatEntityAPI)target, DamageType.ENERGY, damage, empDamage, 500.0f, null, 5.0f, Color.WHITE, Color.WHITE);
            this.engine.spawnEmpArc((ShipAPI)parent, new Vector2f((ReadableVector2f)target.getLocation()), (CombatEntityAPI)this.ship, (CombatEntityAPI)target, DamageType.ENERGY, damage, empDamage, 500.0f, null, 5.0f, Color.WHITE, Color.WHITE);
            this.engine.spawnEmpArc((ShipAPI)parent, new Vector2f((ReadableVector2f)target.getLocation()), (CombatEntityAPI)this.ship, (CombatEntityAPI)target, DamageType.ENERGY, damage, empDamage, 500.0f, null, 5.0f, Color.WHITE, Color.WHITE);
            DamageReportManagerV1.addDamageClarification(damage, empDamage, DamageType.ENERGY, (CombatEntityAPI)parent, (CombatEntityAPI)target, "Detonator Drone");
            DamageReportManagerV1.addDamageClarification(damage, empDamage, DamageType.ENERGY, (CombatEntityAPI)parent, (CombatEntityAPI)target, "Detonator Drone");
            DamageReportManagerV1.addDamageClarification(damage, empDamage, DamageType.ENERGY, (CombatEntityAPI)parent, (CombatEntityAPI)target, "Detonator Drone");
            DamageReportManagerV1.addDamageClarification(damage, empDamage, DamageType.ENERGY, (CombatEntityAPI)parent, (CombatEntityAPI)target, "Detonator Drone");
        }
    }

    public boolean isShipStressed(ShipAPI s) {
        if (s.getFluxTracker() != null && (s.getFluxTracker().isVenting() && s.getFluxTracker().getTimeToVent() > 5.0f || s.getFluxTracker().isOverloaded() && s.getFluxTracker().getOverloadTimeRemaining() > 3.0f)) {
            return true;
        }
        if (s.getEngineController() != null && s.getEngineController().isDisabled()) {
            return true;
        }
        List weapons = s.getAllWeapons();
        if (weapons.size() == 0) {
            return true;
        }
        int disabledCount = 0;
        int shooting = 0;
        for (WeaponAPI weapon : weapons) {
            if (weapon.isDisabled()) {
                ++disabledCount;
            }
            if (!weapon.isFiring() && !(weapon.getCooldownRemaining() > 0.0f)) continue;
            ++shooting;
        }
        if (disabledCount > 0) {
            return true;
        }
        return (double)((float)shooting / (float)weapons.size()) > 0.8;
    }

    public void init(ShipAPI ship, ShipSystemAPI system, ShipwideAIFlags flags, CombatEngineAPI engine) {
        this.ship = ship;
        this.engine = engine;
    }
}

