/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.edshipyard.shipsystems.ai;

import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAIConfig;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipSystemAIScript;
import com.fs.starfarer.api.combat.ShipSystemAPI;
import com.fs.starfarer.api.combat.ShipwideAIFlags;
import com.fs.starfarer.api.util.IntervalUtil;
import data.scripts.edshipyard.util.StolenUtils;
import java.util.List;
import org.lazywizard.lazylib.combat.CombatUtils;
import org.lwjgl.util.vector.Vector2f;

public class SpatialSwapAI
implements ShipSystemAIScript {
    private CombatEngineAPI engine;
    private ShipwideAIFlags flags;
    private ShipAPI ship;
    private ShipSystemAPI system;
    private static final float MAX_RANGE = 4000.0f;
    private final IntervalUtil tracker = new IntervalUtil(0.5f, 0.5f);
    private boolean resetAI = false;
    private final ShipAIConfig savedConfig = new ShipAIConfig();

    public void advance(float amount, Vector2f missileDangerDir, Vector2f collisionDangerDir, ShipAPI target) {
        if (this.engine == null) {
            return;
        }
        if (this.engine.isPaused()) {
            return;
        }
        this.tracker.advance(amount);
        if (this.tracker.intervalElapsed()) {
            List ships;
            if (this.ship.getFluxTracker().isOverloadedOrVenting() || !this.ship.isAlive() || this.system.isActive() || this.system.isCoolingDown() || this.ship.getFluxLevel() > 0.25f) {
                return;
            }
            if (!this.ship.isDrone()) {
                if (this.flags.hasFlag(ShipwideAIFlags.AIFlags.BACKING_OFF) || this.flags.hasFlag(ShipwideAIFlags.AIFlags.IN_CRITICAL_DPS_DANGER) || this.flags.hasFlag(ShipwideAIFlags.AIFlags.NEEDS_HELP) || this.flags.hasFlag(ShipwideAIFlags.AIFlags.HAS_INCOMING_DAMAGE)) {
                    return;
                }
            } else {
                ships = CombatUtils.getShipsWithinRange((Vector2f)this.ship.getLocation(), (float)100.0f);
                for (ShipAPI s : ships) {
                    if (s.isFighter() || s.isDrone() || s == this.ship.getDroneSource() || s == this.ship.getDroneSource().getParentStation() || s.isStationModule()) continue;
                    return;
                }
            }
            ships = CombatUtils.getShipsWithinRange((Vector2f)this.ship.getLocation(), (float)4000.0f);
            block8: for (ShipAPI s : ships) {
                MutableShipStatsAPI targetStats;
                if (this.ship.getOwner() != s.getOwner() || !s.isAlive() || s.isPhased() || s.isStation() || s.isStationModule() || s.isFighter() || s.isDrone() || this.ship == s || (targetStats = s.getMutableStats()) != null && targetStats.getHullDamageTakenMult().getMultMods().containsKey("SpatialSwapDamageReduction") || !s.getFluxTracker().isOverloadedOrVenting() && !(s.getHullLevel() < 1.0f) || !(StolenUtils.estimateIncomingDamage(s, 1.0f) >= s.getHitpoints() / 5.0f)) continue;
                switch (this.ship.getHullSize()) {
                    case CAPITAL_SHIP: {
                        if (s.getHullSize() == ShipAPI.HullSize.CAPITAL_SHIP || s.getHullSize() == ShipAPI.HullSize.CRUISER) break;
                        continue block8;
                    }
                    case CRUISER: {
                        if (s.getHullSize() == ShipAPI.HullSize.CAPITAL_SHIP || s.getHullSize() == ShipAPI.HullSize.CRUISER || s.getHullSize() == ShipAPI.HullSize.DESTROYER) break;
                        continue block8;
                    }
                    case DESTROYER: {
                        if (s.getHullSize() == ShipAPI.HullSize.CRUISER || s.getHullSize() == ShipAPI.HullSize.DESTROYER || s.getHullSize() == ShipAPI.HullSize.FRIGATE) break;
                        continue block8;
                    }
                    case FRIGATE: {
                        if (s.getHullSize() == ShipAPI.HullSize.DESTROYER || s.getHullSize() == ShipAPI.HullSize.FRIGATE || s.getHullSize() == ShipAPI.HullSize.FIGHTER) break;
                        continue block8;
                    }
                    case FIGHTER: {
                        if (s.getHullSize() == ShipAPI.HullSize.DESTROYER || s.getHullSize() == ShipAPI.HullSize.FRIGATE) break;
                        continue block8;
                    }
                    default: {
                        continue block8;
                    }
                }
                this.ship.setShipTarget(s);
                if (s.getShipAI() != null) {
                    ShipwideAIFlags tFlags = s.getAIFlags();
                    if (tFlags != null) {
                        this.flags.setFlag(ShipwideAIFlags.AIFlags.KEEP_SHIELDS_ON, 12.0f);
                    }
                    this.ship.useSystem();
                    break;
                }
                if (s.getShipTarget() != this.ship) continue;
                this.ship.useSystem();
                break;
            }
        }
        if (this.system.isActive()) {
            this.flags.setFlag(ShipwideAIFlags.AIFlags.KEEP_SHIELDS_ON, 1.5f);
            this.flags.unsetFlag(ShipwideAIFlags.AIFlags.BACK_OFF);
            this.flags.unsetFlag(ShipwideAIFlags.AIFlags.DO_NOT_PURSUE);
            this.flags.unsetFlag(ShipwideAIFlags.AIFlags.DO_NOT_USE_FLUX);
            this.flags.unsetFlag(ShipwideAIFlags.AIFlags.DO_NOT_AUTOFIRE_NON_ESSENTIAL_GROUPS);
            if (!this.resetAI) {
                this.resetAI = true;
                this.saveAIConfig(this.ship);
                this.ship.getShipAI().getConfig().alwaysStrafeOffensively = true;
                this.ship.getShipAI().getConfig().turnToFaceWithUndamagedArmor = false;
                this.ship.getShipAI().getConfig().personalityOverride = "reckless";
                this.ship.getShipAI().forceCircumstanceEvaluation();
            }
        } else if (this.resetAI) {
            this.resetAI = false;
            this.restoreAIConfig(this.ship);
            this.ship.getShipAI().forceCircumstanceEvaluation();
        }
    }

    public void init(ShipAPI ship, ShipSystemAPI system, ShipwideAIFlags flags, CombatEngineAPI engine) {
        this.ship = ship;
        this.flags = flags;
        this.system = system;
        this.engine = engine;
    }

    private void saveAIConfig(ShipAPI ship) {
        if (ship.getShipAI().getConfig() != null) {
            this.savedConfig.alwaysStrafeOffensively = ship.getShipAI().getConfig().alwaysStrafeOffensively;
            this.savedConfig.turnToFaceWithUndamagedArmor = ship.getShipAI().getConfig().turnToFaceWithUndamagedArmor;
            this.savedConfig.personalityOverride = ship.getShipAI().getConfig().personalityOverride;
        }
    }

    private void restoreAIConfig(ShipAPI ship) {
        if (ship.getShipAI().getConfig() != null) {
            ship.getShipAI().getConfig().alwaysStrafeOffensively = this.savedConfig.alwaysStrafeOffensively;
            ship.getShipAI().getConfig().turnToFaceWithUndamagedArmor = this.savedConfig.turnToFaceWithUndamagedArmor;
            ship.getShipAI().getConfig().personalityOverride = this.savedConfig.personalityOverride;
        }
    }
}

