/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.edshipyard.shipsystems.ai;

import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipSystemAIScript;
import com.fs.starfarer.api.combat.ShipSystemAPI;
import com.fs.starfarer.api.combat.ShipwideAIFlags;
import com.fs.starfarer.api.util.IntervalUtil;
import data.scripts.edshipyard.util.StolenUtils;
import org.lazywizard.lazylib.MathUtils;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class SteamDriveAI
implements ShipSystemAIScript {
    private CombatEngineAPI engine;
    private ShipwideAIFlags _flags;
    private ShipAPI _ship;
    private final IntervalUtil tracker = new IntervalUtil(1.2f, 1.3f);

    public void advance(float amount, Vector2f missileDangerDir, Vector2f collisionDangerDir, ShipAPI target) {
        if (this.engine == null) {
            return;
        }
        if (this.engine.isPaused()) {
            return;
        }
        this.tracker.advance(amount);
        if (this.tracker.intervalElapsed()) {
            boolean use = false;
            if (this._ship.getSystem().getState() == ShipSystemAPI.SystemState.ACTIVE || this._ship.getSystem().getState() == ShipSystemAPI.SystemState.IN) {
                if (!this.isEnemyShipInFrontButNotTooClose() || this._ship.getFluxLevel() > 0.9f) {
                    use = true;
                }
            } else {
                if (this.isTurning()) {
                    return;
                }
                if (this._ship.getFluxLevel() < 0.25f && this.isEnemyShipInFrontButNotTooClose()) {
                    use = true;
                }
            }
            if (use) {
                this._ship.useSystem();
            }
        }
    }

    private boolean isTurning() {
        return this._flags.hasFlag(ShipwideAIFlags.AIFlags.MANEUVER_TARGET) || this._flags.hasFlag(ShipwideAIFlags.AIFlags.TURN_QUICKLY);
    }

    private boolean isEnemyShipInFrontButNotTooClose() {
        Vector2f endPoint = new Vector2f((ReadableVector2f)this._ship.getLocation());
        endPoint.x = (float)((double)endPoint.x + Math.cos(Math.toRadians(this._ship.getFacing())) * 7000.0);
        endPoint.y = (float)((double)endPoint.y + Math.sin(Math.toRadians(this._ship.getFacing())) * 7000.0);
        ShipAPI s = StolenUtils.getFirstNonFighterOnSegment(this._ship.getLocation(), endPoint, (CombatEntityAPI)this._ship);
        return s != null && s.isAlive() && s.getOwner() != this._ship.getOwner() && MathUtils.getDistance((CombatEntityAPI)s, (CombatEntityAPI)this._ship) > 1000.0f;
    }

    public void init(ShipAPI ship, ShipSystemAPI system, ShipwideAIFlags flags, CombatEngineAPI engine) {
        this._ship = ship;
        this.engine = engine;
        this._flags = flags;
    }
}

