/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.edshipyard.shipsystems.ai;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.MissileAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipSystemAIScript;
import com.fs.starfarer.api.combat.ShipSystemAPI;
import com.fs.starfarer.api.combat.ShipwideAIFlags;
import com.fs.starfarer.api.util.IntervalUtil;
import org.lazywizard.lazylib.CollisionUtils;
import org.lazywizard.lazylib.MathUtils;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class TargetMissilesAI
implements ShipSystemAIScript {
    private static final float dangerDistanceSquared = 360000.0f;
    private final IntervalUtil tracker = new IntervalUtil(0.2f, 0.2f);
    private ShipAPI _ship;

    public static boolean useSystem(ShipAPI ship) {
        if (ship.getSystem().getState() != ShipSystemAPI.SystemState.IDLE) {
            return false;
        }
        int count = 0;
        float damage = 0.0f;
        for (MissileAPI missile : Global.getCombatEngine().getMissiles()) {
            float distanceSquared;
            if (missile.getOwner() == ship.getOwner() || missile.isFizzling() || !((distanceSquared = MathUtils.getDistanceSquared((CombatEntityAPI)ship, (CombatEntityAPI)missile)) <= 360000.0f)) continue;
            Vector2f endPoint = new Vector2f((ReadableVector2f)missile.getVelocity());
            endPoint.scale(3.0f);
            Vector2f.add((Vector2f)endPoint, (Vector2f)missile.getLocation(), (Vector2f)endPoint);
            if (missile.getDamageTarget() != ship && !CollisionUtils.getCollides((Vector2f)missile.getLocation(), (Vector2f)endPoint, (Vector2f)ship.getLocation(), (float)250.0f)) continue;
            ++count;
            damage = missile.getBaseDamageAmount();
        }
        return count >= 4 || damage >= 2000.0f;
    }

    public void init(ShipAPI ship, ShipSystemAPI system, ShipwideAIFlags flags, CombatEngineAPI engine) {
        this._ship = ship;
    }

    public void advance(float amount, Vector2f missileDangerDir, Vector2f collisionDangerDir, ShipAPI target) {
        this.tracker.advance(amount);
        if (!this.tracker.intervalElapsed()) {
            return;
        }
        if (TargetMissilesAI.useSystem(this._ship)) {
            this._ship.useSystem();
        }
    }
}

