/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.edshipyard.util;

import com.fs.starfarer.api.combat.CombatEntityAPI;
import data.scripts.edshipyard.util.DebugRender;
import data.scripts.edshipyard.util.Quadrilateral;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import org.lazywizard.lazylib.CollisionUtils;
import org.lazywizard.lazylib.MathUtils;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class Area {
    public List<Quadrilateral> boxes = new ArrayList<Quadrilateral>();
    public List<Vector2f> points = new ArrayList<Vector2f>();
    public Vector2f ourLocation;
    public final float maxDistanceSquared;

    public Area(float maxDistance, Vector2f ourLocation) {
        this.maxDistanceSquared = maxDistance * maxDistance;
        this.ourLocation = new Vector2f((ReadableVector2f)ourLocation);
    }

    public boolean contains(CombatEntityAPI entity) {
        if (MathUtils.getDistanceSquared((Vector2f)this.ourLocation, (Vector2f)entity.getLocation()) > this.maxDistanceSquared) {
            return false;
        }
        for (Vector2f point : this.points) {
            if (!CollisionUtils.isPointWithinBounds((Vector2f)point, (CombatEntityAPI)entity)) continue;
            return true;
        }
        for (Quadrilateral box : this.boxes) {
            if (!box.containsPoint(entity.getLocation())) continue;
            return true;
        }
        return false;
    }

    public void renderIfDebug(Color c) {
        for (Vector2f point : this.points) {
            DebugRender.renderIfDebug(point, c);
        }
        for (Quadrilateral box : this.boxes) {
            DebugRender.renderIfDebug(box, c);
        }
    }
}

