/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.edshipyard.util;

import data.scripts.edshipyard.util.DebugRender;
import java.awt.Color;
import org.lwjgl.util.vector.Vector2f;

public class Quadrilateral {
    public Vector2f bottomLeft;
    public Vector2f topLeft;
    public Vector2f topRight;
    public Vector2f bottomRight;

    public float area() {
        return Quadrilateral.triangleArea(this.bottomLeft, this.topLeft, this.topRight) + Quadrilateral.triangleArea(this.bottomLeft, this.bottomRight, this.topRight);
    }

    static float triangleArea(Vector2f v1, Vector2f v2, Vector2f v3) {
        return Math.abs((v1.x * (v2.y - v3.y) + v2.x * (v3.y - v1.y) + v3.x * (v1.y - v2.y)) / 2.0f);
    }

    public boolean containsPoint(Vector2f point) {
        float A = this.area();
        float pointArea = Quadrilateral.triangleArea(point, this.bottomLeft, this.topLeft);
        pointArea += Quadrilateral.triangleArea(point, this.topLeft, this.topRight);
        pointArea += Quadrilateral.triangleArea(point, this.topRight, this.bottomRight);
        return Math.abs(A - (pointArea += Quadrilateral.triangleArea(point, this.bottomRight, this.bottomLeft))) < 1.0f;
    }

    public Vector2f getRandomPointInArea() {
        if (Math.random() >= 0.5) {
            return this.getRandomPointInTriangle(this.bottomLeft, this.topLeft, this.topRight);
        }
        return this.getRandomPointInTriangle(this.bottomLeft, this.bottomRight, this.topRight);
    }

    private Vector2f getRandomPointInTriangle(Vector2f a, Vector2f b, Vector2f c) {
        double r1 = Math.random();
        double r2 = Math.random();
        double sqrtR1 = Math.sqrt(r1);
        double x = (1.0 - sqrtR1) * (double)a.x + sqrtR1 * (1.0 - r2) * (double)b.x + sqrtR1 * r2 * (double)c.x;
        double y = (1.0 - sqrtR1) * (double)a.y + sqrtR1 * (1.0 - r2) * (double)b.y + sqrtR1 * r2 * (double)c.y;
        return new Vector2f((float)x, (float)y);
    }

    public void renderIfDebug(Color c) {
        DebugRender.renderIfDebug(this, c);
    }
}

