/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.edshipyard.util;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.ArmorGridAPI;
import com.fs.starfarer.api.combat.BeamAPI;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.DamageType;
import com.fs.starfarer.api.combat.DamagingProjectileAPI;
import com.fs.starfarer.api.combat.DeployedFleetMemberAPI;
import com.fs.starfarer.api.combat.MissileAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.WeaponAPI;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.lazywizard.lazylib.CollisionUtils;
import org.lazywizard.lazylib.FastTrig;
import org.lazywizard.lazylib.MathUtils;
import org.lazywizard.lazylib.VectorUtils;
import org.lazywizard.lazylib.combat.AIUtils;
import org.lazywizard.lazylib.combat.CombatUtils;
import org.lazywizard.lazylib.combat.entities.SimpleEntity;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class StolenUtils {
    static final float SAFE_DISTANCE = 600.0f;
    static final float DEFAULT_DAMAGE_WINDOW = 3.0f;
    static final Map<ShipAPI.HullSize, Float> baseOverloadTimes = new HashMap<ShipAPI.HullSize, Float>();

    public static Vector2f getMidpoint(Vector2f from, Vector2f to, float d) {
        return new Vector2f((from.x * (2.0f - (d *= 2.0f)) + to.x * d) / 2.0f, (from.y * (2.0f - d) + to.y * d) / 2.0f);
    }

    public static Vector2f toRelative(CombatEntityAPI entity, Vector2f point) {
        Vector2f retVal = new Vector2f((ReadableVector2f)point);
        Vector2f.sub((Vector2f)retVal, (Vector2f)entity.getLocation(), (Vector2f)retVal);
        VectorUtils.rotate((Vector2f)retVal, (float)(-entity.getFacing()), (Vector2f)retVal);
        return retVal;
    }

    public static Vector2f toAbsolute(CombatEntityAPI entity, Vector2f point) {
        Vector2f retVal = new Vector2f((ReadableVector2f)point);
        VectorUtils.rotate((Vector2f)retVal, (float)entity.getFacing(), (Vector2f)retVal);
        Vector2f.add((Vector2f)retVal, (Vector2f)entity.getLocation(), (Vector2f)retVal);
        return retVal;
    }

    public static void blink(Vector2f at) {
        Global.getCombatEngine().addHitParticle(at, new Vector2f(), 30.0f, 1.0f, 0.1f, Color.RED);
    }

    public static List<ShipAPI> getShipsOnSegment(Vector2f from, Vector2f to) {
        float distance = MathUtils.getDistance((Vector2f)from, (Vector2f)to);
        Vector2f center = new Vector2f();
        center.x = (from.x + to.x) / 2.0f;
        center.y = (from.y + to.y) / 2.0f;
        ArrayList<ShipAPI> list = new ArrayList<ShipAPI>();
        for (ShipAPI s : CombatUtils.getShipsWithinRange((Vector2f)center, (float)(distance / 2.0f))) {
            if (CollisionUtils.getCollisionPoint((Vector2f)from, (Vector2f)to, (CombatEntityAPI)s) == null) continue;
            list.add(s);
        }
        return list;
    }

    public static ShipAPI getFirstShipOnSegment(Vector2f from, Vector2f to, CombatEntityAPI exception) {
        ShipAPI winner = null;
        float record = Float.MAX_VALUE;
        for (ShipAPI s : StolenUtils.getShipsOnSegment(from, to)) {
            float dist2;
            if (s == exception || !((dist2 = MathUtils.getDistanceSquared((CombatEntityAPI)s, (Vector2f)from)) < record)) continue;
            record = dist2;
            winner = s;
        }
        return winner;
    }

    public static ShipAPI getFirstNonFighterOnSegment(Vector2f from, Vector2f to, CombatEntityAPI exception) {
        ShipAPI winner = null;
        float record = Float.MAX_VALUE;
        for (ShipAPI s : StolenUtils.getShipsOnSegment(from, to)) {
            float dist2;
            if (s == exception || s.isFighter() || !((dist2 = MathUtils.getDistanceSquared((CombatEntityAPI)s, (Vector2f)from)) < record)) continue;
            record = dist2;
            winner = s;
        }
        return winner;
    }

    public static ShipAPI getFirstShipOnSegment(Vector2f from, Vector2f to) {
        return StolenUtils.getFirstShipOnSegment(from, to, null);
    }

    public static ShipAPI getShipInLineOfFire(WeaponAPI weapon) {
        Vector2f endPoint = weapon.getLocation();
        endPoint.x = (float)((double)endPoint.x + Math.cos(Math.toRadians(weapon.getCurrAngle())) * (double)weapon.getRange());
        endPoint.y = (float)((double)endPoint.y + Math.sin(Math.toRadians(weapon.getCurrAngle())) * (double)weapon.getRange());
        return StolenUtils.getFirstShipOnSegment(weapon.getLocation(), endPoint, (CombatEntityAPI)weapon.getShip());
    }

    public static float getArmorPercent(ShipAPI ship) {
        float acc = 0.0f;
        int width = ship.getArmorGrid().getGrid().length;
        int height = ship.getArmorGrid().getGrid()[0].length;
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                acc += ship.getArmorGrid().getArmorFraction(x, y);
            }
        }
        return acc / (float)(width * height);
    }

    public static void setArmorPercentage(ShipAPI ship, float armorPercent) {
        ArmorGridAPI armorGrid = ship.getArmorGrid();
        armorPercent = Math.min(1.0f, Math.max(0.0f, armorPercent));
        for (int x = 0; x < armorGrid.getGrid().length; ++x) {
            for (int y = 0; y < armorGrid.getGrid()[0].length; ++y) {
                armorGrid.setArmorValue(x, y, armorGrid.getMaxArmorInCell() * armorPercent);
            }
        }
    }

    public static void destroy(CombatEntityAPI entity) {
        Global.getCombatEngine().applyDamage(entity, entity.getLocation(), entity.getMaxHitpoints() * 10.0f, DamageType.HIGH_EXPLOSIVE, 0.0f, true, true, (Object)entity);
    }

    public static float estimateIncomingDamage(ShipAPI ship) {
        return StolenUtils.estimateIncomingDamage(ship, 3.0f);
    }

    public static float estimateIncomingDamage(ShipAPI ship, float damageWindowSeconds) {
        float accumulator = 0.0f;
        accumulator += StolenUtils.estimateIncomingBeamDamage(ship, damageWindowSeconds);
        for (DamagingProjectileAPI proj : Global.getCombatEngine().getProjectiles()) {
            if (proj.getOwner() == ship.getOwner()) continue;
            Vector2f endPoint = new Vector2f((ReadableVector2f)proj.getVelocity());
            endPoint.scale(damageWindowSeconds);
            Vector2f.add((Vector2f)endPoint, (Vector2f)proj.getLocation(), (Vector2f)endPoint);
            if (ship.getShield() != null && ship.getShield().isWithinArc(proj.getLocation()) || !CollisionUtils.getCollides((Vector2f)proj.getLocation(), (Vector2f)endPoint, (Vector2f)new Vector2f((ReadableVector2f)ship.getLocation()), (float)ship.getCollisionRadius())) continue;
            accumulator += proj.getDamageAmount() + proj.getEmpAmount();
        }
        return accumulator;
    }

    public static float estimateAllIncomingDamage(ShipAPI ship) {
        return StolenUtils.estimateIncomingDamage(ship, 3.0f);
    }

    public static float estimateIncomingBeamDamage(ShipAPI ship, float damageWindowSeconds) {
        float accumulator = 0.0f;
        for (BeamAPI beam : Global.getCombatEngine().getBeams()) {
            if (beam.getDamageTarget() != ship) continue;
            float dps = beam.getWeapon().getDerivedStats().getDamageOver30Sec() / 30.0f;
            float emp = beam.getWeapon().getDerivedStats().getEmpPerSecond();
            accumulator += (dps + emp) * damageWindowSeconds;
        }
        return accumulator;
    }

    public static float estimateIncomingMissileDamage(ShipAPI ship) {
        float accumulator = 0.0f;
        for (MissileAPI missileAPI : Global.getCombatEngine().getMissiles()) {
            MissileAPI missile = missileAPI;
            if (missile.getOwner() == ship.getOwner()) continue;
            float safeDistance = 600.0f + ship.getCollisionRadius();
            float threat = missile.getDamageAmount() + missile.getEmpAmount();
            if (ship.getShield() != null && ship.getShield().isWithinArc(missile.getLocation())) continue;
            accumulator = (float)((double)accumulator + (double)threat * Math.max(0.0, Math.min(1.0, Math.pow(1.0f - MathUtils.getDistance((CombatEntityAPI)missile, (CombatEntityAPI)ship) / safeDistance, 2.0))));
        }
        return accumulator;
    }

    public static float getHitChance(DamagingProjectileAPI proj, CombatEntityAPI target) {
        float estTimeTilHit = MathUtils.getDistance((CombatEntityAPI)target, (Vector2f)proj.getLocation()) / Math.max(1.0f, proj.getWeapon().getProjectileSpeed());
        Vector2f estTargetPosChange = new Vector2f(target.getVelocity().x * estTimeTilHit, target.getVelocity().y * estTimeTilHit);
        float estFacingChange = target.getAngularVelocity() * estTimeTilHit;
        Vector2f projVelocity = proj.getVelocity();
        target.setFacing(target.getFacing() + estFacingChange);
        Vector2f.add((Vector2f)target.getLocation(), (Vector2f)estTargetPosChange, (Vector2f)target.getLocation());
        projVelocity.scale(estTimeTilHit * 3.0f);
        Vector2f.add((Vector2f)projVelocity, (Vector2f)proj.getLocation(), (Vector2f)projVelocity);
        Vector2f estHitLoc = CollisionUtils.getCollisionPoint((Vector2f)proj.getLocation(), (Vector2f)projVelocity, (CombatEntityAPI)target);
        target.setFacing(target.getFacing() - estFacingChange);
        Vector2f.add((Vector2f)target.getLocation(), (Vector2f)((Vector2f)estTargetPosChange.scale(-1.0f)), (Vector2f)target.getLocation());
        if (estHitLoc == null) {
            return 0.0f;
        }
        return 1.0f;
    }

    public static float getHitChance(WeaponAPI weapon, CombatEntityAPI target) {
        float estTimeTilHit = MathUtils.getDistance((CombatEntityAPI)target, (Vector2f)weapon.getLocation()) / Math.max(1.0f, weapon.getProjectileSpeed());
        Vector2f estTargetPosChange = new Vector2f(target.getVelocity().x * estTimeTilHit, target.getVelocity().y * estTimeTilHit);
        float estFacingChange = target.getAngularVelocity() * estTimeTilHit;
        double theta = (double)weapon.getCurrAngle() * (Math.PI / 180);
        Vector2f projVelocity = new Vector2f((float)Math.cos(theta) * weapon.getProjectileSpeed() + weapon.getShip().getVelocity().x, (float)Math.sin(theta) * weapon.getProjectileSpeed() + weapon.getShip().getVelocity().y);
        target.setFacing(target.getFacing() + estFacingChange);
        Vector2f.add((Vector2f)target.getLocation(), (Vector2f)estTargetPosChange, (Vector2f)target.getLocation());
        projVelocity.scale(estTimeTilHit * 3.0f);
        Vector2f.add((Vector2f)projVelocity, (Vector2f)weapon.getLocation(), (Vector2f)projVelocity);
        Vector2f estHitLoc = CollisionUtils.getCollisionPoint((Vector2f)weapon.getLocation(), (Vector2f)projVelocity, (CombatEntityAPI)target);
        target.setFacing(target.getFacing() - estFacingChange);
        Vector2f.add((Vector2f)target.getLocation(), (Vector2f)((Vector2f)estTargetPosChange.scale(-1.0f)), (Vector2f)target.getLocation());
        if (estHitLoc == null) {
            return 0.0f;
        }
        return 1.0f;
    }

    public static float getFPWorthOfSupport(ShipAPI ship, float range) {
        float retVal = 0.0f;
        for (ShipAPI ally : AIUtils.getNearbyAllies((CombatEntityAPI)ship, (float)range)) {
            if (ally == ship) continue;
            float colDist = ship.getCollisionRadius() + ally.getCollisionRadius();
            float distance = Math.max(0.0f, MathUtils.getDistance((CombatEntityAPI)ship, (CombatEntityAPI)ally) - colDist);
            float maxRange = Math.max(1.0f, range - colDist);
            retVal += StolenUtils.getFPStrength(ally) * (1.0f - distance / maxRange);
        }
        return retVal;
    }

    public static float getFPWorthOfHostility(ShipAPI ship, float range) {
        float retVal = 0.0f;
        for (ShipAPI enemy : AIUtils.getNearbyEnemies((CombatEntityAPI)ship, (float)range)) {
            float colDist = ship.getCollisionRadius() + enemy.getCollisionRadius();
            float distance = Math.max(0.0f, MathUtils.getDistance((CombatEntityAPI)ship, (CombatEntityAPI)enemy) - colDist);
            float maxRange = Math.max(1.0f, range - colDist);
            retVal += StolenUtils.getFPStrength(enemy) * (1.0f - distance / maxRange);
        }
        return retVal;
    }

    public static float getStrengthInArea(Vector2f at, float range) {
        float retVal = 0.0f;
        for (ShipAPI ship : CombatUtils.getShipsWithinRange((Vector2f)at, (float)range)) {
            retVal += StolenUtils.getFPStrength(ship);
        }
        return retVal;
    }

    public static float getStrengthInArea(Vector2f at, float range, int owner) {
        float retVal = 0.0f;
        for (ShipAPI ship : CombatUtils.getShipsWithinRange((Vector2f)at, (float)range)) {
            if (ship.getOwner() != owner) continue;
            retVal += StolenUtils.getFPStrength(ship);
        }
        return retVal;
    }

    public static float getFPStrength(ShipAPI ship) {
        DeployedFleetMemberAPI member = Global.getCombatEngine().getFleetManager(ship.getOwner()).getDeployedFleetMember(ship);
        return member == null || member.getMember() == null ? 0.0f : member.getMember().getMemberStrength();
    }

    public static float getFP(ShipAPI ship) {
        DeployedFleetMemberAPI member = Global.getCombatEngine().getFleetManager(ship.getOwner()).getDeployedFleetMember(ship);
        return member == null || member.getMember() == null ? 0.0f : (float)member.getMember().getFleetPointCost();
    }

    public static float getBaseOverloadDuration(ShipAPI ship) {
        return baseOverloadTimes.get(ship.getHullSize()).floatValue();
    }

    public static float estimateOverloadDurationOnHit(ShipAPI ship, float damage, DamageType type) {
        if (ship.getShield() == null) {
            return 0.0f;
        }
        float fluxDamage = damage * type.getShieldMult() * ship.getMutableStats().getShieldAbsorptionMult().getModifiedValue();
        if ((fluxDamage += ship.getFluxTracker().getCurrFlux() - ship.getFluxTracker().getMaxFlux()) <= 0.0f) {
            return 0.0f;
        }
        return Math.min(15.0f, StolenUtils.getBaseOverloadDuration(ship) + fluxDamage / 25.0f);
    }

    public static float getLifeExpectancy(ShipAPI ship) {
        float damage = StolenUtils.estimateIncomingDamage(ship);
        return damage <= 0.0f ? 3600.0f : ship.getHitpoints() / damage;
    }

    public static void createSmoothFlare(CombatEngineAPI engine, ShipAPI origin, Vector2f point, float thickness, float length, float angle, Color fringeColor, Color coreColor) {
        int i = 1;
        while ((float)i < length / 50.0f) {
            point.x = (float)((double)point.x + FastTrig.cos((double)(angle * (float)Math.PI / 180.0f)));
            point.y = (float)((double)point.y + FastTrig.sin((double)(angle * (float)Math.PI / 180.0f)));
            engine.spawnEmpArc(origin, point, null, (CombatEntityAPI)new SimpleEntity(point), DamageType.FRAGMENTATION, 0.0f, 0.0f, 10.0f, null, 25.0f, new Color(fringeColor.getRed(), fringeColor.getGreen(), fringeColor.getBlue(), Math.min(255, (int)(thickness * (float)fringeColor.getAlpha() / 128.0f))), coreColor);
            ++i;
        }
    }

    static {
        baseOverloadTimes.put(ShipAPI.HullSize.FIGHTER, Float.valueOf(10.0f));
        baseOverloadTimes.put(ShipAPI.HullSize.FRIGATE, Float.valueOf(4.0f));
        baseOverloadTimes.put(ShipAPI.HullSize.DESTROYER, Float.valueOf(6.0f));
        baseOverloadTimes.put(ShipAPI.HullSize.CRUISER, Float.valueOf(8.0f));
        baseOverloadTimes.put(ShipAPI.HullSize.CAPITAL_SHIP, Float.valueOf(10.0f));
        baseOverloadTimes.put(ShipAPI.HullSize.DEFAULT, Float.valueOf(6.0f));
    }
}

