/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.edshipyard.weapons;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.BeamAPI;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.DamageType;
import com.fs.starfarer.api.combat.EveryFrameWeaponEffectPlugin;
import com.fs.starfarer.api.combat.MissileAPI;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.WeaponAPI;
import com.fs.starfarer.api.graphics.SpriteAPI;
import com.fs.starfarer.api.loading.ProjectileSpecAPI;
import com.fs.starfarer.api.util.IntervalUtil;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.combat.entities.DamagingExplosion;
import com.fs.starfarer.combat.entities.Ship;
import com.fs.starfarer.util.IntervalTracker;
import data.dcr.edshipyard.DamageReportManagerV1;
import data.scripts.edshipyard.ai.WurgandalModuleShipAI;
import data.scripts.edshipyard.util.StolenUtils;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.dark.shaders.distortion.DistortionAPI;
import org.dark.shaders.distortion.DistortionShader;
import org.dark.shaders.distortion.RippleDistortion;
import org.lazywizard.lazylib.MathUtils;
import org.lazywizard.lazylib.combat.CombatUtils;
import org.lazywizard.lazylib.combat.entities.SimpleEntity;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;
import org.magiclib.util.MagicFakeBeam;
import org.magiclib.util.MagicLensFlare;
import org.magiclib.util.MagicRender;

public class MAW_EveryFrameEffect
implements EveryFrameWeaponEffectPlugin {
    private static final float BEAM_BURST_DAMAGE = 5000.0f;
    private static final float BEAM_BURST_INITIAL_CHAIN_DISTANCE = 725.0f;
    private static final float BEAM_BURST_MAX_CHAIN_DISTANCE_FROM_ORIGIN = 1400.0f;
    private static final float BEAM_BURST_CHAIN_DECAY_RATE = 0.7f;
    private static final float MANEUVER_AFFECT = 0.18f;
    public final List<ZapEmitter> ZapEmitters = new ArrayList<ZapEmitter>();
    private ShipAPI ship;
    private ShipAPI ShieldModuleL;
    private ShipAPI ShieldModuleR;
    private ShipAPI WeaponModuleL;
    private ShipAPI WeaponModuleR;
    private ShipAPI HangarModuleL;
    private ShipAPI HangarModuleR;
    private ShipAPI EngineModuleB;
    private final List<ShipAPI> _modules = new ArrayList<ShipAPI>();
    public static final String wurg_SML = "edshipyard_wurg_jawleft";
    public static final String wurg_SMR = "edshipyard_wurg_jawright";
    public static final String wurg_WML = "edshipyard_wurg_weaponleft";
    public static final String wurg_WMR = "edshipyard_wurg_weaponright";
    public static final String wurg_HML = "edshipyard_wurg_hangarleft";
    public static final String wurg_HMR = "edshipyard_wurg_hangarright";
    public static final String wurg_BTC = "edshipyard_wurg_buttocks";
    private final IntervalTracker gunStillWorks = new IntervalTracker(0.5f, 0.5f);
    private final IntervalTracker chargeUpSparkOnTarget = new IntervalTracker(0.15f, 0.25f);
    private float timer;
    private float period;
    private float prevCharge;
    private boolean fire;
    private boolean disabled;
    private Random rnd;
    private final String zapSprite = "edzap_";
    private final String effectID = "Tyrant Maw Siege Mode";
    private MutableShipStatsAPI stats;
    private WeaponAPI bar;
    private float lastFrameAmmo = 0.0f;
    private BurstArcEffect burstArcEffect = null;

    private void init(WeaponAPI weapon) {
        if (this.ship == null) {
            this.ship = weapon.getShip();
            this.fire = false;
            this.timer = 0.0f;
            this.period = 0.0f;
            this.disabled = false;
            this.stats = this.ship.getMutableStats();
            this.rnd = new Random();
            for (ShipAPI m : this.ship.getChildModulesCopy()) {
                switch (m.getHullSpec().getBaseHullId()) {
                    case "edshipyard_wurg_jawleft": {
                        this.ShieldModuleL = m;
                        this._modules.add(m);
                        break;
                    }
                    case "edshipyard_wurg_jawright": {
                        this.ShieldModuleR = m;
                        this._modules.add(m);
                        break;
                    }
                    case "edshipyard_wurg_weaponleft": {
                        this.WeaponModuleL = m;
                        this._modules.add(m);
                        break;
                    }
                    case "edshipyard_wurg_weaponright": {
                        this.WeaponModuleR = m;
                        this._modules.add(m);
                        break;
                    }
                    case "edshipyard_wurg_hangarleft": {
                        this.HangarModuleL = m;
                        this._modules.add(m);
                        break;
                    }
                    case "edshipyard_wurg_hangarright": {
                        this.HangarModuleR = m;
                        this._modules.add(m);
                        break;
                    }
                    case "edshipyard_wurg_buttocks": {
                        this.EngineModuleB = m;
                        this._modules.add(m);
                    }
                }
            }
            weapon.setAmmo(0);
            for (WeaponAPI w : this.ship.getAllWeapons()) {
                if (!w.isDecorative() || !w.getDisplayName().contains("Charge Bar")) continue;
                this.bar = w;
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void advance(float amount, CombatEngineAPI engine, WeaponAPI weapon) {
        boolean hasMore;
        if (engine.isPaused()) {
            return;
        }
        this.init(weapon);
        if (this.burstArcEffect != null && !(hasMore = this.burstArcEffect.advance(amount))) {
            this.burstArcEffect = null;
        }
        this.handleZapEmitters(amount);
        if ((float)weapon.getAmmo() > this.lastFrameAmmo) {
            Global.getSoundPlayer().playSound("ed_mag2", 0.7f, 1.0f, this.ship.getLocation(), this.ship.getVelocity());
        }
        try {
            float charge = weapon.getChargeLevel();
            if (charge > 0.0f && charge < 1.0f && !this.fire) {
                this.spark(0.0f, 0.05f + charge * charge * 0.75f, weapon);
                if (this.ship.getFluxTracker().isVenting()) {
                    this.interrupt(weapon);
                }
            }
            if (this.disabled) {
                this.bar.getAnimation().setFrame(48);
                weapon.setAmmo(0);
                return;
            }
            this.gunStillWorks.advance(amount);
            if (!(!this.gunStillWorks.intervalElapsed() || this.ShieldModuleL != null && this.ShieldModuleR != null && this.WeaponModuleL != null && this.WeaponModuleR != null && this.HangarModuleL != null && this.HangarModuleR != null && this.EngineModuleB != null && this.ShieldModuleL.isAlive() && this.ShieldModuleR.isAlive() && this.WeaponModuleL.isAlive() && this.WeaponModuleR.isAlive() && this.HangarModuleL.isAlive() && this.HangarModuleR.isAlive() && this.EngineModuleB.isAlive())) {
                this.disabled = true;
                weapon.disable(true);
                this.unmodify();
                engine.addFloatingText(this.ship.getLocation(), "Maw Disabled", 100.0f, Color.red, (CombatEntityAPI)this.ship, 0.5f, 3.0f);
                return;
            }
            this.renderRingCharge(charge);
            if (charge >= 1.0f) {
                Vector2f muzzle = new Vector2f((ReadableVector2f)MathUtils.getPoint((Vector2f)weapon.getLocation(), (float)17.0f, (float)weapon.getCurrAngle()));
                if (!this.fire) {
                    this.fire = true;
                    this.doMawBurstDamage(engine, weapon, muzzle);
                }
                this.period += amount;
                if (this.period >= 0.5f) {
                    this.period = 0.0f;
                    Global.getSoundPlayer().playSound("mawfireloop", 1.0f, 1.2f, this.ship.getLocation(), this.ship.getVelocity());
                    if (MagicRender.screenCheck((float)0.25f, (Vector2f)weapon.getLocation())) {
                        MagicLensFlare.createSharpFlare((CombatEngineAPI)engine, (ShipAPI)this.ship, (Vector2f)muzzle, (float)6.0f, (float)600.0f, (float)0.0f, (Color)new Color(250, 150, 255, 128), (Color)Color.white);
                    }
                }
            } else if (charge == 0.0f) {
                this.fire = false;
                this.timer = 0.0f;
                if (this.ship.getFluxTracker().isOverloaded()) {
                    this.bar.getAnimation().setAlphaMult(0.5f + (float)Math.random() * 0.4f);
                    return;
                }
            } else if (charge > 0.0f && charge < 1.0f && !this.fire) {
                this.timer += (charge - this.prevCharge) * 20.0f;
                if (this.ship.getFluxTracker().isOverloaded()) {
                    this.interrupt(weapon);
                    return;
                }
                if (this.ship.getFluxLevel() > 0.999999f) {
                    this.ship.getFluxTracker().beginOverloadWithTotalBaseDuration(10.0f);
                    this.interrupt(weapon);
                    return;
                }
                if (this.prevCharge == 0.0f) {
                    this.spark(1.0f, charge, weapon);
                    Global.getSoundPlayer().playSound("ed_spark", 1.0f, 1.0f, this.ship.getLocation(), this.ship.getVelocity());
                    for (ShipAPI module : this._modules) {
                        this.setModuleFiringStatus(module, false);
                    }
                    this.stats.getMaxSpeed().modifyMult("Tyrant Maw Siege Mode", 0.18f);
                    this.stats.getMaxTurnRate().modifyMult("Tyrant Maw Siege Mode", 0.18f);
                    this.stats.getTurnAcceleration().modifyMult("Tyrant Maw Siege Mode", 0.18f);
                }
                this.prevCharge = charge;
                if (this.timer >= 1.0f) {
                    Global.getSoundPlayer().playSound("mawloop", 1.0f + charge * 3.0f, 1.0f, this.ship.getLocation(), this.ship.getVelocity());
                    this.timer -= 1.0f;
                    if (charge > 0.3f) {
                        Global.getSoundPlayer().playSound("mawfireloop", 1.0f, charge / 2.0f, this.ship.getLocation(), this.ship.getVelocity());
                    }
                    if (this.ShieldModuleL.getFluxTracker().isOverloaded() || this.ShieldModuleR.getFluxTracker().isOverloaded() || this.WeaponModuleL.getFluxTracker().isOverloaded() || this.WeaponModuleR.getFluxTracker().isOverloaded() || this.HangarModuleL.getFluxTracker().isOverloaded() || this.HangarModuleR.getFluxTracker().isOverloaded() || this.EngineModuleB.getFluxTracker().isOverloaded()) {
                        this.ship.getFluxTracker().beginOverloadWithTotalBaseDuration(10.0f);
                        if (!weapon.isDisabled()) {
                            this.ship.setCurrentCR(this.ship.getCurrentCR() * 0.75f);
                            weapon.disable();
                        }
                        this.fire = true;
                        Global.getSoundPlayer().playSound("mawend", 1.0f, 1.0f, this.ship.getLocation(), this.ship.getVelocity());
                        this.unmodify();
                        return;
                    }
                }
                this.chargeUpSparkOnTarget.advance(amount);
                if (this.chargeUpSparkOnTarget.intervalElapsed() && this.rnd.nextFloat() < charge) {
                    if (weapon.getBeams() == null || weapon.getBeams().size() <= 0) {
                        return;
                    }
                    BeamAPI beam = (BeamAPI)weapon.getBeams().get(0);
                    float zapDamage = 50.0f;
                    List nearbyEntities = CombatUtils.getEntitiesWithinRange((Vector2f)beam.getRayEndPrevFrame(), (float)471.24997f);
                    if (nearbyEntities.size() > 0) {
                        CombatEntityAPI target = (CombatEntityAPI)nearbyEntities.get(this.rnd.nextInt(nearbyEntities.size()));
                        engine.spawnEmpArc(beam.getSource(), beam.getRayEndPrevFrame(), target, target, DamageType.ENERGY, zapDamage, zapDamage, 100000.0f, "tachyon_lance_emp_impact", beam.getWidth() / 2.0f, beam.getFringeColor(), beam.getCoreColor());
                        DamageReportManagerV1.addDamageClarification(zapDamage, zapDamage, DamageType.ENERGY, (CombatEntityAPI)beam.getSource(), target, beam.getWeapon().getDisplayName());
                        if (target instanceof ProjectileSpecAPI || target instanceof MissileAPI) {
                            Global.getCombatEngine().removeEntity(target);
                        }
                    }
                }
            } else if (charge > 0.0f && charge < 1.0f && this.fire) {
                this.period = 0.0f;
                if (this.prevCharge > 0.0f) {
                    this.prevCharge = 0.0f;
                    this.ShieldModuleL.getFluxTracker().beginOverloadWithTotalBaseDuration(2.5f);
                    this.ShieldModuleR.getFluxTracker().beginOverloadWithTotalBaseDuration(2.5f);
                    Global.getSoundPlayer().playSound("mawend", 1.0f, 1.0f, this.ship.getLocation(), this.ship.getVelocity());
                    this.unmodify();
                }
            }
        }
        finally {
            this.lastFrameAmmo = weapon.getAmmo();
        }
    }

    private void doMawBurstDamage(CombatEngineAPI engine, WeaponAPI weapon, Vector2f muzzle) {
        if (weapon.getBeams() == null || weapon.getBeams().size() <= 0) {
            return;
        }
        BeamAPI beam = (BeamAPI)weapon.getBeams().get(0);
        Global.getSoundPlayer().playSound("mawfire", 1.0f, 3.0f, this.ship.getLocation(), this.ship.getVelocity());
        float burstDamage = 5000.0f * (this.stats.getEnergyWeaponDamageMult().getModifiedValue() * this.stats.getEnergyWeaponDamageMult().getModifiedValue());
        float burstRange = 725.0f * this.stats.getEnergyWeaponRangeBonus().getBonusMult();
        float range = weapon.getRange() * (1.0f + this.stats.getEnergyWeaponRangeBonus().getPercentMod() / 100.0f);
        MagicFakeBeam.spawnFakeBeam((CombatEngineAPI)engine, (Vector2f)weapon.getLocation(), (float)Math.min(weapon.getRange(), range), (float)this.ship.getFacing(), (float)200.0f, (float)0.1f, (float)0.9f, (float)150.0f, (Color)new Color(255, 225, 255), (Color)new Color(100, 0, 150, 125), (float)burstDamage, (DamageType)DamageType.ENERGY, (float)burstDamage, (ShipAPI)this.ship);
        DamageReportManagerV1.addDamageClarification(burstDamage, burstDamage, DamageType.ENERGY, (CombatEntityAPI)beam.getSource(), beam.getDamageTarget(), beam.getWeapon().getDisplayName());
        this.burstArcEffect = new BurstArcEffect(beam.getDamageTarget(), beam.getRayEndPrevFrame(), burstDamage * 0.75f, engine, beam, burstRange, this);
        float startSize = 362.5f;
        float endSize = 1087.5f;
        RippleDistortion ripple = new RippleDistortion(beam.getRayEndPrevFrame(), Misc.ZERO);
        ripple.setSize(endSize);
        ripple.setIntensity(40.0f);
        ripple.setFrameRate(199.99998f);
        ripple.fadeInSize(0.3f * endSize / (endSize - startSize));
        ripple.fadeOutIntensity(0.5f);
        ripple.setSize(startSize);
        DistortionShader.addDistortion((DistortionAPI)ripple);
        StolenUtils.createSmoothFlare(engine, this.ship, muzzle, 50.0f, 900.0f, 0.0f, new Color(250, 150, 255, 128), Color.white);
    }

    private void renderRingCharge(float charge) {
        this.bar.getAnimation().setAlphaMult(0.5f + charge * 0.5f);
        if (charge <= 0.0f) {
            this.bar.getAnimation().setFrame(48);
        } else if (charge >= 1.0f) {
            this.bar.getAnimation().setFrame(0);
        } else {
            this.bar.getAnimation().setFrame(Math.max(0, 48 - (int)(charge * 48.0f)));
        }
    }

    private void setModuleFiringStatus(ShipAPI module, boolean enabled) {
        if (module == null || !module.isAlive()) {
            return;
        }
        try {
            WurgandalModuleShipAI ai = (WurgandalModuleShipAI)((Ship.ShipAIWrapper)module.getShipAI()).getAI();
            ai.setGunsEnabled(enabled);
            ai.setShieldsEnabled(enabled);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void unmodify() {
        this.stats.getMaxSpeed().unmodify("Tyrant Maw Siege Mode");
        this.stats.getMaxTurnRate().unmodify("Tyrant Maw Siege Mode");
        this.stats.getTurnAcceleration().unmodify("Tyrant Maw Siege Mode");
        for (ShipAPI module : this._modules) {
            this.setModuleFiringStatus(module, true);
        }
    }

    public void interrupt(WeaponAPI weapon) {
        if (!weapon.isDisabled()) {
            this.ship.setCurrentCR(this.ship.getCurrentCR() * 0.75f);
            Global.getSoundPlayer().playSound("mawend", 1.0f, 1.0f, this.ship.getLocation(), this.ship.getVelocity());
            this.unmodify();
            weapon.disable();
            this.fire = true;
        }
    }

    public void spark(float bonusChance, float charge, WeaponAPI weapon) {
        if (!MagicRender.screenCheck((float)0.25f, (Vector2f)weapon.getLocation())) {
            return;
        }
        if (this.rnd.nextFloat() - bonusChance <= charge) {
            Vector2f loc = new Vector2f((ReadableVector2f)MathUtils.getPoint((Vector2f)weapon.getLocation(), (float)(this.rnd.nextFloat() * 240.0f + 40.0f), (float)weapon.getCurrAngle()));
            MagicRender.battlespace((SpriteAPI)Global.getSettings().getSprite("fx", "edzap_" + this.rnd.nextInt(9)), (Vector2f)loc, (Vector2f)this.ship.getVelocity(), (Vector2f)new Vector2f(24.0f, 24.0f), (Vector2f)new Vector2f(24.0f, 24.0f), (float)(this.ship.getFacing() - 90.0f + (float)this.rnd.nextInt(2) * 180.0f), (float)((float)(Math.random() - 0.5) * 10.0f), (Color)new Color(255, 200, 255), (boolean)true, (float)0.0f, (float)0.1f, (float)0.1f);
            Global.getSoundPlayer().playSound("ed_shock", 1.0f + charge, 1.0f, this.ship.getLocation(), this.ship.getVelocity());
        }
    }

    private void handleZapEmitters(float amount) {
        for (int i = 0; i < this.ZapEmitters.size(); ++i) {
            ZapEmitter ze = this.ZapEmitters.get(i);
            if (ze.advance(amount)) continue;
            this.ZapEmitters.remove(i);
            --i;
        }
    }

    private static class BurstArcEffect {
        private final IntervalTracker _burstArcCheck = new IntervalTracker(0.3f, 0.4f);
        private final List<CombatEntityAPI> _lastArcHits = new ArrayList<CombatEntityAPI>();
        private final HashSet<CombatEntityAPI> _allPriorArcHits = new HashSet();
        private final CombatEngineAPI _engine;
        private final BeamAPI _beam;
        private final float _burstDamage;
        private float _nextChainDistance;
        private final Vector2f _origin;
        private final MAW_EveryFrameEffect _everyFrameEffect;

        public BurstArcEffect(CombatEntityAPI target, Vector2f source, float burstDamage, CombatEngineAPI engine, BeamAPI beam, float chainDistance, MAW_EveryFrameEffect mawEveryFrame) {
            this._engine = engine;
            this._beam = beam;
            this._burstDamage = burstDamage;
            this._nextChainDistance = chainDistance;
            this._origin = source;
            this._everyFrameEffect = mawEveryFrame;
            if (target != null) {
                this._lastArcHits.add(target);
                this._allPriorArcHits.add(target);
                this.spawnEmpArcPierceShields(source, target, this._burstDamage);
            } else {
                this._lastArcHits.add((CombatEntityAPI)new SimpleEntity(source));
            }
        }

        private void spawnEmpArcPierceShields(Vector2f sourceLocation, CombatEntityAPI target, float burstDamage) {
            float damage = this.damageMultiplier(target) * burstDamage;
            float distance = MathUtils.getDistance((Vector2f)target.getLocation(), (Vector2f)this._origin);
            if (distance > 725.0f) {
                float scalar = 1.0f - (distance -= 725.0f) / 675.0f;
                damage *= scalar;
            }
            if (damage < 1.0f) {
                return;
            }
            this._engine.spawnEmpArcPierceShields(this._beam.getSource(), sourceLocation, target, target, DamageType.ENERGY, damage, damage * 2.0f, 100000.0f, "tachyon_lance_emp_impact", this._beam.getWidth() * 0.8f, this._beam.getFringeColor(), this._beam.getCoreColor());
            DamageReportManagerV1.addDamageClarification(damage, damage * 2.0f, DamageType.ENERGY, (CombatEntityAPI)this._beam.getSource(), target, this._beam.getWeapon().getDisplayName());
            this._everyFrameEffect.ZapEmitters.add(new ZapEmitter(target, this._engine, this._beam));
        }

        private boolean advance(float amount) {
            this._burstArcCheck.advance(amount);
            if (this._burstArcCheck.intervalElapsed() && this._lastArcHits.size() > 0) {
                Map<CombatEntityAPI, List<CombatEntityAPI>> thisFrameVictims = this.getBurstArcVictims(this._lastArcHits, this._allPriorArcHits, this._nextChainDistance);
                this._lastArcHits.clear();
                Random rand = new Random();
                for (Map.Entry<CombatEntityAPI, List<CombatEntityAPI>> victim : thisFrameVictims.entrySet()) {
                    CombatEntityAPI target = victim.getKey();
                    this._lastArcHits.add(target);
                    this._allPriorArcHits.add(target);
                    CombatEntityAPI source = victim.getValue().get(rand.nextInt(victim.getValue().size()));
                    if (target instanceof ShipAPI) {
                        ShipAPI targetShip = (ShipAPI)target;
                        if (targetShip.isPhased()) continue;
                        targetShip.getFluxTracker().beginOverloadWithTotalBaseDuration(1.0f);
                    }
                    this.spawnEmpArcPierceShields(source.getLocation(), target, this._burstDamage);
                }
                this._nextChainDistance *= 0.7f;
            }
            return this._lastArcHits.size() > 0;
        }

        private Map<CombatEntityAPI, List<CombatEntityAPI>> getBurstArcVictims(List<CombatEntityAPI> lastArcHits, HashSet<CombatEntityAPI> allPriorArcHits, float maxJumpDistance) {
            HashMap<CombatEntityAPI, List<CombatEntityAPI>> ret = new HashMap<CombatEntityAPI, List<CombatEntityAPI>>();
            Random r = new Random();
            for (CombatEntityAPI lastHit : lastArcHits) {
                for (CombatEntityAPI entity : CombatUtils.getEntitiesWithinRange((Vector2f)lastHit.getLocation(), (float)maxJumpDistance)) {
                    List<CombatEntityAPI> sources;
                    if (allPriorArcHits.contains(entity) || r.nextFloat() >= this.getArcChance(entity) || MathUtils.getDistance((CombatEntityAPI)entity, (Vector2f)this._origin) > 1400.0f) continue;
                    if (ret.containsKey(entity)) {
                        sources = (List)ret.get(entity);
                    } else {
                        sources = new ArrayList();
                        ret.put(entity, sources);
                    }
                    sources.add(lastHit);
                }
            }
            return ret;
        }

        private float getArcChance(CombatEntityAPI entity) {
            if (entity instanceof MissileAPI) {
                return 0.05f;
            }
            if (entity instanceof ProjectileSpecAPI || entity instanceof DamagingExplosion) {
                return 0.0f;
            }
            if (entity.getOwner() == 100) {
                return 0.3f;
            }
            if (entity.getOwner() == this._beam.getWeapon().getShip().getOwner()) {
                return 0.13f;
            }
            return 1.0f;
        }

        private float damageMultiplier(CombatEntityAPI entity) {
            if (entity instanceof ShipAPI) {
                ShipAPI ship = (ShipAPI)entity;
                return this.getDamageBasedOnSize(ship.getHullSize()) + ship.getFluxLevel();
            }
            if (entity instanceof MissileAPI) {
                return 0.1f;
            }
            if (entity instanceof ProjectileSpecAPI || entity instanceof DamagingExplosion) {
                return 0.0f;
            }
            return 0.0f;
        }

        private float getDamageBasedOnSize(ShipAPI.HullSize hullSize) {
            switch (hullSize) {
                case FIGHTER: {
                    return 0.1f;
                }
                case FRIGATE: {
                    return 0.55f;
                }
                case DESTROYER: {
                    return 0.9f;
                }
                case CRUISER: {
                    return 1.3f;
                }
                case CAPITAL_SHIP: {
                    return 1.6f;
                }
            }
            return 0.5f;
        }
    }

    private static class ZapEmitter {
        private float lifetimeRemaining;
        private final IntervalUtil nextZap = new IntervalUtil(0.25f, 1.25f);
        private final CombatEntityAPI _emitter;
        private final CombatEngineAPI _engine;
        private final BeamAPI _beam;

        public ZapEmitter(CombatEntityAPI emitter, CombatEngineAPI engine, BeamAPI beam) {
            this._emitter = emitter;
            this._engine = engine;
            this._beam = beam;
            this.lifetimeRemaining = (float)(Math.random() * 2.0 + 2.5);
        }

        private boolean advance(float amount) {
            this.lifetimeRemaining -= amount;
            if (this.lifetimeRemaining < 0.0f) {
                return false;
            }
            this.nextZap.advance(amount);
            if (!this.nextZap.intervalElapsed()) {
                return true;
            }
            if (!this._engine.isEntityInPlay(this._emitter)) {
                return false;
            }
            float min = this._emitter.getCollisionRadius() * 0.3333f;
            Vector2f zapTarget = MathUtils.getPointOnCircumference((Vector2f)this._emitter.getLocation(), (float)((float)(Math.random() * (double)min + (double)min)), (float)((float)Math.random() * 360.0f));
            this._engine.spawnEmpArcPierceShields(this._beam.getSource(), this._emitter.getLocation(), (CombatEntityAPI)new SimpleEntity(zapTarget), (CombatEntityAPI)new SimpleEntity(zapTarget), DamageType.ENERGY, 0.0f, 0.0f, 100000.0f, "tachyon_lance_emp_impact", this._beam.getWidth() * 0.4f, this._beam.getFringeColor(), this._beam.getCoreColor());
            return true;
        }
    }
}

