/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.edshipyard.weapons;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.DamageType;
import com.fs.starfarer.api.combat.DamagingProjectileAPI;
import com.fs.starfarer.api.combat.OnHitEffectPlugin;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.listeners.ApplyDamageResultAPI;
import data.scripts.edshipyard.util.StolenUtils;
import java.awt.Color;
import java.util.List;
import org.lazywizard.lazylib.MathUtils;
import org.lazywizard.lazylib.VectorUtils;
import org.lazywizard.lazylib.combat.CombatUtils;
import org.lwjgl.util.vector.Vector2f;

public class Magnablast
implements OnHitEffectPlugin {
    private final Color EMP_CORE_COLOR_STANDARD = new Color(255, 175, 255, 255);
    private final Color EMP_FRINGE_COLOR_STANDARD = new Color(255, 175, 255, 200);

    public void onHit(DamagingProjectileAPI projectile, CombatEntityAPI target, Vector2f point, boolean shieldHit, ApplyDamageResultAPI damageResult, CombatEngineAPI engine) {
        if (projectile == null || target == null || engine == null || point == null) {
            return;
        }
        if (shieldHit) {
            Global.getSoundPlayer().playSound("ed_mag4", 1.0f, 1.0f, target.getLocation(), target.getVelocity());
            float angle = VectorUtils.getAngle((Vector2f)target.getLocation(), (Vector2f)projectile.getLocation());
            block0: for (int i = 0; i < 60; ++i) {
                Vector2f spawn = MathUtils.getPoint((Vector2f)projectile.getLocation(), (float)1000.0f, (float)(angle - 75.0f + (float)(Math.random() * 150.0)));
                List<ShipAPI> ships = StolenUtils.getShipsOnSegment(projectile.getLocation(), spawn);
                for (ShipAPI s : ships) {
                    if (s == target || s.getOwner() != target.getOwner() || s.isStationModule()) continue;
                    this.applyEffectToTarget(point, (CombatEntityAPI)s, projectile, 400.0f);
                    i += 2;
                    continue block0;
                }
            }
            List asteroids = CombatUtils.getAsteroidsWithinRange((Vector2f)projectile.getLocation(), (float)1400.0f);
            List missiles = CombatUtils.getMissilesWithinRange((Vector2f)projectile.getLocation(), (float)600.0f);
            for (CombatEntityAPI entity : asteroids) {
                this.applyEffectToTarget(projectile.getLocation(), entity, projectile, 800.0f);
            }
            for (CombatEntityAPI entity : missiles) {
                this.applyEffectToTarget(projectile.getLocation(), entity, projectile, 100.0f);
            }
        }
    }

    protected void applyEffectToTarget(Vector2f point, CombatEntityAPI target, DamagingProjectileAPI proj, float force) {
        Global.getCombatEngine().spawnEmpArc(proj.getWeapon().getShip(), point, (CombatEntityAPI)proj, target, DamageType.ENERGY, 0.0f, 100.0f, 1500.0f, null, 5.0f, this.EMP_FRINGE_COLOR_STANDARD, this.EMP_CORE_COLOR_STANDARD);
        CombatUtils.applyForce((CombatEntityAPI)target, (Vector2f)VectorUtils.getDirectionalVector((Vector2f)target.getLocation(), (Vector2f)point), (float)force);
    }
}

