/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.edshipyard.weapons.ai;

import com.fs.starfarer.api.combat.AutofireAIPlugin;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.MissileAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipwideAIFlags;
import com.fs.starfarer.api.combat.WeaponAPI;
import com.fs.starfarer.api.util.IntervalUtil;
import data.scripts.edshipyard.util.StolenUtils;
import java.util.ArrayList;
import java.util.List;
import org.lazywizard.lazylib.MathUtils;
import org.lazywizard.lazylib.combat.AIUtils;
import org.lazywizard.lazylib.combat.CombatUtils;
import org.lwjgl.util.vector.Vector2f;

public class MawAutofireAI
implements AutofireAIPlugin {
    private final IntervalUtil tracker = new IntervalUtil(0.25f, 0.35f);
    final WeaponAPI maw;
    private boolean shouldFire = false;
    private ShipAPI target = null;

    public MawAutofireAI(WeaponAPI weapon) {
        this.maw = weapon;
    }

    public void advance(float amount) {
        if (amount == 0.0f) {
            return;
        }
        this.tracker.advance(amount);
        if (!this.tracker.intervalElapsed()) {
            return;
        }
        ShipAPI ship = this.maw.getShip();
        if (ship == null) {
            return;
        }
        ShipwideAIFlags flags = ship.getAIFlags();
        if (this.maw.isDisabled()) {
            flags.removeFlag(ShipwideAIFlags.AIFlags.DO_NOT_VENT);
            this.shouldFire = false;
            this.target = null;
            return;
        }
        if (this.maw.isFiring()) {
            if (!flags.hasFlag(ShipwideAIFlags.AIFlags.DO_NOT_VENT)) {
                flags.setFlag(ShipwideAIFlags.AIFlags.DO_NOT_VENT, 0.5f);
            }
            this.shouldFire = false;
            if (this.target != null && !this.target.isAlive()) {
                this.target = null;
            }
            return;
        }
        this.target = null;
        flags.removeFlag(ShipwideAIFlags.AIFlags.DO_NOT_VENT);
        if (this.maw.getAmmo() == 0 || ship.getFluxLevel() > 0.3f) {
            return;
        }
        List<ShipAPI> enemiesInArc = this.removeLowValueShips(MawAutofireAI.getShipsInArc(this.maw, AIUtils.getEnemiesOnMap((CombatEntityAPI)ship)));
        if (enemiesInArc.size() == 0) {
            return;
        }
        ShipAPI nearestEnemy = this.getNearestShip(enemiesInArc);
        this.target = this.isAGoodMawTarget(nearestEnemy) ? nearestEnemy : null;
        this.shouldFire = this.target != null && !ship.getFluxTracker().isVenting() && Math.abs(ship.getAngularVelocity()) < 1.0f && !this.isAFriendlyFireRisk(this.target) && this.isSafeToFire() && MathUtils.getDistance((Vector2f)this.maw.getLocation(), (Vector2f)this.target.getLocation()) >= 1700.0f;
    }

    private List<ShipAPI> removeLowValueShips(List<ShipAPI> ships) {
        if (ships == null) {
            return new ArrayList<ShipAPI>();
        }
        ArrayList<ShipAPI> ret = new ArrayList<ShipAPI>(ships.size());
        for (ShipAPI ship : ships) {
            if (ship.getHullSize() == ShipAPI.HullSize.FRIGATE || ship.getHullSize() == ShipAPI.HullSize.FIGHTER || ship.isDrone() || !ship.isAlive()) continue;
            ret.add(ship);
        }
        return ret;
    }

    private ShipAPI getNearestShip(List<ShipAPI> ships) {
        if (ships.size() == 1) {
            return ships.get(0);
        }
        ShipAPI ret = ships.get(0);
        float retDistance = Math.abs(MathUtils.getDistance((Vector2f)this.maw.getLocation(), (Vector2f)ret.getLocation()));
        for (int i = 1; i < ships.size(); ++i) {
            float newDistance = Math.abs(MathUtils.getDistance((Vector2f)this.maw.getLocation(), (Vector2f)ships.get(i).getLocation()));
            if (!(newDistance < retDistance)) continue;
            ret = ships.get(i);
        }
        return ret;
    }

    private boolean isAFriendlyFireRisk(ShipAPI target) {
        for (ShipAPI nearby : CombatUtils.getShipsWithinRange((Vector2f)target.getLocation(), (float)900.0f)) {
            if (nearby.getOwner() == 100 || nearby.isHulk() || nearby.getOwner() != this.maw.getShip().getOwner() || nearby.getHullSize().ordinal() <= ShipAPI.HullSize.FIGHTER.ordinal()) continue;
            return true;
        }
        List<ShipAPI> allies = this.removeLowValueShips(MawAutofireAI.getShipsInArc(this.maw, AIUtils.getAlliesOnMap((CombatEntityAPI)this.maw.getShip())));
        if (allies.size() == 0) {
            return false;
        }
        ShipAPI nearestAlly = this.getNearestShip(allies);
        float targetDistance = MathUtils.getDistance((Vector2f)this.maw.getLocation(), (Vector2f)target.getLocation());
        float allyDistance = MathUtils.getDistance((Vector2f)this.maw.getLocation(), (Vector2f)nearestAlly.getLocation());
        return allyDistance < targetDistance;
    }

    private boolean isSafeToFire() {
        float totalIncomingDamage = 0.0f;
        for (ShipAPI module : this.maw.getShip().getChildModulesCopy()) {
            totalIncomingDamage += StolenUtils.estimateAllIncomingDamage(module);
        }
        return totalIncomingDamage < 100.0f;
    }

    private static List<ShipAPI> getShipsInArc(WeaponAPI weapon, List<ShipAPI> ships) {
        ArrayList<ShipAPI> enemies = new ArrayList<ShipAPI>();
        float range = weapon.getRange() * 0.85f;
        for (ShipAPI ship : ships) {
            if (!MathUtils.isWithinRange((CombatEntityAPI)ship, (Vector2f)weapon.getLocation(), (float)range) || !(weapon.distanceFromArc(ship.getLocation()) <= 1.0f)) continue;
            enemies.add(ship);
        }
        return enemies;
    }

    private boolean isAGoodMawTarget(ShipAPI target) {
        if (!target.isAlive()) {
            return false;
        }
        if (target.getPhaseCloak() != null && target.getChildModulesCopy().isEmpty()) {
            return false;
        }
        return target.getHullSize() == ShipAPI.HullSize.CAPITAL_SHIP || target.getHullSize() == ShipAPI.HullSize.CRUISER || target.isStation();
    }

    public boolean shouldFire() {
        return this.shouldFire;
    }

    public void forceOff() {
    }

    public Vector2f getTarget() {
        if (this.target == null) {
            return null;
        }
        return this.target.getLocation();
    }

    public ShipAPI getTargetShip() {
        return this.target;
    }

    public WeaponAPI getWeapon() {
        return this.maw;
    }

    public MissileAPI getTargetMissile() {
        return null;
    }
}

