/*
 * Decompiled with CFR 0.152.
 */
package data.hullmods.edshipyard;

import com.fs.starfarer.api.combat.BaseHullMod;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ModuleRange
extends BaseHullMod {
    private static final Set<String> BLOCKED_HULLMODS = new HashSet<String>(1);
    private static final Map<ShipAPI.HullSize, Float> HullSizeToRangMult = new HashMap<ShipAPI.HullSize, Float>();
    String id;

    public String getDescriptionParam(int index, ShipAPI.HullSize hullSize, ShipAPI ship) {
        float rangeMult = this.getRangeMulti(ship);
        switch (index) {
            case 0: {
                return "" + Math.round(rangeMult * 100.0f) + "%";
            }
        }
        return null;
    }

    public void applyEffectsAfterShipCreation(ShipAPI ship, String id) {
        super.applyEffectsAfterShipCreation(ship, id);
        for (String tmp : BLOCKED_HULLMODS) {
            if (!ship.getVariant().getHullMods().contains(tmp)) continue;
            ship.getVariant().removeMod(tmp);
        }
    }

    public void advanceInCombat(ShipAPI ship, float amount) {
        super.advanceInCombat(ship, amount);
        ship.getMutableStats().getBallisticWeaponRangeBonus().modifyMult(this.id, 1.0f + this.getRangeMulti(ship));
    }

    public void applyEffectsBeforeShipCreation(ShipAPI.HullSize hullSize, MutableShipStatsAPI stats, String id) {
        if (stats == null) {
            return;
        }
        stats.getBallisticWeaponRangeBonus().modifyMult(id, 1.0f + this.getRangeMulti(hullSize));
        this.id = id;
    }

    public String getUnapplicableReason(ShipAPI ship) {
        if (ship.getVariant().hasHullMod("civgrade") && !ship.getVariant().hasHullMod("militarized_subsystems")) {
            return "Can not be installed on civilian ships";
        }
        return null;
    }

    public boolean isApplicableToShip(ShipAPI ship) {
        return false;
    }

    private float getRangeMulti(ShipAPI s) {
        if (s.getParentStation() != null) {
            return this.getRangeMulti(s.getParentStation().getHullSize());
        }
        return this.getRangeMulti(s.getHullSize());
    }

    private float getRangeMulti(ShipAPI.HullSize hullSize) {
        return HullSizeToRangMult.get(hullSize).floatValue();
    }

    static {
        BLOCKED_HULLMODS.add("targetingunit");
        BLOCKED_HULLMODS.add("advancedoptics");
        BLOCKED_HULLMODS.add("diableavionics_mount");
        BLOCKED_HULLMODS.add("dedicated_targeting_core");
        HullSizeToRangMult.put(ShipAPI.HullSize.CAPITAL_SHIP, Float.valueOf(0.7f));
        HullSizeToRangMult.put(ShipAPI.HullSize.CRUISER, Float.valueOf(0.5f));
        HullSizeToRangMult.put(ShipAPI.HullSize.DESTROYER, Float.valueOf(0.3f));
        HullSizeToRangMult.put(ShipAPI.HullSize.FRIGATE, Float.valueOf(0.2f));
    }
}

