/*
 * Decompiled with CFR 0.152.
 */
package data.hullmods.edshipyard;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.BaseHullMod;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipCommand;
import com.fs.starfarer.api.combat.ShipwideAIFlags;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.IntervalUtil;

public class WurgandalModule
extends BaseHullMod {
    private static final float IntervalCheckTime = 0.15f;
    private static final float FluxTransfer = 100.0f;
    private final IntervalUtil _checkInterval = new IntervalUtil(0.15f, 0.15f);

    public void advanceInCombat(ShipAPI child, float amount) {
        if (Global.getCombatEngine() == null) {
            return;
        }
        if (Global.getCombatEngine().isPaused()) {
            return;
        }
        if (child == null || !child.isAlive()) {
            return;
        }
        ShipAPI parent = child.getParentStation();
        if (parent == null || !parent.isAlive()) {
            return;
        }
        this._checkInterval.advance(amount);
        if (!this._checkInterval.intervalElapsed()) {
            return;
        }
        if (child.getFluxTracker().getCurrFlux() > 100.0f && parent.getFluxTracker().getCurrFlux() < 5000.0f) {
            child.getFluxTracker().decreaseFlux(100.0f);
            parent.getFluxTracker().increaseFlux(100.0f, false);
        }
        if (parent.getFluxTracker().isVenting() && !child.getFluxTracker().isVenting() && child.getFluxTracker().getCurrFlux() > 1000.0f && child.isAlive()) {
            child.giveCommand(ShipCommand.VENT_FLUX, null, 0);
            return;
        }
        if (parent.getFluxTracker().isOverloaded()) {
            if (!child.getFluxTracker().isOverloaded()) {
                child.getFluxTracker().beginOverloadWithTotalBaseDuration(parent.getFluxTracker().getOverloadTimeRemaining());
            } else if (child.getFluxTracker().getOverloadTimeRemaining() < parent.getFluxTracker().getOverloadTimeRemaining()) {
                child.getFluxTracker().beginOverloadWithTotalBaseDuration(parent.getFluxTracker().getOverloadTimeRemaining() - child.getFluxTracker().getOverloadTimeRemaining());
            }
        }
        if (parent.getShipTarget() != null && parent.getShipTarget() != child.getShipTarget()) {
            child.setShipTarget(parent.getShipTarget());
        }
        if (child.hasLaunchBays()) {
            if (child.isPullBackFighters() != parent.isPullBackFighters()) {
                child.setPullBackFighters(parent.isPullBackFighters());
            }
            if (child.getAIFlags() != null) {
                if ((Global.getCombatEngine().getPlayerShip() == parent || parent.getAIFlags() == null) && parent.getShipTarget() != null) {
                    child.getAIFlags().setFlag(ShipwideAIFlags.AIFlags.CARRIER_FIGHTER_TARGET, 1.0f, (Object)parent.getShipTarget());
                } else if (parent.getAIFlags() != null && parent.getAIFlags().hasFlag(ShipwideAIFlags.AIFlags.CARRIER_FIGHTER_TARGET) && parent.getAIFlags().getCustom(ShipwideAIFlags.AIFlags.CARRIER_FIGHTER_TARGET) != null) {
                    child.getAIFlags().setFlag(ShipwideAIFlags.AIFlags.CARRIER_FIGHTER_TARGET, 1.0f, parent.getAIFlags().getCustom(ShipwideAIFlags.AIFlags.CARRIER_FIGHTER_TARGET));
                }
            }
        }
        if (child.getShield() != null && parent.getShield() != null && child.getShield().isOn() != parent.getShield().isOn()) {
            if (parent.getShield().isOn()) {
                child.getShield().toggleOn();
            } else {
                child.getShield().toggleOff();
            }
        }
    }

    public void applyEffectsAfterShipCreation(ShipAPI ship, String id) {
    }

    public void addPostDescriptionSection(TooltipMakerAPI tooltip, ShipAPI.HullSize hullSize, ShipAPI ship, float width, boolean isForModSpec) {
    }
}

