/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.edshipyard;

import com.fs.starfarer.api.EveryFrameScript;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.FleetDataAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.util.IntervalUtil;

public class FleetRepairOptimizationsBonusScript
implements EveryFrameScript {
    private static final String SOURCE_KEY = "FleetRepairOptimizations";
    private final IntervalUtil interval = new IntervalUtil(10.0f, 10.0f);
    public static boolean needsUpdate = false;

    public boolean isDone() {
        return false;
    }

    public boolean runWhilePaused() {
        return false;
    }

    public void advance(float amount) {
        this.interval.advance(amount);
        if (this.interval.intervalElapsed() || needsUpdate) {
            needsUpdate = false;
            FleetRepairOptimizationsBonusScript.update();
        }
    }

    public static void update() {
        try {
            if (Global.getSector().getPlayerFleet() == null || Global.getSector().getPlayerFleet().getFleetData() == null) {
                return;
            }
            FleetDataAPI fd = Global.getSector().getPlayerFleet().getFleetData();
            if (FleetRepairOptimizationsBonusScript.hasFleetRepairOptimization()) {
                for (FleetMemberAPI fleetMember : fd.getMembersListCopy()) {
                    fleetMember.getStats().getRepairRatePercentPerDay().modifyPercent(SOURCE_KEY, 25.0f);
                    fleetMember.getStats().getBaseCRRecoveryRatePercentPerDay().modifyPercent(SOURCE_KEY, 25.0f);
                }
            } else {
                for (FleetMemberAPI fleetMember : fd.getMembersListCopy()) {
                    fleetMember.getStats().getRepairRatePercentPerDay().unmodify(SOURCE_KEY);
                    fleetMember.getStats().getBaseCRRecoveryRatePercentPerDay().unmodify(SOURCE_KEY);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static boolean hasFleetRepairOptimization() {
        for (FleetMemberAPI member : Global.getSector().getPlayerFleet().getFleetData().getMembersListCopy()) {
            for (String mod : member.getHullSpec().getBuiltInMods()) {
                if (!mod.equals("edshipyard_fleet_repair_optimizations")) continue;
                return true;
            }
        }
        return false;
    }
}

