/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.edshipyard.ai;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.ArmorGridAPI;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.DamageType;
import com.fs.starfarer.api.combat.ShipAIConfig;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipwideAIFlags;
import com.fs.starfarer.api.util.IntervalUtil;
import data.dcr.edshipyard.DamageReportManagerV1;
import data.scripts.edshipyard.ai.BaseShipAI;
import data.scripts.edshipyard.util.StolenUtils;
import java.awt.Color;
import java.util.Random;
import org.lazywizard.lazylib.CollisionUtils;
import org.lazywizard.lazylib.MathUtils;
import org.lazywizard.lazylib.VectorUtils;
import org.lwjgl.util.Point;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;
import org.magiclib.util.MagicLensFlare;

public class Maltese_AI
extends BaseShipAI {
    private static final float REPAIR_RANGE = 35.0f;
    private static final float REPAIR_HULL = 5.5f;
    private static final float REPAIR_ARMOR = 0.16f;
    private static final float FLUX_PER_MX_PERFORMED = 1.0f;
    private final Color SPARK_COLOR = new Color(255, 225, 150, 100);
    private static final String SPARK_SOUND_ID = "ed_shock";
    private static final float SPARK_CHANCE = 0.67f;
    private static final float SPARK_SPEED_MULTIPLIER = 500.0f;
    private static final float SPARK_VOLUME = 1.0f;
    private static final float SPARK_PITCH = 1.0f;
    private final ShipwideAIFlags flags = new ShipwideAIFlags();
    private final ShipAIConfig config = new ShipAIConfig();
    private ShipAPI carrier;
    ShipAPI target;
    Vector2f targetOffset;
    Random rng = new Random();
    ArmorGridAPI armorGrid;
    float maxArmorInCell;
    float cellSize;
    int gridWidth;
    int gridHeight;
    int cellCount;
    boolean shouldRepair = false;
    boolean returning = false;
    boolean spark = false;
    float targetFacingOffset = Float.MIN_VALUE;
    float range = 4000.0f;
    private final IntervalUtil interval = new IntervalUtil(0.25f, 0.33f);
    private final IntervalUtil countdown = new IntervalUtil(4.0f, 4.0f);

    public Maltese_AI(ShipAPI ship) {
        super(ship);
    }

    @Override
    public void advance(float amount) {
        if (this.carrier == null) {
            this.init();
        }
        if (this.ship.isLanding()) {
            this.countdown.advance(amount);
            if (this.countdown.intervalElapsed()) {
                this.ship.getWing().getSource().land(this.ship);
                return;
            }
        }
        this.interval.advance(amount);
        if (this.interval.intervalElapsed()) {
            super.advance(amount);
            if (this.target == null) {
                return;
            }
            if (this.shouldRepair) {
                this.repairArmorAndHull();
            } else if (this.returning && !this.ship.isLanding() && MathUtils.getDistance((CombatEntityAPI)this.ship, (CombatEntityAPI)this.carrier) < this.carrier.getCollisionRadius() / 3.0f) {
                this.ship.beginLandingAnimation(this.carrier);
            }
        }
        this.goToDestination();
    }

    @Override
    public boolean needsRefit() {
        return this.ship.getFluxTracker().getFluxLevel() >= 1.0f;
    }

    public void cancelCurrentManeuver() {
    }

    @Override
    public void evaluateCircumstances() {
        if (this.carrier == null || !this.carrier.isAlive()) {
            StolenUtils.destroy((CombatEntityAPI)this.ship);
            return;
        }
        this.setTarget(this.chooseTarget());
        if (this.returning) {
            this.targetOffset = StolenUtils.toRelative((CombatEntityAPI)this.target, this.ship.getWing().getSource().getLandingLocation(this.ship));
        } else {
            do {
                this.targetOffset = MathUtils.getRandomPointInCircle((Vector2f)this.target.getLocation(), (float)this.target.getCollisionRadius());
            } while (!CollisionUtils.isPointWithinBounds((Vector2f)this.targetOffset, (CombatEntityAPI)this.target));
            this.targetOffset = StolenUtils.toRelative((CombatEntityAPI)this.target, this.targetOffset);
            this.armorGrid = this.target.getArmorGrid();
            this.maxArmorInCell = this.armorGrid.getMaxArmorInCell();
            this.cellSize = this.armorGrid.getCellSize();
            this.gridWidth = this.armorGrid.getGrid().length;
            this.gridHeight = this.armorGrid.getGrid()[0].length;
            this.cellCount = this.gridWidth * this.gridHeight;
        }
        this.shouldRepair = (this.target.getPhaseCloak() == null || !this.target.getPhaseCloak().isOn()) && !this.returning && (StolenUtils.getArmorPercent(this.target) < 1.0f || this.target.getHullLevel() < 0.98f) && MathUtils.getDistance((CombatEntityAPI)this.ship, (CombatEntityAPI)this.target) < 35.0f;
    }

    Point computeArmorCellToRepair() {
        if (this.gridWidth <= 0 || this.gridHeight <= 0) {
            return null;
        }
        for (int i = 0; i < 1 + this.cellCount / 5; ++i) {
            int y;
            int x = this.rng.nextInt(this.gridWidth);
            if (!(this.armorGrid.getArmorValue(x, y = this.rng.nextInt(this.gridHeight)) < this.maxArmorInCell)) continue;
            return new Point(x, y);
        }
        return null;
    }

    void repairArmorAndHull() {
        float totalHullRepaired = 0.0f;
        this.spark = true;
        this.ship.getFluxTracker().setCurrFlux(this.ship.getFluxTracker().getCurrFlux() + 1.0f);
        float bonus = 1.0f;
        if (this.target.getHullSize() == ShipAPI.HullSize.CAPITAL_SHIP) {
            bonus = 4.0f;
        } else if (this.target.getHullSize() == ShipAPI.HullSize.CRUISER) {
            bonus = 3.0f;
        } else if (this.target.getHullSize() == ShipAPI.HullSize.DESTROYER) {
            bonus = 2.0f;
        }
        if (this.target.getHullLevel() < 0.99f) {
            totalHullRepaired = 5.5f * bonus;
            this.target.setHitpoints(this.target.getHitpoints() + totalHullRepaired);
            float overage = this.target.getHitpoints() - this.target.getMaxHitpoints();
            if (overage > 0.0f) {
                totalHullRepaired -= overage;
                this.target.setHitpoints(this.target.getMaxHitpoints());
            }
        }
        float totalArmorRepaired = 0.0f;
        Point cellToFix = this.computeArmorCellToRepair();
        if (cellToFix != null) {
            for (int x = cellToFix.getX() - 1; x <= cellToFix.getX() + 1; ++x) {
                if (x < 0 || x >= this.gridWidth) continue;
                for (int y = cellToFix.getY() - 1; y <= cellToFix.getY() + 1; ++y) {
                    if (y < 0 || y >= this.gridHeight || !(this.armorGrid.getArmorValue(x, y) < this.maxArmorInCell)) continue;
                    float cellValue = this.armorGrid.getArmorValue(x, y);
                    float armorRepairAmount = 0.16f * bonus;
                    this.armorGrid.setArmorValue(x, y, cellValue + armorRepairAmount);
                    float overage = this.armorGrid.getArmorValue(x, y) - this.maxArmorInCell;
                    if (overage > 0.0f) {
                        armorRepairAmount -= overage;
                        this.armorGrid.setArmorValue(x, y, this.maxArmorInCell);
                    }
                    totalArmorRepaired += armorRepairAmount;
                }
            }
        }
        if (totalArmorRepaired + totalHullRepaired > 1.0f) {
            Global.getCombatEngine().addFloatingDamageText(this.target.getLocation(), totalArmorRepaired + totalHullRepaired, Color.GREEN, (CombatEntityAPI)this.target, (CombatEntityAPI)this.ship.getWing().getSourceShip());
            DamageReportManagerV1.addDamageReport(-totalArmorRepaired, -totalHullRepaired, 0.0f, 0.0f, DamageType.OTHER, (CombatEntityAPI)this.ship.getWing().getSourceShip(), (CombatEntityAPI)this.target, "Maltese Repair Drone");
        }
    }

    ShipAPI chooseTarget() {
        if (this.needsRefit()) {
            this.returning = true;
            return this.carrier;
        }
        this.returning = false;
        if (this.carrier.getShipTarget() != null && this.carrier.getOwner() == this.carrier.getShipTarget().getOwner() && !this.carrier.getShipTarget().isDrone() && !this.carrier.getShipTarget().isFighter()) {
            return this.carrier.getShipTarget();
        }
        ShipAPI mostWounded = this.carrier;
        float mostDamage = 4.0f;
        for (ShipAPI s : Global.getCombatEngine().getShips()) {
            float d = MathUtils.getDistance((CombatEntityAPI)this.carrier, (CombatEntityAPI)s);
            if (s.isFighter() || s.isDrone() || s.isHulk() || d > this.range) continue;
            float currDamage = StolenUtils.getArmorPercent(s) + s.getHullLevel();
            float priority = d / 1000.0f;
            if (s.isStationModule()) {
                priority += 1.0f;
            }
            if (s.getOwner() != this.carrier.getOwner() || !(currDamage < 1.98f) || !(mostDamage > currDamage + priority / 2.0f)) continue;
            mostDamage = currDamage + priority / 2.0f;
            mostWounded = s;
        }
        return mostWounded;
    }

    void setTarget(ShipAPI t) {
        if (this.target == t) {
            return;
        }
        this.target = t;
        this.ship.setShipTarget(t);
    }

    void goToDestination() {
        Vector2f to = StolenUtils.toAbsolute((CombatEntityAPI)this.target, this.targetOffset);
        float distance = MathUtils.getDistance((CombatEntityAPI)this.ship, (Vector2f)to);
        if (this.shouldRepair && distance < 100.0f) {
            float f = (1.0f - distance / 100.0f) * 0.2f;
            this.ship.getLocation().x = (to.x * f + this.ship.getLocation().x * (2.0f - f)) / 2.0f;
            this.ship.getLocation().y = (to.y * f + this.ship.getLocation().y * (2.0f - f)) / 2.0f;
            this.ship.getVelocity().x = (this.target.getVelocity().x * f + this.ship.getVelocity().x * (2.0f - f)) / 2.0f;
            this.ship.getVelocity().y = (this.target.getVelocity().y * f + this.ship.getVelocity().y * (2.0f - f)) / 2.0f;
        }
        if (this.shouldRepair && distance < 35.0f) {
            if (this.spark) {
                Global.getSoundPlayer().playLoop(SPARK_SOUND_ID, (Object)this.ship, 1.0f, 1.0f, this.ship.getLocation(), this.ship.getVelocity());
                if (this.targetFacingOffset == Float.MIN_VALUE) {
                    this.targetFacingOffset = this.ship.getFacing() - this.target.getFacing();
                } else {
                    this.ship.setFacing(MathUtils.clampAngle((float)(this.targetFacingOffset + this.target.getFacing())));
                }
                if (Math.random() < (double)0.67f) {
                    Vector2f loc = new Vector2f((ReadableVector2f)this.ship.getLocation());
                    loc.x += this.cellSize * 0.5f - this.cellSize * (float)Math.random();
                    loc.y += this.cellSize * 0.5f - this.cellSize * (float)Math.random();
                    Vector2f vel = new Vector2f((ReadableVector2f)this.ship.getVelocity());
                    vel.x = (float)((double)vel.x + (Math.random() - 0.5) * 500.0);
                    vel.y = (float)((double)vel.y + (Math.random() - 0.5) * 500.0);
                    MagicLensFlare.createSharpFlare((CombatEngineAPI)Global.getCombatEngine(), (ShipAPI)this.ship, (Vector2f)loc, (float)5.0f, (float)100.0f, (float)0.0f, (Color)this.SPARK_COLOR, (Color)Color.white);
                }
            }
            this.spark = false;
        } else {
            float distToCarrier = (float)((double)MathUtils.getDistanceSquared((Vector2f)this.carrier.getLocation(), (Vector2f)this.ship.getLocation()) / Math.pow(this.target.getCollisionRadius(), 2.0));
            if (this.target == this.carrier && distToCarrier < 1.0f || this.ship.isLanding()) {
                float f = 1.0f - Math.min(1.0f, distToCarrier);
                if (!this.returning) {
                    f *= 0.1f;
                }
                this.turnToward(this.target.getFacing());
                this.ship.getLocation().x = (to.x * (f * 0.1f) + this.ship.getLocation().x * (2.0f - f * 0.1f)) / 2.0f;
                this.ship.getLocation().y = (to.y * (f * 0.1f) + this.ship.getLocation().y * (2.0f - f * 0.1f)) / 2.0f;
                this.ship.getVelocity().x = (this.target.getVelocity().x * f + this.ship.getVelocity().x * (2.0f - f)) / 2.0f;
                this.ship.getVelocity().y = (this.target.getVelocity().y * f + this.ship.getVelocity().y * (2.0f - f)) / 2.0f;
            } else {
                this.targetFacingOffset = Float.MIN_VALUE;
                float angleDif = MathUtils.getShortestRotation((float)this.ship.getFacing(), (float)VectorUtils.getAngle((Vector2f)this.ship.getLocation(), (Vector2f)to));
                if (Math.abs(angleDif) < 30.0f) {
                    this.accelerate();
                } else {
                    this.turnToward(to);
                    this.decelerate();
                }
                this.strafeToward(to);
            }
        }
    }

    public ShipwideAIFlags getAIFlags() {
        return this.flags;
    }

    @Override
    public void setDoNotFireDelay(float amount) {
    }

    public ShipAIConfig getConfig() {
        return this.config;
    }

    @Override
    public void init() {
        this.target = this.carrier = this.ship.getWing().getSourceShip();
        this.targetOffset = StolenUtils.toRelative((CombatEntityAPI)this.carrier, this.carrier.getLocation());
        this.range = this.ship.getWing().getRange();
    }
}

