/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.edshipyard.rulecmd;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.FleetAssignment;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.impl.campaign.fleets.FleetFactoryV3;
import com.fs.starfarer.api.impl.campaign.fleets.FleetParamsV3;
import data.scripts.edshipyard.rulecmd.EDMagicBountyCommand;
import java.util.Random;
import org.apache.log4j.Logger;
import org.lazywizard.lazylib.MathUtils;
import org.lwjgl.util.vector.Vector2f;
import org.magiclib.bounty.ActiveBounty;

public class ChupacabraAmbushFleetsBountyCommand
extends EDMagicBountyCommand {
    private static final String BountyId = "edshipyard_Chupacabra_HVB";
    private static final Logger log = Global.getLogger(ChupacabraAmbushFleetsBountyCommand.class);

    @Override
    public String getBountyId() {
        return BountyId;
    }

    @Override
    public boolean processBounty(ActiveBounty bounty) {
        ActiveBounty.Stage bountyStage = bounty.getStage();
        if (bountyStage == ActiveBounty.Stage.Succeeded) {
            this.spawnCombatFleet(300, "00000000", 850);
            this.spawnCombatFleet(300, "00000001", 850);
            this.spawnCombatFleet(80, "00000010", 500);
            this.spawnCombatFleet(80, "00000011", 500);
        }
        return true;
    }

    public void spawnCombatFleet(int totalFP, String fleetName, int distanceFromPlayerFleet) {
        try {
            CampaignFleetAPI location = Global.getSector().getPlayerFleet();
            FleetParamsV3 fleetParamsV3 = new FleetParamsV3(null, "remnant", Float.valueOf(3.0f), fleetName, (float)totalFP, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 3.0f);
            fleetParamsV3.withOfficers = false;
            CampaignFleetAPI fleet = FleetFactoryV3.createFleet((FleetParamsV3)fleetParamsV3);
            FleetFactoryV3.addCommanderAndOfficersV2((CampaignFleetAPI)fleet, (FleetParamsV3)fleetParamsV3, (Random)new Random());
            fleet.setName(fleetName);
            fleet.setFaction("remnant");
            fleet.addAssignment(FleetAssignment.INTERCEPT, (SectorEntityToken)Global.getSector().getPlayerFleet(), 30.0f, "Ambushing player fleet");
            Vector2f offset = MathUtils.getRandomPointOnCircumference(null, (float)distanceFromPlayerFleet);
            location.getContainingLocation().spawnFleet((SectorEntityToken)location, offset.x, offset.y, fleet);
            fleet.setTransponderOn(false);
            log.info((Object)("Spawned a " + totalFP + "FP  fleet in system: " + location.getFullName() + "   " + fleet.getFleetData().getCombatReadyMembersListCopy().size() + " ships aligned with faction " + fleet.getFaction().getDisplayName()));
        }
        catch (Exception ex) {
            log.error((Object)"Unable to spawn ambush fleet", (Throwable)ex);
        }
    }
}

