/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.edshipyard.rulecmd;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.fleet.FleetMemberType;
import com.fs.starfarer.api.fleet.RepairTrackerAPI;
import data.scripts.edshipyard.rulecmd.EDMagicBountyCommand;
import data.scripts.edshipyard.util.Utils;
import exerelin.campaign.intel.fleets.VengeanceFleetIntel;
import java.util.Random;
import org.magiclib.bounty.ActiveBounty;
import org.magiclib.bounty.MagicBountyIntel;

public class WurgandalRevengeFleetBountyCommand
extends EDMagicBountyCommand {
    private static final String BountyId = "edshipyard_DestroyTheWurg";

    @Override
    public String getBountyId() {
        return BountyId;
    }

    @Override
    public boolean processBounty(ActiveBounty bounty) {
        ActiveBounty.Stage bountyStage = bounty.getStage();
        MagicBountyIntel intel = bounty.getIntel();
        if (bountyStage == ActiveBounty.Stage.FailedSalvagedFlagship) {
            try {
                float rep = Global.getSector().getPlayerFaction().getRelationship("independent");
                if (rep > -0.5f) {
                    Global.getSector().getPlayerFaction().setRelationship("independent", -0.5f);
                }
                this.spawnVenganceFleet();
            }
            catch (Exception e) {
                Global.getLogger(WurgandalRevengeFleetBountyCommand.class).warn((Object)"Unable to spawnVenganceFleet", (Throwable)e);
            }
        }
        return true;
    }

    private void spawnVenganceFleet() {
        if (!this.isNexerlinEnabled()) {
            return;
        }
        EdVengeanceFleetIntel vfi = new EdVengeanceFleetIntel("independent", this.largestIndMarket(), 1);
        vfi.startEvent();
    }

    private boolean isNexerlinEnabled() {
        return Global.getSettings().getModManager().isModEnabled("nexerelin");
    }

    private MarketAPI largestIndMarket() {
        MarketAPI ret = null;
        for (MarketAPI market : Global.getSector().getEconomy().getMarketsCopy()) {
            if (!Utils.isIndependentOwned(market)) continue;
            if (ret == null) {
                ret = market;
                continue;
            }
            if (market.getSize() <= ret.getSize()) continue;
            ret = market;
        }
        return ret;
    }

    private class EdVengeanceFleetIntel
    extends VengeanceFleetIntel {
        public EdVengeanceFleetIntel(String factionId, MarketAPI market, int escalationLevel) {
            super(factionId, market, escalationLevel);
            this.escalationLevel = escalationLevel;
        }

        public CampaignFleetAPI spawnFleet() {
            CampaignFleetAPI ret = super.spawnFleet();
            this.addShipToFleet(ret, "edshipyard_newfoundland_warfreighter");
            this.addShipToFleet(ret, "edshipyard_retriever_rescue");
            this.addShipToFleet(ret, "edshipyard_shiba_assault");
            this.addShipToFleet(ret, "edshipyard_shiba_assault");
            this.addShipToFleet(ret, "edshipyard_saluki_beam");
            this.addShipToFleet(ret, "edshipyard_saluki_beam");
            this.addShipToFleet(ret, "edshipyard_saluki_beam");
            this.addShipToFleet(ret, "edshipyard_rottweiler_so");
            this.addShipToFleet(ret, "edshipyard_rottweiler_so");
            this.addShipToFleet(ret, "edshipyard_chihuahua_so");
            this.addShipToFleet(ret, "edshipyard_chihuahua_so");
            this.addShipToFleet(ret, "edshipyard_chihuahua_so");
            this.addShipToFleet(ret, "edshipyard_groenendael_beam");
            this.addShipToFleet(ret, "edshipyard_leonberger_assault");
            this.addShipToFleet(ret, "edshipyard_dobermann_variant");
            this.addShipToFleet(ret, "edshipyard_dalmatian_phase");
            this.addShipToFleet(ret, "edshipyard_dalmatian_phase");
            this.addShipToFleet(ret, "edshipyard_bernard_variant");
            this.addShipToFleet(ret, "edshipyard_bernard_variant");
            this.addShipToFleet(ret, "edshipyard_bernard_variant");
            ret.setName("ED Shipyards Kill Fleet");
            return ret;
        }

        private void addShipToFleet(CampaignFleetAPI fleet, String variant) {
            try {
                FleetMemberAPI member = Global.getFactory().createFleetMember(FleetMemberType.SHIP, variant);
                String name = fleet.getFleetData().pickShipName(member, new Random());
                member.setShipName(name);
                fleet.getFleetData().addFleetMember(member);
                fleet.getFleetData().sort();
                fleet.forceSync();
                RepairTrackerAPI repairs = member.getRepairTracker();
                repairs.setCR(repairs.getMaxCR());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

