/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.edshipyard.shipsystems;

import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.impl.combat.BaseShipSystemScript;
import com.fs.starfarer.api.plugins.ShipSystemStatsScript;
import data.scripts.edshipyard.util.StolenUtils;
import java.awt.Color;
import java.util.Random;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class DoppelswapStats
extends BaseShipSystemScript {
    public final Color JITTER_COLOR = new Color(125, 50, 150, 150);
    public Random rng;
    public ShipAPI ship;
    public ShipAPI target;
    boolean teleported;

    public ShipSystemStatsScript.StatusData getStatusData(int index, ShipSystemStatsScript.State state, float effectLevel) {
        return null;
    }

    public void unapply(MutableShipStatsAPI stats, String id) {
        this.teleported = false;
    }

    public void apply(MutableShipStatsAPI stats, String id, ShipSystemStatsScript.State state, float effectLevel) {
        if (this.ship == null) {
            this.ship = (ShipAPI)stats.getEntity();
            this.teleported = false;
            this.rng = new Random();
            return;
        }
        if (!this.teleported) {
            ShipAPI target = this.ship.getShipTarget();
            if (target != null && target.isDrone() && target.getDroneSource() == this.ship && !target.isPhased()) {
                this.swap(this.ship, target);
            } else {
                target = null;
                float minthreat = Float.MAX_VALUE;
                for (ShipAPI doppel : this.ship.getDeployedDrones()) {
                    float inc;
                    if (!doppel.isAlive() || doppel.isPhased() || !(minthreat > (inc = StolenUtils.estimateAllIncomingDamage(doppel) + (float)this.rng.nextInt(9)))) continue;
                    minthreat = inc;
                    target = doppel;
                }
                if (target != null) {
                    this.swap(this.ship, target);
                }
            }
        }
    }

    public void swap(ShipAPI ship, ShipAPI target) {
        ship.setJitterUnder((Object)ship, this.JITTER_COLOR, 1.0f, 5, ship.getCollisionRadius() * 1.5f);
        target.setJitterUnder((Object)target, this.JITTER_COLOR, 1.0f, 5, target.getCollisionRadius() * 1.5f);
        Vector2f loc1 = new Vector2f((ReadableVector2f)ship.getLocation());
        Vector2f loc2 = new Vector2f((ReadableVector2f)target.getLocation());
        Vector2f spd1 = new Vector2f((ReadableVector2f)ship.getVelocity());
        Vector2f spd2 = new Vector2f((ReadableVector2f)target.getVelocity());
        float facing = ship.getFacing();
        ship.setFacing(target.getFacing());
        target.setFacing(facing);
        ship.getLocation().set((ReadableVector2f)loc2);
        target.getLocation().set((ReadableVector2f)loc1);
        ship.getVelocity().set((ReadableVector2f)spd2);
        target.getVelocity().set((ReadableVector2f)spd1);
        this.teleported = true;
    }
}

