/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.edshipyard.shipsystems;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.CollisionClass;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.DamageType;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipSystemAPI;
import com.fs.starfarer.api.impl.combat.BaseShipSystemScript;
import com.fs.starfarer.api.plugins.ShipSystemStatsScript;
import com.fs.starfarer.api.util.IntervalUtil;
import java.awt.Color;
import java.util.ArrayList;
import org.dark.shaders.distortion.DistortionAPI;
import org.dark.shaders.distortion.DistortionShader;
import org.dark.shaders.distortion.RippleDistortion;
import org.lazywizard.lazylib.MathUtils;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class SpatialSwapStats
extends BaseShipSystemScript {
    public ShipAPI ship;
    public ShipAPI target;
    public ArrayList<Integer> sizeRange;
    public ShipAPI lockedTarget;
    public boolean teleported = false;
    private static final float MAX_RANGE = 4000.0f;
    private static final Color EMP_CORE_COLOR = new Color(200, 175, 200, 255);
    private static final Color EMP_FRINGE_COLOR = new Color(150, 75, 150, 200);
    private static final Color JITTER_UNDER_COLOR = new Color(150, 50, 150, 100);
    private static final Color JITTER_OVER_COLOR = new Color(150, 150, 50, 100);
    private static final String SHIELDKEY = "SpatialSwapDamageReduction";
    private final IntervalUtil interval = new IntervalUtil(0.2f, 0.25f);

    private int getSize(ShipAPI test) {
        switch (test.getHullSize()) {
            case CAPITAL_SHIP: {
                return 4;
            }
            case CRUISER: {
                return 3;
            }
            case DESTROYER: {
                return 2;
            }
        }
        return 1;
    }

    private int isTargetValid(ShipAPI ship, ShipAPI target) {
        if (target == null || ship == null) {
            return 7;
        }
        if (target.getOwner() != ship.getOwner()) {
            return 6;
        }
        if (target.isPhased()) {
            return 5;
        }
        if (!target.isAlive()) {
            return 4;
        }
        if (target.isStation()) {
            return 3;
        }
        if (target.isStationModule()) {
            return 2;
        }
        if (this.sizeRange != null && !this.sizeRange.contains(this.getSize(target))) {
            return 1;
        }
        if (MathUtils.getDistance((CombatEntityAPI)ship, (CombatEntityAPI)target) > 4000.0f) {
            return 8;
        }
        MutableShipStatsAPI targetStats = target.getMutableStats();
        if (targetStats == null || targetStats.getHullDamageTakenMult().getMultMods().containsKey(SHIELDKEY)) {
            return 9;
        }
        return 0;
    }

    public String getInfoText(ShipSystemAPI system, ShipAPI ship) {
        switch (system.getState()) {
            case COOLDOWN: {
                return "COOLING DOWN";
            }
            case IN: {
                return "CHARGING UP";
            }
            case OUT: {
                return "COOLING DOWN";
            }
            case ACTIVE: {
                return "SHIELDS REINFORCED";
            }
            case IDLE: {
                break;
            }
            default: {
                return null;
            }
        }
        if (this.target == null || ship == null) {
            return "NO TARGET";
        }
        switch (this.isTargetValid(ship, this.target)) {
            case 9: {
                return "ALREADY BEING SWAPPED";
            }
            case 8: {
                return "OUT OF RANGE";
            }
            case 7: {
                return "INVALID TARGET";
            }
            case 6: {
                return "TARGET IS NOT ALLY";
            }
            case 5: {
                return "TARGET IS PHASED";
            }
            case 4: {
                return "CONNECTION LOST";
            }
            case 3: {
                return "STATIONS ARE INVALID";
            }
            case 2: {
                return "MODULES ARE INVALID";
            }
            case 1: {
                return "TARGET MASS MISMATCH";
            }
        }
        return "READY";
    }

    public ShipSystemStatsScript.StatusData getStatusData(int index, ShipSystemStatsScript.State state, float effectLevel) {
        switch (state) {
            case ACTIVE: {
                if (index != 0) break;
                return new ShipSystemStatsScript.StatusData("Shields Strengthened", false);
            }
        }
        return null;
    }

    public void init(ShipAPI ship) {
        this.ship = ship;
        this.sizeRange = new ArrayList();
        int size = this.getSize(ship);
        this.sizeRange.add(size - 1);
        this.sizeRange.add(size);
        this.sizeRange.add(size + 1);
    }

    public boolean isUsable(ShipSystemAPI system, ShipAPI ship) {
        if (this.ship == null) {
            this.init(ship);
        }
        this.target = ship.getShipTarget();
        return this.isTargetValid(ship, this.target) == 0;
    }

    public void unapply(MutableShipStatsAPI stats, String id) {
        stats.getShieldAbsorptionMult().unmodify(id);
        this.teleported = false;
        if (this.lockedTarget != null) {
            MutableShipStatsAPI targetStats = this.ship.getMutableStats();
            if (targetStats != null && targetStats.getHullDamageTakenMult().getMultMods().containsKey(SHIELDKEY)) {
                targetStats.getHullDamageTakenMult().unmodify(SHIELDKEY);
            }
            this.lockedTarget = null;
        }
        if (this.ship != null) {
            this.ship.setJitterShields(false);
        }
    }

    public void apply(MutableShipStatsAPI stats, String id, ShipSystemStatsScript.State state, float effectLevel) {
        if (this.ship == null) {
            this.init((ShipAPI)stats.getEntity());
            return;
        }
        this.target = this.ship.getShipTarget();
        float amount = Global.getCombatEngine().getElapsedInLastFrame();
        if (Global.getCombatEngine().isPaused()) {
            amount = 0.0f;
        }
        if (state == ShipSystemStatsScript.State.ACTIVE) {
            if (!this.teleported) {
                this.teleported = true;
                if (this.lockedTarget != null) {
                    MutableShipStatsAPI targetStats = this.lockedTarget.getMutableStats();
                    if (targetStats != null) {
                        targetStats.getHullDamageTakenMult().unmodify(SHIELDKEY);
                    }
                    if (this.lockedTarget.isAlive()) {
                        int i;
                        float shipRadius;
                        CollisionClass col = this.ship.getCollisionClass();
                        this.ship.setCollisionClass(CollisionClass.NONE);
                        float startSize = shipRadius = this.lockedTarget.getCollisionRadius();
                        float endSize = shipRadius * 5.0f;
                        RippleDistortion ripple2 = new RippleDistortion(this.lockedTarget.getLocation(), new Vector2f());
                        ripple2.setSize(endSize);
                        ripple2.setIntensity(20.0f);
                        ripple2.setFrameRate(199.99998f);
                        ripple2.fadeInSize(0.6f * endSize / (endSize - startSize));
                        ripple2.fadeOutIntensity(0.5f);
                        ripple2.setSize(startSize);
                        DistortionShader.addDistortion((DistortionAPI)ripple2);
                        this.ship.getVelocity().set((ReadableVector2f)new Vector2f());
                        this.lockedTarget.getVelocity().set((ReadableVector2f)new Vector2f());
                        Vector2f loc1 = new Vector2f((ReadableVector2f)this.ship.getLocation());
                        Vector2f loc2 = new Vector2f((ReadableVector2f)this.lockedTarget.getLocation());
                        this.ship.getLocation().set((ReadableVector2f)loc2);
                        this.lockedTarget.getLocation().set((ReadableVector2f)loc1);
                        this.ship.setCollisionClass(col);
                        Global.getSoundPlayer().playSound("ed_mag2", 1.0f, 1.0f, this.ship.getLocation(), this.ship.getVelocity());
                        Global.getSoundPlayer().playSound("ed_mag2", 1.0f, 1.0f, this.lockedTarget.getLocation(), this.lockedTarget.getVelocity());
                        for (i = 0; i < this.getSize(this.ship) * 2; ++i) {
                            Global.getCombatEngine().spawnEmpArc(this.ship, this.ship.getLocation(), (CombatEntityAPI)this.ship, (CombatEntityAPI)this.lockedTarget, DamageType.ENERGY, 0.0f, 0.0f, 5000.0f, null, 20.0f, EMP_FRINGE_COLOR, EMP_CORE_COLOR);
                        }
                        for (i = 0; i < this.getSize(this.lockedTarget); ++i) {
                            Global.getCombatEngine().spawnEmpArc(this.lockedTarget, this.lockedTarget.getLocation(), (CombatEntityAPI)this.lockedTarget, (CombatEntityAPI)this.ship, DamageType.ENERGY, 0.0f, 0.0f, 5000.0f, null, 20.0f, EMP_FRINGE_COLOR, EMP_CORE_COLOR);
                        }
                        this.lockedTarget.setJitter((Object)this, JITTER_UNDER_COLOR, 1.0f, Math.round(10.0f), (float)(this.getSize(this.ship) * 100 + 50));
                        this.ship.setJitter((Object)this, JITTER_UNDER_COLOR, 1.0f, Math.round(10.0f), (float)(this.getSize(this.lockedTarget) * 100 + 50));
                        this.lockedTarget = null;
                        this.ship.setShipTarget(null);
                    } else {
                        Global.getSoundPlayer().playSound("mawend", 1.0f, 1.0f, this.ship.getLocation(), this.ship.getVelocity());
                        this.ship.getFluxTracker().beginOverloadWithTotalBaseDuration(3.0f);
                        return;
                    }
                }
            }
            stats.getShieldAbsorptionMult().modifyMult(id, 0.01f);
            this.ship.setJitterShields(true);
            this.ship.setJitterUnder((Object)this, JITTER_UNDER_COLOR, 1.0f, 3, 5.0f, 25.0f);
        } else if (state == ShipSystemStatsScript.State.IN) {
            if (this.lockedTarget == null) {
                this.lockedTarget = this.target;
                MutableShipStatsAPI targetStats = this.lockedTarget.getMutableStats();
                if (targetStats != null) {
                    targetStats.getHullDamageTakenMult().modifyMult(SHIELDKEY, 1.0f - ((float)this.getSize(this.lockedTarget) + 1.0f) * 0.15f, "WARP DISTORTION SHIELD");
                }
                this.lockedTarget.setJitter((Object)this, JITTER_OVER_COLOR, 1.0f, 3, 2.0f, 10.0f);
            }
            this.interval.advance(amount);
            if (this.interval.intervalElapsed()) {
                float shipRadius = this.ship.getCollisionRadius();
                Vector2f offset = new Vector2f(-6.0f, 0.0f);
                Vector2f centerLocation = Vector2f.add((Vector2f)this.ship.getLocation(), (Vector2f)offset, (Vector2f)new Vector2f());
                float startSize = shipRadius * 1.5f * effectLevel;
                float endSize = shipRadius * 2.0f * effectLevel + 200.0f;
                RippleDistortion ripple1 = new RippleDistortion(centerLocation, new Vector2f());
                ripple1.setSize(endSize);
                ripple1.setIntensity(3.0f * (2.0f * effectLevel));
                ripple1.setFrameRate(199.99998f);
                ripple1.fadeInSize(0.6f * endSize / (endSize - startSize));
                ripple1.fadeOutIntensity(0.5f);
                ripple1.setSize(startSize);
                DistortionShader.addDistortion((DistortionAPI)ripple1);
                float jitterScale = 1.0f;
                float jitterLevel = 1.0f + 1.0f * effectLevel;
                float maxRangeBonus = 30.0f * jitterScale;
                float jitterRangeBonus = (0.5f + jitterLevel) / 1.5f * maxRangeBonus;
                this.ship.setJitterUnder((Object)this, JITTER_UNDER_COLOR, jitterLevel, Math.round(5.0f * jitterScale), 0.0f, 3.0f + jitterRangeBonus);
                Global.getSoundPlayer().playSound("kfp", MathUtils.getRandomNumberInRange((float)0.95f, (float)1.05f) * 0.5f, 0.75f, this.ship.getLocation(), this.ship.getVelocity());
                if (this.lockedTarget != null && this.lockedTarget.isAlive()) {
                    shipRadius = this.lockedTarget.getCollisionRadius();
                    centerLocation = Vector2f.add((Vector2f)this.lockedTarget.getLocation(), (Vector2f)offset, (Vector2f)new Vector2f());
                    startSize = shipRadius * 1.5f * effectLevel;
                    endSize = shipRadius * 2.0f * effectLevel + 200.0f;
                    RippleDistortion ripple2 = new RippleDistortion(centerLocation, new Vector2f());
                    ripple2.setSize(endSize);
                    ripple2.setIntensity(3.0f * (2.0f * effectLevel));
                    ripple2.setFrameRate(199.99998f);
                    ripple2.fadeInSize(0.6f * endSize / (endSize - startSize));
                    ripple2.fadeOutIntensity(0.5f);
                    ripple2.setSize(startSize);
                    DistortionShader.addDistortion((DistortionAPI)ripple2);
                    this.lockedTarget.setJitterUnder((Object)this, JITTER_UNDER_COLOR, jitterLevel, Math.round(5.0f * jitterScale), 0.0f, 3.0f + jitterRangeBonus);
                    this.lockedTarget.setJitter((Object)this, JITTER_OVER_COLOR, 0.5f, 2, 0.0f, 5.0f);
                    Global.getSoundPlayer().playSound("kfp", MathUtils.getRandomNumberInRange((float)0.95f, (float)1.05f) * 0.5f, 0.95f, this.lockedTarget.getLocation(), this.lockedTarget.getVelocity());
                }
            }
        }
    }
}

