/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.edshipyard.shipsystems.ai;

import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipSystemAIScript;
import com.fs.starfarer.api.combat.ShipSystemAPI;
import com.fs.starfarer.api.combat.ShipwideAIFlags;
import com.fs.starfarer.api.combat.WeaponAPI;
import com.fs.starfarer.api.util.IntervalUtil;
import java.util.ArrayList;
import java.util.List;
import org.lazywizard.lazylib.MathUtils;
import org.lazywizard.lazylib.combat.AIUtils;
import org.lazywizard.lazylib.combat.WeaponUtils;
import org.lwjgl.util.vector.Vector2f;

public class GrandSalvoAI
implements ShipSystemAIScript {
    private static final float RangeFractionCutoff = 0.8f;
    private CombatEngineAPI engine;
    private float _gunRange;
    public ArrayList<WeaponAPI> _guns;
    private ShipAPI _ship;
    private final IntervalUtil tracker = new IntervalUtil(0.8f, 1.0f);

    public void advance(float amount, Vector2f missileDangerDir, Vector2f collisionDangerDir, ShipAPI target) {
        if (this.engine == null) {
            return;
        }
        if (this.engine.isPaused()) {
            return;
        }
        this.tracker.advance(amount);
        if (!this.tracker.intervalElapsed()) {
            return;
        }
        if (!AIUtils.canUseSystemThisFrame((ShipAPI)this._ship)) {
            return;
        }
        if (this._guns == null || this._guns.isEmpty()) {
            return;
        }
        for (WeaponAPI g : this._guns) {
            float targetValues = this.getTotalValueOfHittableTargets(g);
            if (targetValues < 10.0f) {
                return;
            }
            for (ShipAPI ally : WeaponUtils.getAlliesInArc((WeaponAPI)g)) {
                if (ally.isStationModule() || MathUtils.getDistance((CombatEntityAPI)this._ship, (CombatEntityAPI)ally) > this._gunRange * 0.8f || ally.getHullSize().ordinal() < ShipAPI.HullSize.FRIGATE.ordinal()) continue;
                return;
            }
        }
        this._ship.useSystem();
    }

    private float getTotalValueOfHittableTargets(WeaponAPI g) {
        List enemies = WeaponUtils.getEnemiesInArc((WeaponAPI)g);
        float ret = 0.0f;
        for (ShipAPI enemy : enemies) {
            if (!(MathUtils.getDistance((CombatEntityAPI)this._ship, (CombatEntityAPI)enemy) < this._gunRange * 0.8f)) continue;
            ret += (float)this.getShipValue(enemy);
        }
        return ret;
    }

    private int getShipValue(ShipAPI ship) {
        switch (ship.getHullSize()) {
            case FIGHTER: {
                return 0;
            }
            case DEFAULT: {
                return 0;
            }
            case FRIGATE: {
                return 5;
            }
            case DESTROYER: {
                return 7;
            }
            case CRUISER: {
                return 10;
            }
            case CAPITAL_SHIP: {
                return 20;
            }
        }
        return 0;
    }

    public void init(ShipAPI ship, ShipSystemAPI system, ShipwideAIFlags flags, CombatEngineAPI engine) {
        this._ship = ship;
        this.engine = engine;
        this._guns = new ArrayList();
        for (WeaponAPI w : this._ship.getAllWeapons()) {
            if (!w.isDecorative() || !w.getDisplayName().contains("Hellborn")) continue;
            this._guns.add(w);
            this._gunRange = w.getRange();
        }
    }
}

