/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.edshipyard.shipsystems.ai;

import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.MissileAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipSystemAIScript;
import com.fs.starfarer.api.combat.ShipSystemAPI;
import com.fs.starfarer.api.combat.ShipwideAIFlags;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.util.IntervalUtil;
import data.scripts.edshipyard.shipsystems.MagneticBurstStats;
import java.util.List;
import org.lazywizard.lazylib.MathUtils;
import org.lazywizard.lazylib.combat.AIUtils;
import org.lazywizard.lazylib.combat.CombatUtils;
import org.lwjgl.util.vector.Vector2f;

public class MagneticBurstAI
implements ShipSystemAIScript {
    private CombatEngineAPI engine;
    public final float BASE_RANGE = 700.0f;
    public final float BLAST_AREA_RADIUS_SCALE = 3.0f;
    public final float BLAST_AREA_FLAT = 300.0f;
    private ShipwideAIFlags flags;
    private ShipAPI ship;
    private final IntervalUtil tracker = new IntervalUtil(0.3f, 0.5f);

    public void advance(float amount, Vector2f missileDangerDir, Vector2f collisionDangerDir, ShipAPI target) {
        if (this.engine == null) {
            return;
        }
        if (this.engine.isPaused()) {
            return;
        }
        this.tracker.advance(amount);
        Vector2f shipLoc = this.ship.getLocation();
        if (this.tracker.intervalElapsed()) {
            boolean missileThreat;
            if (!AIUtils.canUseSystemThisFrame((ShipAPI)this.ship)) {
                return;
            }
            float shipRadius = MagneticBurstStats.effectiveRadius(this.ship);
            float maxRange = 700.0f + 200.0f * (float)this.getSize(this.ship);
            float falloffRange = maxRange * 0.9f;
            float decisionTarget = 200.0f;
            float blastArea = shipRadius * 3.0f + 300.0f;
            ShipAPI bestTarget = null;
            float bestTargetWeight = 0.0f;
            float totalTargetWeight = 0.0f;
            List nearbyTargets = CombatUtils.getShipsWithinRange((Vector2f)shipLoc, (float)maxRange);
            for (ShipAPI t : nearbyTargets) {
                FleetMemberAPI member;
                if (t.getOwner() == this.ship.getOwner() || !t.isAlive() || t.isShuttlePod() || t.isDrone()) continue;
                float weight = (float)(5 - this.getSize(t)) * 5.0f + t.getFluxLevel() * 2.0f * 5.0f * (1.0f - t.getHullLevel()) * 5.0f;
                float shipStrength = 5.0f;
                weight *= (1.0f - MathUtils.getDistance((CombatEntityAPI)this.ship, (CombatEntityAPI)t) / falloffRange) * 7.0f;
                if (t.isPhased()) {
                    weight *= 4.0f;
                }
                if ((member = CombatUtils.getFleetMember((ShipAPI)t)) != null) {
                    shipStrength += 0.1f + (float)member.getFleetPointCost();
                }
                if ((weight *= (float)Math.sqrt(shipStrength)) >= bestTargetWeight) {
                    bestTarget = t;
                    bestTargetWeight = weight;
                }
                totalTargetWeight += weight;
            }
            float missileThreatLevel = 0.0f;
            List allMissiles = CombatUtils.getMissilesWithinRange((Vector2f)this.ship.getLocation(), (float)(blastArea * 0.9f));
            for (MissileAPI missile : allMissiles) {
                if (missile.getOwner() == this.ship.getOwner()) continue;
                float scale = 3.0f;
                switch (missile.getDamageType()) {
                    case FRAGMENTATION: {
                        scale = 0.5f;
                        break;
                    }
                    case KINETIC: {
                        scale = 0.5f;
                        break;
                    }
                    case HIGH_EXPLOSIVE: {
                        scale = 2.5f;
                        break;
                    }
                }
                missileThreatLevel += missile.getDamageAmount() * scale;
            }
            boolean bl = missileThreat = missileThreatLevel >= this.ship.getHitpoints() * 0.25f;
            if (bestTarget == null) {
                if (!missileThreat) {
                    return;
                }
            } else {
                this.ship.setShipTarget(bestTarget);
            }
            float decisionLevel = bestTargetWeight + totalTargetWeight;
            decisionLevel += missileThreatLevel / this.ship.getHitpoints() * 200.0f;
            if (this.flags.hasFlag(ShipwideAIFlags.AIFlags.BACK_OFF) || this.flags.hasFlag(ShipwideAIFlags.AIFlags.BACKING_OFF)) {
                decisionLevel *= 1.25f;
            }
            if (this.ship.isPhased() && this.ship.getFluxTracker().getFluxLevel() >= 0.9f) {
                decisionLevel += 150.0f;
            }
            if (decisionLevel >= decisionTarget) {
                this.ship.useSystem();
            }
        }
    }

    private int getSize(ShipAPI test) {
        switch (test.getHullSize()) {
            case CAPITAL_SHIP: {
                return 4;
            }
            case CRUISER: {
                return 3;
            }
            case DESTROYER: {
                return 2;
            }
        }
        return 1;
    }

    public void init(ShipAPI ship, ShipSystemAPI system, ShipwideAIFlags flags, CombatEngineAPI engine) {
        this.ship = ship;
        this.flags = flags;
        this.engine = engine;
    }
}

