/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.edshipyard.shipsystems.ai;

import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.FighterWingAPI;
import com.fs.starfarer.api.combat.MissileAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipSystemAIScript;
import com.fs.starfarer.api.combat.ShipSystemAPI;
import com.fs.starfarer.api.combat.ShipwideAIFlags;
import com.fs.starfarer.api.util.IntervalUtil;
import java.util.List;
import java.util.Random;
import org.lazywizard.lazylib.combat.AIUtils;
import org.lazywizard.lazylib.combat.CombatUtils;
import org.lwjgl.util.vector.Vector2f;

public class MisdirectionAI
implements ShipSystemAIScript {
    private CombatEngineAPI engine;
    private ShipAPI ship;
    private Random rng;
    private final IntervalUtil tracker = new IntervalUtil(0.75f, 1.0f);

    public void advance(float amount, Vector2f missileDangerDir, Vector2f collisionDangerDir, ShipAPI target) {
        if (this.engine == null) {
            return;
        }
        if (this.engine.isPaused()) {
            return;
        }
        this.tracker.advance(amount);
        Vector2f shipLoc = this.ship.getLocation();
        if (this.tracker.intervalElapsed()) {
            if (!AIUtils.canUseSystemThisFrame((ShipAPI)this.ship)) {
                return;
            }
            float maxRange = this.ship.getCollisionRadius() * 4.0f;
            float largestmt = 0.0f;
            List fighters = this.ship.getAllWings();
            if (fighters != null && !fighters.isEmpty()) {
                for (FighterWingAPI wing : fighters) {
                    int num = wing.getWingMembers().size();
                    if (num <= 0) continue;
                    ShipAPI fighter = (ShipAPI)wing.getWingMembers().get(this.rng.nextInt(num));
                    float fightermt = 0.0f;
                    if (fighter == null || !fighter.isAlive()) continue;
                    List allMissiles = CombatUtils.getMissilesWithinRange((Vector2f)fighter.getLocation(), (float)250.0f);
                    for (MissileAPI missile : allMissiles) {
                        if (missile.getOwner() == this.ship.getOwner()) continue;
                        float scale = 1.0f;
                        switch (missile.getDamageType()) {
                            case FRAGMENTATION: {
                                scale = 0.25f;
                                break;
                            }
                            case KINETIC: {
                                scale = 0.5f;
                                break;
                            }
                        }
                        fightermt += missile.getDamageAmount() * scale;
                    }
                    if (!(fightermt > largestmt)) continue;
                    largestmt = fightermt;
                }
            }
            float missileThreatLevel = largestmt * 0.6f;
            List allMissiles = CombatUtils.getMissilesWithinRange((Vector2f)shipLoc, (float)maxRange);
            for (MissileAPI missile : allMissiles) {
                if (missile.getOwner() == this.ship.getOwner()) continue;
                float scale = 1.0f;
                switch (missile.getDamageType()) {
                    case FRAGMENTATION: {
                        scale = 0.25f;
                        break;
                    }
                    case KINETIC: {
                        scale = 0.5f;
                        break;
                    }
                }
                missileThreatLevel += missile.getDamageAmount() * scale;
            }
            if (missileThreatLevel * (1.0f + this.ship.getFluxLevel() * 2.0f) >= this.ship.getHitpoints() / 2.0f) {
                this.ship.useSystem();
            }
        }
    }

    public void init(ShipAPI ship, ShipSystemAPI system, ShipwideAIFlags flags, CombatEngineAPI engine) {
        this.ship = ship;
        this.engine = engine;
        this.rng = new Random();
    }
}

