/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.edshipyard.shipsystems.ai;

import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipSystemAIScript;
import com.fs.starfarer.api.combat.ShipSystemAPI;
import com.fs.starfarer.api.combat.ShipwideAIFlags;
import com.fs.starfarer.api.combat.WeaponAPI;
import com.fs.starfarer.api.util.IntervalUtil;
import org.lazywizard.lazylib.combat.AIUtils;
import org.lwjgl.util.vector.Vector2f;

public class WurgOverdriveAI
implements ShipSystemAIScript {
    private static final float TARGET_DESIRE = 1.0f;
    private CombatEngineAPI engine;
    private ShipwideAIFlags flags;
    private ShipAPI ship;
    private ShipSystemAPI system;
    private WeaponAPI maw;
    private final IntervalUtil tracker = new IntervalUtil(0.2f, 0.3f);

    public void advance(float amount, Vector2f missileDangerDir, Vector2f collisionDangerDir, ShipAPI target) {
        if (this.engine == null) {
            return;
        }
        if (this.engine.isPaused()) {
            return;
        }
        if (this.maw == null) {
            for (WeaponAPI w : this.ship.getAllWeapons()) {
                if (!w.getDisplayName().contains("Maw")) continue;
                this.maw = w;
                break;
            }
            return;
        }
        this.tracker.advance(amount);
        if (!this.tracker.intervalElapsed()) {
            return;
        }
        if (this.ship.getFluxTracker().isOverloadedOrVenting() || this.system.isCoolingDown()) {
            return;
        }
        if (this.system.isActive()) {
            if (!this.system.isChargedown()) {
                float deactivateDesire = this.ship.getFluxLevel() * 1.5f;
                if (this.maw != null && this.maw.isFiring()) {
                    deactivateDesire += -0.05f;
                }
                if (deactivateDesire >= 1.0f) {
                    this.ship.useSystem();
                }
            }
        } else {
            float activationDesire = 1.0f - this.ship.getFluxLevel() * 1.7f;
            if (this.maw != null && this.maw.isFiring() && (double)this.maw.getChargeLevel() >= 0.2) {
                activationDesire += 0.6f;
            }
            if (this.flags.hasFlag(ShipwideAIFlags.AIFlags.MAINTAINING_STRIKE_RANGE)) {
                activationDesire += 0.35f;
            }
            if (this.flags.hasFlag(ShipwideAIFlags.AIFlags.SAFE_FROM_DANGER_TIME)) {
                activationDesire += 0.15f;
            }
            if (this.flags.hasFlag(ShipwideAIFlags.AIFlags.PURSUING)) {
                activationDesire += 0.35f;
            }
            if (this.flags.hasFlag(ShipwideAIFlags.AIFlags.NEEDS_HELP)) {
                activationDesire -= 0.25f;
            }
            if (this.flags.hasFlag(ShipwideAIFlags.AIFlags.DO_NOT_USE_FLUX)) {
                activationDesire -= 0.35f;
            }
            if (this.flags.hasFlag(ShipwideAIFlags.AIFlags.BACK_OFF)) {
                activationDesire -= 0.35f;
            }
            int nearbyenemies = 0;
            for (ShipAPI enemyShip : AIUtils.getNearbyEnemies((CombatEntityAPI)this.ship, (float)1800.0f)) {
                if (enemyShip.getHullSize() == ShipAPI.HullSize.FIGHTER) continue;
                ++nearbyenemies;
            }
            for (ShipAPI module : this.maw.getShip().getChildModulesCopy()) {
                for (WeaponAPI weapon : module.getAllWeapons()) {
                    if (!weapon.isFiring() || weapon.getType() == WeaponAPI.WeaponType.MISSILE || weapon.getSize() == WeaponAPI.WeaponSize.SMALL) continue;
                    activationDesire += 0.05f;
                }
            }
            if (activationDesire >= 1.0f && (double)this.ship.getFluxLevel() < 0.7 && (nearbyenemies >= 1 || this.maw.isFiring())) {
                this.ship.useSystem();
            }
        }
    }

    public void init(ShipAPI ship, ShipSystemAPI system, ShipwideAIFlags flags, CombatEngineAPI engine) {
        this.ship = ship;
        this.flags = flags;
        this.system = system;
        this.engine = engine;
    }
}

