/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.richtext;

import java.util.ArrayList;
import java.util.List;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.PathElement;
import javafx.scene.text.Text;
import javafx.scene.text.TextFlow;
import org.fxmisc.richtext.TextFlowSpan;
import org.fxmisc.richtext.model.TwoLevelNavigator;

class TextFlowLayout {
    private TextFlow flow;
    private List<Node> children;
    private List<TextFlowSpan> lineMetrics = new ArrayList<TextFlowSpan>();
    private int lineCount = -1;

    TextFlowLayout(TextFlow tf, List<Node> managedChildren) {
        tf.getChildren().addListener(ob -> {
            this.lineCount = -1;
        });
        tf.widthProperty().addListener(ob -> {
            this.lineCount = -1;
        });
        this.children = managedChildren;
        this.flow = tf;
    }

    float getLineCenter(int lineNo) {
        return this.getLineCount() > 0 ? this.lineMetrics.get(lineNo).getCenterY() : 1.0f;
    }

    int getLineLength(int lineNo) {
        return this.getLineSpan(lineNo).getLength();
    }

    TextFlowSpan getLineSpan(int lineNo) {
        return this.getLineCount() > 0 ? this.lineMetrics.get(lineNo) : null;
    }

    TextFlowSpan getLineSpan(float y) {
        int lastLine = this.getLineCount() - 1;
        return this.lineMetrics.stream().filter(tfs -> (double)y < tfs.getBounds().getMaxY()).findFirst().orElse(this.lineMetrics.get(lastLine));
    }

    TwoLevelNavigator getTwoLevelNavigator() {
        return new TwoLevelNavigator(this::getLineCount, this::getLineLength);
    }

    int getLineCount() {
        if (this.lineCount > -1) {
            return this.lineCount;
        }
        this.lineMetrics.clear();
        double totLines = 0.0;
        double prevMinY = 1.0;
        double prevMaxY = -1.0;
        int totCharSoFar = 0;
        for (Node n : this.children) {
            Bounds nodeBounds = n.getBoundsInParent();
            int length = n instanceof Text ? ((Text)n).getText().length() : 1;
            PathElement[] shape = this.flow.rangeShape(totCharSoFar, totCharSoFar + length);
            double lines = Math.max(1.0, Math.floor(shape.length / 5));
            double nodeMinY = Math.max(0.0, nodeBounds.getMinY());
            if (nodeMinY >= prevMinY && lines > 1.0) {
                totLines += lines - 1.0;
            } else if (nodeMinY >= prevMaxY) {
                totLines += lines;
            }
            if ((double)this.lineMetrics.size() < totLines) {
                if (shape.length == 0) {
                    this.lineMetrics.add(new TextFlowSpan(totCharSoFar, length, nodeMinY, nodeBounds.getWidth(), nodeBounds.getHeight()));
                    totCharSoFar += length;
                } else {
                    for (int ele = 1; ele < shape.length; ele += 5) {
                        LineTo eleLine = (LineTo)shape[ele];
                        double segWidth = eleLine.getX();
                        double lineMinY = eleLine.getY();
                        double charHeight = ((LineTo)shape[ele + 1]).getY() - lineMinY;
                        Point2D endPoint = new Point2D(segWidth - 1.0, lineMinY + charHeight / 2.0);
                        int segLen = this.flow.hitTest(endPoint).getCharIndex();
                        segLen -= totCharSoFar - 1;
                        if (ele == 1 && nodeMinY < prevMaxY) {
                            this.adjustLineMetrics(segLen, segWidth - ((MoveTo)shape[ele - 1]).getX(), charHeight);
                        } else {
                            this.lineMetrics.add(new TextFlowSpan(totCharSoFar, segLen, lineMinY, segWidth, charHeight));
                        }
                        totCharSoFar += segLen;
                    }
                }
            } else {
                this.adjustLineMetrics(length, nodeBounds.getWidth(), nodeBounds.getHeight());
                totCharSoFar += length;
            }
            prevMaxY = nodeBounds.getMaxY();
            prevMinY = nodeMinY;
        }
        this.lineCount = (int)totLines;
        return this.lineCount;
    }

    private void adjustLineMetrics(int length, double width, double height) {
        TextFlowSpan span = this.lineMetrics.get(this.lineMetrics.size() - 1);
        span.addLengthAndWidth(length, width);
        if (height > span.getHeight()) {
            span.setHeight(height);
        }
    }
}

