/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.richtext;

import java.time.Duration;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.event.EventHandler;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.input.MouseEvent;
import javafx.scene.text.TextFlow;
import org.fxmisc.richtext.CharacterHit;
import org.fxmisc.richtext.NavigationActions;
import org.fxmisc.richtext.model.Paragraph;
import org.reactfx.EventStream;
import org.reactfx.collection.LiveList;
import org.reactfx.value.Val;
import org.reactfx.value.Var;

public interface ViewActions<PS, SEG, S> {
    default public boolean isEditable() {
        return this.editableProperty().get();
    }

    default public void setEditable(boolean value) {
        this.editableProperty().set(value);
    }

    public BooleanProperty editableProperty();

    default public boolean isWrapText() {
        return this.wrapTextProperty().get();
    }

    default public void setWrapText(boolean value) {
        this.wrapTextProperty().set(value);
    }

    public BooleanProperty wrapTextProperty();

    default public Duration getMouseOverTextDelay() {
        return (Duration)this.mouseOverTextDelayProperty().get();
    }

    default public void setMouseOverTextDelay(Duration delay) {
        this.mouseOverTextDelayProperty().set((Object)delay);
    }

    public ObjectProperty<Duration> mouseOverTextDelayProperty();

    default public boolean isAutoScrollOnDragDesired() {
        return this.autoScrollOnDragDesiredProperty().get();
    }

    default public void setAutoScrollOnDragDesired(boolean val) {
        this.autoScrollOnDragDesiredProperty().set(val);
    }

    public BooleanProperty autoScrollOnDragDesiredProperty();

    public void setOnOutsideSelectionMousePressed(EventHandler<MouseEvent> var1);

    public ObjectProperty<EventHandler<MouseEvent>> onOutsideSelectionMousePressedProperty();

    public EventHandler<MouseEvent> getOnOutsideSelectionMousePressed();

    public void setOnInsideSelectionMousePressReleased(EventHandler<MouseEvent> var1);

    public ObjectProperty<EventHandler<MouseEvent>> onInsideSelectionMousePressReleasedProperty();

    public EventHandler<MouseEvent> getOnInsideSelectionMousePressReleased();

    default public Consumer<Point2D> getOnNewSelectionDrag() {
        return (Consumer)this.onNewSelectionDragProperty().get();
    }

    default public void setOnNewSelectionDrag(Consumer<Point2D> consumer) {
        this.onNewSelectionDragProperty().set(consumer);
    }

    public ObjectProperty<Consumer<Point2D>> onNewSelectionDragProperty();

    public void setOnNewSelectionDragFinished(EventHandler<MouseEvent> var1);

    public ObjectProperty<EventHandler<MouseEvent>> onNewSelectionDragFinishedProperty();

    public EventHandler<MouseEvent> getOnNewSelectionDragFinished();

    default public Consumer<Point2D> getOnSelectionDrag() {
        return (Consumer)this.onSelectionDragProperty().get();
    }

    default public void setOnSelectionDrag(Consumer<Point2D> consumer) {
        this.onSelectionDragProperty().set(consumer);
    }

    public ObjectProperty<Consumer<Point2D>> onSelectionDragProperty();

    public void setOnSelectionDropped(EventHandler<MouseEvent> var1);

    public ObjectProperty<EventHandler<MouseEvent>> onSelectionDroppedProperty();

    public EventHandler<MouseEvent> getOnSelectionDropped();

    default public IntFunction<? extends Node> getParagraphGraphicFactory() {
        return (IntFunction)this.paragraphGraphicFactoryProperty().get();
    }

    default public void setParagraphGraphicFactory(IntFunction<? extends Node> factory) {
        this.paragraphGraphicFactoryProperty().set(factory);
    }

    public ObjectProperty<IntFunction<? extends Node>> paragraphGraphicFactoryProperty();

    default public ContextMenu getContextMenu() {
        return (ContextMenu)this.contextMenuObjectProperty().get();
    }

    default public void setContextMenu(ContextMenu menu) {
        this.contextMenuObjectProperty().set((Object)menu);
    }

    public ObjectProperty<ContextMenu> contextMenuObjectProperty();

    default public double getContextMenuXOffset() {
        return this.contextMenuXOffsetProperty().get();
    }

    default public void setContextMenuXOffset(double offset) {
        this.contextMenuXOffsetProperty().set(offset);
    }

    public DoubleProperty contextMenuXOffsetProperty();

    default public double getContextMenuYOffset() {
        return this.contextMenuYOffsetProperty().get();
    }

    default public void setContextMenuYOffset(double offset) {
        this.contextMenuYOffsetProperty().set(offset);
    }

    public DoubleProperty contextMenuYOffsetProperty();

    public Var<Double> estimatedScrollXProperty();

    public Var<Double> estimatedScrollYProperty();

    public Val<Double> totalWidthEstimateProperty();

    public Val<Double> totalHeightEstimateProperty();

    public EventStream<?> viewportDirtyEvents();

    public LiveList<Paragraph<PS, SEG, S>> getVisibleParagraphs();

    public BiConsumer<TextFlow, PS> getApplyParagraphStyle();

    public double getViewportHeight();

    public Optional<Integer> allParToVisibleParIndex(int var1);

    public int visibleParToAllParIndex(int var1);

    default public int firstVisibleParToAllParIndex() {
        return this.visibleParToAllParIndex(0);
    }

    default public int lastVisibleParToAllParIndex() {
        return this.visibleParToAllParIndex(this.getVisibleParagraphs().size() - 1);
    }

    public CharacterHit hit(double var1, double var3);

    public int lineIndex(int var1, int var2);

    public int getParagraphLinesCount(int var1);

    public <T extends Node> Optional<Bounds> getCaretBoundsOnScreen(T var1);

    public Optional<Bounds> getCharacterBoundsOnScreen(int var1, int var2);

    public Bounds getVisibleParagraphBoundsOnScreen(int var1);

    public Optional<Bounds> getParagraphBoundsOnScreen(int var1);

    public void showParagraphInViewport(int var1);

    public void showParagraphAtTop(int var1);

    public void showParagraphAtBottom(int var1);

    public void showParagraphRegion(int var1, Bounds var2);

    public void requestFollowCaret();

    public void lineStart(NavigationActions.SelectionPolicy var1);

    public void lineEnd(NavigationActions.SelectionPolicy var1);

    default public void selectLine() {
        this.lineStart(NavigationActions.SelectionPolicy.CLEAR);
        this.lineEnd(NavigationActions.SelectionPolicy.ADJUST);
    }

    public void prevPage(NavigationActions.SelectionPolicy var1);

    public void nextPage(NavigationActions.SelectionPolicy var1);

    default public void hideContextMenu() {
        ContextMenu menu = this.getContextMenu();
        if (menu != null && menu.isShowing()) {
            menu.hide();
        }
    }
}

