/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.richtext.event;

import java.time.Duration;
import javafx.event.Event;
import javafx.event.EventTarget;
import javafx.event.EventType;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import org.fxmisc.richtext.event.MouseStationaryEvent;
import org.reactfx.EventStream;
import org.reactfx.EventStreams;
import org.reactfx.Subscription;
import org.reactfx.util.Either;

public class MouseStationaryHelper {
    private final Node node;
    private Subscription installed = null;

    public MouseStationaryHelper(Node node) {
        this.node = node;
    }

    public EventStream<Either<Point2D, Void>> events(Duration delay) {
        EventStream mouseEvents = EventStreams.eventsOf((Node)this.node, (EventType)MouseEvent.ANY);
        EventStream stationaryPositions = mouseEvents.successionEnds(delay).filter(e -> e.getEventType() == MouseEvent.MOUSE_MOVED).map(e -> new Point2D(e.getX(), e.getY()));
        EventStream stoppers = mouseEvents.supply((Object)null);
        return stationaryPositions.or(stoppers).distinct();
    }

    public void install(Duration delay) {
        if (this.installed != null) {
            this.installed.unsubscribe();
        }
        this.installed = this.events(delay).map(either -> (MouseStationaryEvent)((Object)((Object)either.unify(pos -> MouseStationaryEvent.beginAt(this.node.localToScreen(pos)), stop -> MouseStationaryEvent.end())))).subscribe(evt -> Event.fireEvent((EventTarget)this.node, (Event)evt));
    }

    public void uninstall() {
        if (this.installed != null) {
            this.installed.unsubscribe();
            this.installed = null;
        }
    }
}

