/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.flowless;

import java.util.Optional;
import java.util.function.Function;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.event.Event;
import javafx.scene.Node;
import javafx.scene.input.ScrollEvent;
import org.fxmisc.flowless.Cell;
import org.fxmisc.flowless.CellPool;
import org.reactfx.EventStreams;
import org.reactfx.Subscription;
import org.reactfx.collection.LiveList;
import org.reactfx.collection.MemoizationList;
import org.reactfx.collection.QuasiListModification;

final class CellListManager<T, C extends Cell<T, ? extends Node>> {
    private final Node owner;
    private final CellPool<T, C> cellPool;
    private final MemoizationList<C> cells;
    private final LiveList<C> presentCells;
    private final LiveList<Node> cellNodes;
    private final Subscription presentCellsSubscription;

    public CellListManager(Node owner, ObservableList<T> items, Function<? super T, ? extends C> cellFactory) {
        this.owner = owner;
        this.cellPool = new CellPool<T, C>(cellFactory);
        this.cells = LiveList.map(items, this::cellForItem).memoize();
        this.presentCells = this.cells.memoizedItems();
        this.cellNodes = this.presentCells.map(Cell::getNode);
        this.presentCellsSubscription = this.presentCells.observeQuasiModifications(this::presentCellsChanged);
    }

    public void dispose() {
        this.presentCells.forEach(this.cellPool::acceptCell);
        this.presentCellsSubscription.unsubscribe();
        this.cellPool.dispose();
    }

    public ObservableList<Node> getNodes() {
        return this.cellNodes;
    }

    public MemoizationList<C> getLazyCellList() {
        return this.cells;
    }

    public boolean isCellPresent(int itemIndex) {
        return this.cells.isMemoized(itemIndex);
    }

    public C getPresentCell(int itemIndex) {
        return (C)((Cell)this.cells.getIfMemoized(itemIndex).get());
    }

    public Optional<C> getCellIfPresent(int itemIndex) {
        return this.cells.getIfMemoized(itemIndex);
    }

    public C getCell(int itemIndex) {
        return (C)((Cell)this.cells.get(itemIndex));
    }

    public void cropTo(int fromItem, int toItem) {
        fromItem = Math.max(fromItem, 0);
        toItem = Math.min(toItem, this.cells.size());
        this.cells.forget(0, fromItem);
        this.cells.forget(toItem, this.cells.size());
    }

    private C cellForItem(T item) {
        C cell = this.cellPool.getCell(item);
        Object node = cell.getNode();
        EventStreams.nonNullValuesOf((ObservableValue)node.sceneProperty()).subscribeForOne(scene -> node.applyCss());
        node.setVisible(false);
        if (cell.isReusable()) {
            node.setOnScroll(this::pushScrollEvent);
            node.setOnScrollStarted(this::pushScrollEvent);
            node.setOnScrollFinished(this::pushScrollEvent);
        } else {
            node.addEventHandler(ScrollEvent.ANY, this::pushScrollEvent);
        }
        return cell;
    }

    private void pushScrollEvent(ScrollEvent se) {
        this.owner.fireEvent((Event)se);
        se.consume();
    }

    private void presentCellsChanged(QuasiListModification<? extends C> mod) {
        for (Cell cell : mod.getRemoved()) {
            this.cellPool.acceptCell(cell);
        }
        for (int i = mod.getFrom(); i < this.presentCells.size(); ++i) {
            ((Cell)this.presentCells.get(i)).updateIndex(this.cells.indexOfMemoizedItem(i));
        }
    }
}

