/*
 * Decompiled with CFR 0.152.
 */
package com.lm.hbase.driver;

import com.lm.hbase.common.Env;
import com.lm.hbase.util.network.HttpURLConnectionFactory;
import java.io.File;
import java.net.HttpURLConnection;
import java.util.Collections;
import javax.swing.JLabel;
import org.apache.maven.shared.invoker.DefaultInvocationRequest;
import org.apache.maven.shared.invoker.DefaultInvoker;
import org.apache.maven.shared.invoker.InvocationRequest;
import org.apache.maven.shared.invoker.InvocationResult;
import org.apache.maven.shared.invoker.MavenInvocationException;

public class DownloadDriver {
    private static final String ALIYUN_TAG = "aliyun-";

    private static boolean isAliyun(String version) {
        boolean isAliyun = version.startsWith(ALIYUN_TAG);
        return isAliyun;
    }

    private static String getPomUrl(String version) {
        if (DownloadDriver.isAliyun(version)) {
            String aliyunVersion = version.replace(ALIYUN_TAG, "");
            StringBuilder url = new StringBuilder("http://central.maven.org/maven2/com/aliyun/hbase/alihbase-client");
            url.append("/" + aliyunVersion + "/");
            url.append("alihbase-client-");
            url.append(aliyunVersion);
            url.append(".pom");
            return url.toString();
        }
        StringBuilder url = new StringBuilder("http://central.maven.org/maven2/org/apache/hbase/hbase-client");
        url.append("/" + version + "/");
        url.append("hbase-client-");
        url.append(version);
        url.append(".pom");
        return url.toString();
    }

    private static String getJarUrl(String version) {
        if (DownloadDriver.isAliyun(version)) {
            String aliyunVersion = version.replace(ALIYUN_TAG, "");
            StringBuilder url = new StringBuilder("http://central.maven.org/maven2/com/aliyun/hbase/alihbase-client");
            url.append("/" + aliyunVersion + "/");
            url.append("alihbase-client-");
            url.append(aliyunVersion);
            url.append(".jar");
            return url.toString();
        }
        StringBuilder url = new StringBuilder("http://central.maven.org/maven2/org/apache/hbase/hbase-client");
        url.append("/" + version + "/");
        url.append("hbase-client-");
        url.append(version);
        url.append(".jar");
        return url.toString();
    }

    public static boolean load(String version, String mavenHome, JLabel progressInfoLabel) throws Throwable {
        String outputDir = String.valueOf(Env.DRIVER_DIR) + version;
        File outputFileDir = new File(outputDir);
        if (outputFileDir.exists()) {
            return true;
        }
        outputFileDir.mkdir();
        progressInfoLabel.setText("download pom file ...");
        System.out.println("download pom file to " + outputDir);
        HttpURLConnection con = HttpURLConnectionFactory.getConn(DownloadDriver.getPomUrl(version));
        HttpURLConnectionFactory.downloadFile(con, outputDir, "pom.xml");
        progressInfoLabel.setText("download hbase-client-" + version + ".jar ...");
        con = HttpURLConnectionFactory.getConn(DownloadDriver.getJarUrl(version));
        HttpURLConnectionFactory.downloadFile(con, outputDir, "hbase-client-" + version + ".jar");
        File pomFile = new File(outputDir);
        StringBuilder cmd = new StringBuilder("dependency:copy-dependencies -DoutputDirectory=");
        cmd.append(outputDir);
        progressInfoLabel.setText("download hbase-client dependencies jars  ...");
        boolean result = DownloadDriver.executeMavenCmd(cmd.toString(), pomFile, mavenHome);
        if (result) {
            progressInfoLabel.setText("download hbase-client dependencies jars  success");
        } else {
            progressInfoLabel.setText("download hbase-client dependencies jars  error");
        }
        return result;
    }

    public static boolean executeMavenCmd(String cmd, File pomFile, String mavenHome) {
        System.out.println("download dependency jar." + cmd);
        DefaultInvocationRequest request = new DefaultInvocationRequest();
        request.setPomFile(pomFile);
        request.setGoals(Collections.singletonList(cmd));
        DefaultInvoker invoker = new DefaultInvoker();
        invoker.setMavenHome(new File(mavenHome));
        try {
            InvocationResult result = invoker.execute((InvocationRequest)request);
            if (result.getExitCode() == 0) {
                System.out.println("download dependency jar success");
                return true;
            }
        }
        catch (MavenInvocationException e) {
            e.printStackTrace();
            return false;
        }
        return false;
    }
}

