/*
 * Decompiled with CFR 0.152.
 */
package com.lm.hbase.swing;

import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.FormSpecs;
import com.jgoodies.forms.layout.RowSpec;
import com.lm.hbase.adapter.FilterFactoryInterface;
import com.lm.hbase.adapter.HbaseAdapterInterface;
import com.lm.hbase.common.Env;
import com.lm.hbase.common.ImageIconConstons;
import com.lm.hbase.conf.ConfItem;
import com.lm.hbase.conf.RemoteDriverProp;
import com.lm.hbase.driver.DownloadDriver;
import com.lm.hbase.swing.HandleCore;
import com.lm.hbase.swing.SwingConstants;
import com.lm.hbase.util.DirectoryUtil;
import com.lm.hbase.util.StringUtil;
import com.lm.hbase.util.network.HttpURLConnectionFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ScrollPaneLayout;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.xeustechnologies.jcl.JarClassLoader;
import org.xeustechnologies.jcl.JclObjectFactory;

public class LoginGui
extends JDialog {
    private static final long serialVersionUID = 7686127697988572348L;
    public ScheduledExecutorService threadPool = Executors.newSingleThreadScheduledExecutor();
    private JPanel confsPanel = new JPanel();
    private JList<ConfItem> confsList = new JList();
    private JButton addConfBut = new JButton(ImageIconConstons.ADD_ICON);
    private JButton removeConfBut = new JButton(ImageIconConstons.GARBAGE_ICON);
    private JPanel contentPanel = new JPanel();
    private JTextField confNameField;
    private JTextField zkPortField;
    private JTextField zkQuorumField;
    private JTextField hbaseMasterField;
    private JTextField znodeParentField;
    private JTextField mavenHomeField;
    private JButton testButton = new JButton("Test");
    private JButton cancelButton = new JButton("Close");
    private JButton okButton = new JButton("Connect");
    private JButton reloadDriverVersionButton = new JButton(ImageIconConstons.UPDATE_ICON);
    private JComboBox<String> driverVersionComboBox;
    public JLabel progressInfoLabel = new JLabel("Driver not loaded, please select configure or add and refine configuration");
    public JProgressBar processBar = new JProgressBar();
    public JLabel stopLabel = new JLabel(ImageIconConstons.STOP_ICON);

    public static void openDialog() {
        try {
            if (SwingConstants.loginGui == null) {
                SwingConstants.loginGui = new LoginGui();
            }
            SwingConstants.loginGui.setDefaultCloseOperation(2);
            SwingConstants.loginGui.setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public LoginGui() {
        this.setTitle("\u914d\u7f6eHbase");
        this.setBounds(100, 100, 650, 385);
        this.setMinimumSize(new Dimension(650, 385));
        this.setLocationRelativeTo(null);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.confsPanel, "West");
        this.confsPanel.setLayout(new BorderLayout());
        this.confsList.setBorder(new TitledBorder("\u914d\u7f6e\u5217\u8868"));
        this.confsList.setFixedCellWidth(150);
        this.confsList.getSelectionModel().setSelectionMode(0);
        List<ConfItem> confs = this.getConfItems();
        this.confsList.setListData((ConfItem[])this.getConfItems().toArray(new ConfItem[confs.size()]));
        this.confsList.addListSelectionListener(new ConfListListener());
        JScrollPane jlistScroll = new JScrollPane(this.confsList);
        jlistScroll.setLayout(new ScrollPaneLayout());
        this.confsPanel.add((Component)jlistScroll, "Center");
        JPanel modifyConfPanel = new JPanel();
        this.confsPanel.add((Component)modifyConfPanel, "South");
        this.addConfBut.addMouseListener(new AddConfAdapter());
        this.removeConfBut.addMouseListener(new DeleteConfAdapter());
        modifyConfPanel.add(this.addConfBut);
        modifyConfPanel.add(this.removeConfBut);
        this.getContentPane().add((Component)this.contentPanel, "East");
        this.contentPanel.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormSpecs.RELATED_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.RELATED_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.RELATED_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.RELATED_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.RELATED_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.RELATED_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow"), FormSpecs.RELATED_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.RELATED_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC}, new RowSpec[]{FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC}));
        JLabel lblNewLabel = new JLabel("\u914d\u7f6e\u540d\u79f0");
        this.contentPanel.add((Component)lblNewLabel, "6, 2, right, default");
        this.confNameField = new JTextField(25);
        JPanel componentPanel = new JPanel();
        componentPanel.add(this.confNameField);
        this.contentPanel.add((Component)componentPanel, "10, 2, 5, 1, fill, default");
        lblNewLabel = new JLabel("ZK.PORT");
        lblNewLabel.setToolTipText("hbase.zookeeper.property.clientPort");
        this.contentPanel.add((Component)lblNewLabel, "6, 4, right, default");
        this.zkPortField = new JTextField(25);
        componentPanel = new JPanel();
        componentPanel.add(this.zkPortField);
        this.contentPanel.add((Component)componentPanel, "10, 4, 5, 1, fill, default");
        JLabel lblNewLabel_1 = new JLabel("ZK.QUORUM");
        lblNewLabel_1.setToolTipText("hbase.zookeeper.quorum");
        this.contentPanel.add((Component)lblNewLabel_1, "6, 8, right, default");
        this.zkQuorumField = new JTextField(25);
        componentPanel = new JPanel();
        componentPanel.add(this.zkQuorumField);
        this.contentPanel.add((Component)componentPanel, "10, 8, 5, 1, fill, default");
        JLabel lblNewLabel_2 = new JLabel("HBASE.MASTER");
        lblNewLabel_2.setToolTipText("hbase.master");
        this.contentPanel.add((Component)lblNewLabel_2, "6, 12, right, default");
        this.hbaseMasterField = new JTextField(25);
        componentPanel = new JPanel();
        componentPanel.add(this.hbaseMasterField);
        this.contentPanel.add((Component)componentPanel, "10, 12, 5, 1, fill, default");
        JLabel lblNewLabel_3 = new JLabel("ZNODE.PARENT");
        lblNewLabel_3.setToolTipText("zookeeper.znode.parent");
        this.contentPanel.add((Component)lblNewLabel_3, "6, 14, right, default");
        this.znodeParentField = new JTextField(25);
        componentPanel = new JPanel();
        componentPanel.add(this.znodeParentField);
        this.contentPanel.add((Component)componentPanel, "10, 14, 5, 1, fill, default");
        JLabel lblNewLabel_4 = new JLabel("Maven Home");
        this.contentPanel.add((Component)lblNewLabel_4, "6, 16, right, default");
        this.mavenHomeField = new JTextField(25);
        componentPanel = new JPanel();
        componentPanel.add(this.mavenHomeField);
        this.contentPanel.add((Component)componentPanel, "10, 16, 5, 1, fill, default");
        lblNewLabel_4 = new JLabel("Hbase Version");
        this.contentPanel.add((Component)lblNewLabel_4, "6, 18, right, default");
        this.driverVersionComboBox = new JComboBox();
        this.driverVersionComboBox.addItem("");
        for (String item : RemoteDriverProp.getKeys()) {
            this.driverVersionComboBox.addItem(item);
        }
        this.driverVersionComboBox.addItemListener(new VersionListener());
        this.contentPanel.add(this.driverVersionComboBox, "10, 18, 1, 1, fill, default");
        this.reloadDriverVersionButton.addMouseListener(new ReloadVersion());
        this.contentPanel.add((Component)this.reloadDriverVersionButton, "10, 18, 5, 1, right, default");
        JPanel buttonPane = new JPanel();
        this.contentPanel.add((Component)buttonPane, "6, 20, 13, 1,left, fill");
        buttonPane.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{ColumnSpec.decode((String)"100px"), FormSpecs.DEFAULT_COLSPEC, ColumnSpec.decode((String)"100px"), FormSpecs.DEFAULT_COLSPEC, FormSpecs.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"200px")}, new RowSpec[]{FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC}));
        this.testButton.setEnabled(false);
        this.testButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                LoginGui.this.testButton.setEnabled(false);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (!LoginGui.this.checkConnectParam(LoginGui.this.zkPortField.getText(), LoginGui.this.zkQuorumField.getText(), LoginGui.this.hbaseMasterField.getText(), LoginGui.this.znodeParentField.getText(), LoginGui.this.driverVersionComboBox.getSelectedItem().toString(), LoginGui.this.mavenHomeField.getText())) {
                    LoginGui.this.testButton.setEnabled(true);
                    return;
                }
                LoginGui.this.startTask();
                LoginGui.this.threadPool.execute(new Runnable(){

                    @Override
                    public void run() {
                        block6: {
                            try {
                                try {
                                    String clusterStatus = HandleCore.testConf(LoginGui.this.confNameField.getText(), LoginGui.this.zkPortField.getText(), LoginGui.this.zkQuorumField.getText(), LoginGui.this.hbaseMasterField.getText(), LoginGui.this.znodeParentField.getText(), LoginGui.this.driverVersionComboBox.getSelectedItem().toString(), LoginGui.this.mavenHomeField.getText());
                                    if (clusterStatus != null) {
                                        System.out.println(SwingConstants.hbaseAdapter.getVersion());
                                        JOptionPane.showMessageDialog(LoginGui.this.contentPanel, "\u8fde\u63a5\u6210\u529f,\u96c6\u7fa4\u4fe1\u606f\u5982\u4e0b\n" + clusterStatus, "\u63d0\u793a", 1);
                                        break block6;
                                    }
                                    JOptionPane.showMessageDialog(LoginGui.this.contentPanel, "\u8fde\u63a5\u5931\u8d25", "\u9519\u8bef", 0);
                                }
                                catch (Exception e2) {
                                    JOptionPane.showMessageDialog(LoginGui.this.contentPanel, "\u8fde\u63a5\u5931\u8d25.\n" + e2.getLocalizedMessage(), "\u9519\u8bef", 0);
                                    LoginGui.this.endTask();
                                }
                            }
                            finally {
                                LoginGui.this.endTask();
                            }
                        }
                    }
                });
            }
        });
        buttonPane.add((Component)this.testButton, "1, 2, right, default");
        this.cancelButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (SwingConstants.parentFrameIsInit) {
                    SwingConstants.loginGui.setVisible(false);
                } else {
                    System.exit(0);
                }
            }
        });
        this.cancelButton.setActionCommand("Cancel");
        buttonPane.add((Component)this.cancelButton, "4, 2, right, top");
        this.okButton.setEnabled(false);
        this.okButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                LoginGui.this.okButton.setEnabled(false);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void mouseReleased(MouseEvent e) {
                LoginGui loginGui = SwingConstants.loginGui;
                synchronized (loginGui) {
                    if (!SwingConstants.loginGui.isVisible()) {
                        return;
                    }
                    if (!LoginGui.this.checkConnectParam(LoginGui.this.zkPortField.getText(), LoginGui.this.zkQuorumField.getText(), LoginGui.this.hbaseMasterField.getText(), LoginGui.this.znodeParentField.getText(), LoginGui.this.driverVersionComboBox.getSelectedItem().toString(), LoginGui.this.mavenHomeField.getText())) {
                        LoginGui.this.okButton.setEnabled(true);
                        return;
                    }
                    LoginGui.this.startTask();
                    LoginGui.this.threadPool.execute(new Runnable(){

                        @Override
                        public void run() {
                            block6: {
                                try {
                                    try {
                                        String clusterStatus = HandleCore.testConf(LoginGui.this.confNameField.getText(), LoginGui.this.zkPortField.getText(), LoginGui.this.zkQuorumField.getText(), LoginGui.this.hbaseMasterField.getText(), LoginGui.this.znodeParentField.getText(), LoginGui.this.driverVersionComboBox.getSelectedItem().toString(), LoginGui.this.mavenHomeField.getText());
                                        if (clusterStatus != null) {
                                            SwingConstants.loginGui.setVisible(false);
                                            SwingConstants.hbaseGui.initialize();
                                            break block6;
                                        }
                                        JOptionPane.showMessageDialog(LoginGui.this.contentPanel, "\u8fde\u63a5\u5931\u8d25");
                                    }
                                    catch (Exception e2) {
                                        JOptionPane.showMessageDialog(LoginGui.this.contentPanel, "\u8fde\u63a5\u5931\u8d25.\n" + e2.getLocalizedMessage());
                                        LoginGui.this.endTask();
                                    }
                                }
                                finally {
                                    LoginGui.this.endTask();
                                }
                            }
                        }
                    });
                }
            }
        });
        this.okButton.setActionCommand("OK");
        buttonPane.add((Component)this.okButton, "6, 2, right, top");
        this.getRootPane().setDefaultButton(this.okButton);
        JPanel processPanel = new JPanel();
        processPanel.setLayout(new FlowLayout(0));
        this.stopLabel.addMouseListener(new StopEvent());
        this.stopLabel.setEnabled(false);
        this.stopLabel.setVisible(false);
        this.processBar.setIndeterminate(false);
        this.processBar.setVisible(false);
        processPanel.add(this.stopLabel);
        processPanel.add(this.processBar);
        processPanel.add(this.progressInfoLabel);
        processPanel.add(new JLabel(" "));
        buttonPane.add((Component)processPanel, "1,4,6,1, fill, fill");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                if (SwingConstants.parentFrameIsInit) {
                    SwingConstants.loginGui.setVisible(false);
                } else {
                    super.windowClosed(e);
                    System.exit(0);
                }
            }
        });
    }

    public void asyncLoadDriver(final String version, final boolean reload) {
        this.startTask();
        this.threadPool.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    try {
                        LoginGui.this.loadDriver(version, reload);
                        LoginGui.this.testButton.setEnabled(true);
                        LoginGui.this.okButton.setEnabled(true);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        LoginGui.this.endTask();
                    }
                }
                finally {
                    LoginGui.this.endTask();
                }
            }
        });
    }

    public void loadDriver(String version, boolean reload) {
        if (StringUtil.isEmpty(version)) {
            return;
        }
        JarClassLoader jcl = SwingConstants.driverMap.get(version);
        if (!reload && jcl != null) {
            this.loadCore(jcl);
            return;
        }
        String outputDir = String.valueOf(Env.DRIVER_DIR) + version;
        File outputFileDir = new File(outputDir);
        if (!outputFileDir.exists()) {
            try {
                String mavenHome;
                String string = mavenHome = this.mavenHomeField == null ? null : this.mavenHomeField.getText();
                if (StringUtil.isEmpty(mavenHome) && SwingConstants.selectedConf != null) {
                    mavenHome = SwingConstants.selectedConf.getStringValue("maven.home");
                }
                if (StringUtil.isEmpty(mavenHome)) {
                    JOptionPane.showMessageDialog(this, "\u8bf7\u8bbe\u7f6eMavenHome", "\u9519\u8bef", 0);
                    return;
                }
                DownloadDriver.load(version, mavenHome, this.progressInfoLabel);
            }
            catch (Throwable e1) {
                e1.printStackTrace();
            }
            try {
                this.progressInfoLabel.setText("download adapter jar ....");
                this.loadHbaseAdapterJar(version);
                this.progressInfoLabel.setText("download adapter jar success");
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        } else if (reload) {
            DirectoryUtil.delFolder(outputDir);
            this.loadDriver(version, false);
        }
        this.progressInfoLabel.setText("Classloader load all jars  ....");
        jcl = new JarClassLoader();
        jcl.add(String.valueOf(Env.DRIVER_DIR) + version + "/");
        SwingConstants.driverMap.put(version, jcl);
        SwingConstants.version = version;
        this.progressInfoLabel.setText("The jar necessary for the  " + version + " version is loaded");
        this.loadCore(jcl);
    }

    public void loadCore(JarClassLoader jcl) {
        JclObjectFactory factory = JclObjectFactory.getInstance();
        SwingConstants.hbaseAdapter = (HbaseAdapterInterface)factory.create(jcl, "com.lm.hbase.adapter.HbaseAdapter");
        SwingConstants.filterFactory = (FilterFactoryInterface)factory.create(jcl, "com.lm.hbase.adapter.FilterFactory");
    }

    public void loadHbaseAdapterJar(String version) throws Throwable {
        System.out.print("download adapter jar ....");
        String url = RemoteDriverProp.getStringValue(version);
        String outputDir = String.valueOf(Env.DRIVER_DIR) + version;
        HttpURLConnection con = HttpURLConnectionFactory.getConn(url);
        HttpURLConnectionFactory.downloadFile(con, outputDir, "hbaes-core-adapter-" + version + ".jar");
        System.out.println("ok");
    }

    public boolean checkConnectParam(String zkPort, String zkQuorum, String hbaseMaster, String znodeParent, String version, String mavenHome) {
        if (StringUtil.isEmpty(zkPort)) {
            JOptionPane.showMessageDialog(this, "\u8bf7\u8bbe\u7f6ezkPort", "\u9519\u8bef", 0);
            return false;
        }
        if (StringUtil.isEmpty(zkQuorum)) {
            JOptionPane.showMessageDialog(this, "\u8bf7\u8bbe\u7f6ezkQuorum", "\u9519\u8bef", 0);
            return false;
        }
        if (StringUtil.isEmpty(znodeParent)) {
            JOptionPane.showMessageDialog(this, "\u8bf7\u8bbe\u7f6eznodeParent", "\u9519\u8bef", 0);
            return false;
        }
        if (StringUtil.isEmpty(version)) {
            JOptionPane.showMessageDialog(this, "\u8bf7\u8bbe\u7f6ehbaseVersion", "\u9519\u8bef", 0);
            return false;
        }
        if (StringUtil.isEmpty(mavenHome)) {
            JOptionPane.showMessageDialog(this, "\u8bf7\u8bbe\u7f6emavenHome", "\u9519\u8bef", 0);
            return false;
        }
        return true;
    }

    private void endTask() {
        this.addConfBut.setEnabled(true);
        this.removeConfBut.setEnabled(true);
        this.reloadDriverVersionButton.setEnabled(true);
        this.testButton.setEnabled(true);
        this.cancelButton.setEnabled(true);
        this.okButton.setEnabled(true);
        this.processBar.setIndeterminate(false);
        this.stopLabel.setEnabled(false);
        this.processBar.setVisible(false);
        this.stopLabel.setVisible(false);
    }

    private void startTask() {
        this.addConfBut.setEnabled(false);
        this.removeConfBut.setEnabled(false);
        this.reloadDriverVersionButton.setEnabled(false);
        this.testButton.setEnabled(false);
        this.cancelButton.setEnabled(false);
        this.okButton.setEnabled(false);
        this.processBar.setIndeterminate(true);
        this.processBar.setVisible(true);
        this.stopLabel.setEnabled(true);
        this.stopLabel.setVisible(true);
    }

    private List<ConfItem> getConfItems() {
        ArrayList<ConfItem> confList = new ArrayList<ConfItem>();
        File confDir = new File(Env.CONF_DIR);
        if (!confDir.exists()) {
            confDir.mkdir();
        }
        File[] fileArray = confDir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File item = fileArray[n2];
            if (item.isFile() && item.getName().startsWith("hbase-conf-")) {
                confList.add(new ConfItem(item.getName()));
            }
            ++n2;
        }
        return confList;
    }

    private void cleanConf() {
        this.confNameField.setText("");
        this.zkPortField.setText("");
        this.zkQuorumField.setText("");
        this.hbaseMasterField.setText("");
        this.znodeParentField.setText("");
        this.mavenHomeField.setText("");
    }

    class AddConfAdapter
    extends MouseAdapter {
        AddConfAdapter() {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            LoginGui.this.cleanConf();
            File confDir = new File(Env.CONF_DIR);
            if (!confDir.exists()) {
                confDir.mkdir();
            }
            int i = 1;
            while (i < Integer.MAX_VALUE) {
                File confFile = new File(String.valueOf(Env.CONF_DIR) + "hbase-conf-" + i + ".conf");
                if (!confFile.exists()) {
                    try {
                        DefaultListModel<ConfItem> model = new DefaultListModel<ConfItem>();
                        for (ConfItem confs : LoginGui.this.getConfItems()) {
                            model.addElement(confs);
                        }
                        confFile.createNewFile();
                        model.addElement(new ConfItem(confFile.getName()));
                        LoginGui.this.confsList.setModel(model);
                        LoginGui.this.confsList.updateUI();
                        LoginGui.this.confsList.setSelectedIndex(model.getSize() - 1);
                        return;
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                        return;
                    }
                }
                ++i;
            }
        }
    }

    class ConfListListener
    implements ListSelectionListener {
        ConfListListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                LoginGui.this.cleanConf();
                SwingConstants.selectedConf = (ConfItem)LoginGui.this.confsList.getSelectedValue();
                if (SwingConstants.selectedConf == null) {
                    return;
                }
                String zkPort = SwingConstants.selectedConf.getStringValue("hbase.zk.port");
                String zkQuorum = SwingConstants.selectedConf.getStringValue("hbase.zk.quorum");
                String hbaseMaster = SwingConstants.selectedConf.getStringValue("hbase.master");
                String znodeParent = SwingConstants.selectedConf.getStringValue("znode.parent");
                String hbaseVersion = SwingConstants.selectedConf.getStringValue("hbase.version");
                String mavenHome = SwingConstants.selectedConf.getStringValue("maven.home");
                LoginGui.this.confNameField.setText(SwingConstants.selectedConf.getDisplayName());
                LoginGui.this.zkPortField.setText(zkPort);
                LoginGui.this.zkQuorumField.setText(zkQuorum);
                LoginGui.this.hbaseMasterField.setText(hbaseMaster);
                LoginGui.this.znodeParentField.setText(znodeParent);
                LoginGui.this.mavenHomeField.setText(mavenHome);
                int i = 0;
                while (i < LoginGui.this.driverVersionComboBox.getModel().getSize()) {
                    if (((String)LoginGui.this.driverVersionComboBox.getModel().getElementAt(i)).equalsIgnoreCase(hbaseVersion)) {
                        LoginGui.this.driverVersionComboBox.setSelectedIndex(i);
                        LoginGui.this.asyncLoadDriver(hbaseVersion, false);
                    }
                    ++i;
                }
                LoginGui.this.testButton.setEnabled(false);
                LoginGui.this.okButton.setEnabled(false);
            }
        }
    }

    class DeleteConfAdapter
    extends MouseAdapter {
        DeleteConfAdapter() {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            ConfItem conf = (ConfItem)LoginGui.this.confsList.getSelectedValue();
            File confFile = new File(conf.getConfFilePath());
            confFile.delete();
            SwingConstants.selectedConf = null;
            LoginGui.this.cleanConf();
            List confs = LoginGui.this.getConfItems();
            LoginGui.this.confsList.setListData(LoginGui.this.getConfItems().toArray(new ConfItem[confs.size()]));
            LoginGui.this.testButton.setEnabled(false);
            LoginGui.this.okButton.setEnabled(false);
        }
    }

    class ReloadVersion
    extends MouseAdapter {
        ReloadVersion() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            LoginGui.this.startTask();
            LoginGui.this.reloadDriverVersionButton.setEnabled(false);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (LoginGui.this.reloadDriverVersionButton.isEnabled()) {
                return;
            }
            if (StringUtil.isEmpty(LoginGui.this.mavenHomeField.getText())) {
                JOptionPane.showMessageDialog(LoginGui.this.contentPanel, "\u8bf7\u8bbe\u7f6eMavenHome", "\u9519\u8bef", 0);
                LoginGui.this.endTask();
                return;
            }
            String version = LoginGui.this.driverVersionComboBox.getSelectedItem().toString();
            if (StringUtil.isEmpty(version)) {
                JOptionPane.showMessageDialog(LoginGui.this.contentPanel, "\u8bf7\u8bbe\u7f6ehbaseVersion", "\u9519\u8bef", 0);
                LoginGui.this.reloadDriverVersionButton.setEnabled(true);
                LoginGui.this.endTask();
                return;
            }
            LoginGui.this.asyncLoadDriver(version, true);
        }
    }

    class StopEvent
    extends MouseAdapter {
        StopEvent() {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (!LoginGui.this.threadPool.isShutdown() || !LoginGui.this.threadPool.isTerminated()) {
                LoginGui.this.threadPool.shutdownNow();
                LoginGui.this.threadPool = Executors.newSingleThreadScheduledExecutor();
            }
            LoginGui.this.endTask();
        }
    }

    class VersionListener
    implements ItemListener {
        VersionListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                String version = e.getItem().toString();
                LoginGui.this.asyncLoadDriver(version, false);
            }
        }
    }
}

