/*
 * Decompiled with CFR 0.152.
 */
package com.lm.hbase.tab;

import com.lm.hbase.adapter.ColumnFamilyParam;
import com.lm.hbase.common.ImageIconConstons;
import com.lm.hbase.swing.HbaseGui;
import com.lm.hbase.swing.SwingConstants;
import com.lm.hbase.tab.DefaultValueTextField;
import com.lm.hbase.tab.TabAbstract;
import com.lm.hbase.util.MyBytesUtil;
import com.lm.hbase.util.StringUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ScrollPaneLayout;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class CreateTab
extends TabAbstract {
    private JButton refreshNameSpaceBut;
    private JList<String> nameSpaceList;
    private JLabel addTableNameLabel;
    private DefaultValueTextField addTableNameText;
    private JButton addNameSpaceBut;
    private JTextField addNameSpaceText;
    private JButton createTabBut;
    private JLabel addColumnFamilyLabel;
    private DefaultValueTextField columnFamilyText;
    private DefaultValueTextField maxVersionText;
    private DefaultValueTextField timeLiveText;
    private JLabel addRowkeyScopeLabel;
    private DefaultValueTextField startRowkeyText;
    private DefaultValueTextField endRowkeyText;
    private DefaultValueTextField numRegionsText;
    private JTextArea showTextArea;

    public CreateTab(HbaseGui window) {
        super(window);
    }

    public void refreshCreateTableText() {
        String namespace = this.nameSpaceList.getSelectedValue();
        String table_name = this.addTableNameText.getText();
        String column_family = this.columnFamilyText.getText();
        String maxVersion = this.maxVersionText.getText();
        String timeLive = this.timeLiveText.getText();
        String startRowkey = this.startRowkeyText.getText();
        String endRowkey = this.endRowkeyText.getText();
        String numRegions = this.numRegionsText.getText();
        StringBuilder text = new StringBuilder("------------------\u914d\u7f6e\u4fe1\u606f----------------------\n");
        if (!StringUtil.isEmpty(namespace)) {
            text.append("NameSpace==>" + namespace + "\n");
        }
        if (!StringUtil.isEmpty(table_name)) {
            text.append("TableName==>" + table_name + "\n");
        }
        if (!StringUtil.isEmpty(column_family)) {
            text.append("ColumnFamily==>" + column_family + "\n");
        }
        if (!StringUtil.isEmpty(maxVersion)) {
            text.append("maxVersion==>" + maxVersion + "\n");
        }
        if (!StringUtil.isEmpty(timeLive)) {
            text.append("timeToLive==>" + timeLive + "ms \n");
        }
        if (!(StringUtil.isEmpty(startRowkey) && StringUtil.isEmpty(endRowkey) && StringUtil.isEmpty(numRegions))) {
            text.append("\n------------------\u5206\u533a\u4fe1\u606f----------------------\n");
        }
        if (!StringUtil.isEmpty(startRowkey)) {
            text.append("Start Rowkey==>" + startRowkey + "\n");
        }
        if (!StringUtil.isEmpty(endRowkey)) {
            text.append("End Rowkey==>" + endRowkey + "\n");
        }
        if (!StringUtil.isEmpty(numRegions)) {
            text.append("numRegions==>" + numRegions + "\n");
        }
        this.showTextArea.setText(text.toString());
    }

    @Override
    public String getTitle() {
        return "\u521b\u5efa\u8868";
    }

    @Override
    public JPanel initializePanel() {
        JPanel mainPanel = new JPanel();
        JPanel tableContentPanel = new JPanel();
        JPanel namespacePanel = new JPanel();
        namespacePanel.setToolTipText("asdfads");
        mainPanel.setLayout(new BorderLayout());
        tableContentPanel.setBorder(new EtchedBorder(1, null, null));
        tableContentPanel.setLayout(new BorderLayout());
        namespacePanel.setBorder(new EtchedBorder(1, null, null));
        namespacePanel.setLayout(new BorderLayout(1, 1));
        mainPanel.add((Component)tableContentPanel, "Center");
        mainPanel.add((Component)namespacePanel, "West");
        this.refreshNameSpaceBut = new JButton("\u5237\u65b0", ImageIconConstons.UPDATE_ICON);
        this.refreshNameSpaceBut.addMouseListener(new RefreshNameSpaceAdapter());
        this.nameSpaceList = new JList();
        this.nameSpaceList.setFixedCellHeight(20);
        this.nameSpaceList.setFixedCellWidth(200);
        this.nameSpaceList.getSelectionModel().setSelectionMode(0);
        try {
            this.nameSpaceList.setListData(SwingConstants.hbaseAdapter.listNameSpace());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        JScrollPane nsListScroll = new JScrollPane(this.nameSpaceList);
        nsListScroll.setBorder(new TitledBorder("NAMESPACE"));
        nsListScroll.setLayout(new ScrollPaneLayout());
        JPopupMenu popupMenu = new JPopupMenu();
        popupMenu.setToolTipText("");
        popupMenu.setAlignmentX(0.5f);
        this.addPopup(this.nameSpaceList, popupMenu);
        JMenuItem removeNamespace = new JMenuItem("\u5220\u9664\u547d\u540d\u7a7a\u95f4");
        removeNamespace.addMouseListener(new DelNamespaceAdapter());
        popupMenu.add(removeNamespace);
        this.nameSpaceList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    CreateTab.this.refreshCreateTableText();
                }
            }
        });
        this.addNameSpaceBut = new JButton(ImageIconConstons.ADD_ICON);
        this.addNameSpaceBut.addMouseListener(new AddNameSpaceAdapter());
        this.addNameSpaceText = new JTextField();
        this.addNameSpaceText.addKeyListener(new AddNameSpaceTextKeyAdapter());
        this.addNameSpaceText.setVisible(false);
        namespacePanel.add((Component)this.refreshNameSpaceBut, "North");
        namespacePanel.add((Component)nsListScroll, "Center");
        JPanel namespacePanel_south = new JPanel();
        namespacePanel_south.setLayout(new BorderLayout());
        namespacePanel_south.add((Component)this.addNameSpaceBut, "North");
        namespacePanel_south.add((Component)this.addNameSpaceText, "South");
        namespacePanel.add((Component)namespacePanel_south, "South");
        JPanel tableNorthPanel = new JPanel();
        tableNorthPanel.setBorder(new EtchedBorder(1, null, null));
        tableContentPanel.add((Component)tableNorthPanel, "North");
        tableNorthPanel.setLayout(new FlowLayout(0));
        this.addTableNameLabel = new JLabel(ImageIconConstons.TABLE_ICON);
        this.addTableNameText = new DefaultValueTextField("\u8868\u540d");
        this.addTableNameText.setColumns(8);
        this.addTableNameText.addKeyListener(new EditSettingsAdapter());
        tableNorthPanel.add(this.addTableNameLabel);
        tableNorthPanel.add(this.addTableNameText);
        JSeparator js1 = new JSeparator(1);
        js1.setPreferredSize(new Dimension(js1.getPreferredSize().width, 20));
        tableNorthPanel.add(js1);
        this.addColumnFamilyLabel = new JLabel(ImageIconConstons.SETTINGS_ICON);
        tableNorthPanel.add(this.addColumnFamilyLabel);
        this.columnFamilyText = new DefaultValueTextField("\u5217\u65cf\u540d");
        this.columnFamilyText.setColumns(8);
        this.columnFamilyText.addKeyListener(new EditSettingsAdapter());
        tableNorthPanel.add(this.columnFamilyText);
        this.maxVersionText = new DefaultValueTextField("\u6700\u5927\u7248\u672c");
        this.maxVersionText.setColumns(8);
        this.maxVersionText.addKeyListener(new EditSettingsAdapter());
        tableNorthPanel.add(this.maxVersionText);
        this.timeLiveText = new DefaultValueTextField("\u6570\u636e\u8fc7\u671f\u65f6\u95f4ms");
        this.timeLiveText.setColumns(10);
        this.timeLiveText.addKeyListener(new EditSettingsAdapter());
        tableNorthPanel.add(this.timeLiveText);
        JSeparator js2 = new JSeparator(1);
        js2.setPreferredSize(new Dimension(js2.getPreferredSize().width, 20));
        tableNorthPanel.add(js2);
        this.addRowkeyScopeLabel = new JLabel(ImageIconConstons.SHARING_ICON);
        this.startRowkeyText = new DefaultValueTextField("start rowKey");
        this.startRowkeyText.addKeyListener(new EditSettingsAdapter());
        this.startRowkeyText.setColumns(8);
        this.endRowkeyText = new DefaultValueTextField("end rowKey");
        this.endRowkeyText.addKeyListener(new EditSettingsAdapter());
        this.endRowkeyText.setColumns(8);
        this.numRegionsText = new DefaultValueTextField("num regions");
        this.numRegionsText.addKeyListener(new EditSettingsAdapter());
        this.numRegionsText.setColumns(8);
        tableNorthPanel.add(this.addRowkeyScopeLabel);
        tableNorthPanel.add(this.startRowkeyText);
        tableNorthPanel.add(this.endRowkeyText);
        tableNorthPanel.add(this.numRegionsText);
        JPanel tableCenterPanel = new JPanel();
        tableCenterPanel.setBorder(new EtchedBorder(1, null, null));
        tableContentPanel.add((Component)tableCenterPanel, "Center");
        tableCenterPanel.setLayout(new BoxLayout(tableCenterPanel, 1));
        this.showTextArea = new JTextArea();
        this.showTextArea.setColumns(20);
        this.showTextArea.setRows(10);
        tableCenterPanel.add(this.showTextArea);
        JPanel tableSouthPanel = new JPanel();
        tableSouthPanel.setBorder(new EtchedBorder(1, null, null));
        tableContentPanel.add((Component)tableSouthPanel, "South");
        this.createTabBut = new JButton("\u521b\u5efa", ImageIconConstons.NEW_ICON);
        tableSouthPanel.add(this.createTabBut);
        this.createTabBut.addMouseListener(new CreateTable());
        return mainPanel;
    }

    @Override
    public void enableAll() {
        this.createTabBut.setEnabled(true);
        this.refreshNameSpaceBut.setEnabled(true);
        this.addColumnFamilyLabel.setEnabled(true);
        this.addNameSpaceBut.setEnabled(true);
    }

    @Override
    public void disableAll() {
        this.createTabBut.setEnabled(false);
        this.refreshNameSpaceBut.setEnabled(false);
        this.addColumnFamilyLabel.setEnabled(false);
        this.addNameSpaceBut.setEnabled(false);
    }

    class AddNameSpaceAdapter
    extends MouseAdapter {
        AddNameSpaceAdapter() {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            CreateTab.this.addNameSpaceBut.setVisible(false);
            CreateTab.this.addNameSpaceText.setVisible(true);
            CreateTab.this.addNameSpaceText.grabFocus();
        }
    }

    class AddNameSpaceTextKeyAdapter
    extends KeyAdapter {
        AddNameSpaceTextKeyAdapter() {
        }

        @Override
        public void keyReleased(KeyEvent e) {
            if (e.getKeyCode() == 10) {
                final String input = CreateTab.this.addNameSpaceText.getText();
                if (!StringUtil.isEmpty(input.trim())) {
                    CreateTab.this.getSingleThreadPool().execute(new Runnable(){

                        @Override
                        public void run() {
                            CreateTab.this.startTask();
                            try {
                                try {
                                    SwingConstants.hbaseAdapter.createNameSpace(input.trim());
                                    CreateTab.this.nameSpaceList.setListData(SwingConstants.hbaseAdapter.listNameSpace());
                                    JOptionPane.showMessageDialog(((AddNameSpaceTextKeyAdapter)AddNameSpaceTextKeyAdapter.this).CreateTab.this.window.parentJframe, "\u6dfb\u52a0\u547d\u540d\u7a7a\u95f4\u6210\u529f", "\u6210\u529f", 1);
                                }
                                catch (Exception e1) {
                                    CreateTab.this.exceptionAlert(e1);
                                    CreateTab.this.addNameSpaceBut.setVisible(true);
                                    CreateTab.this.addNameSpaceText.setVisible(false);
                                    return;
                                }
                            }
                            finally {
                                CreateTab.this.addNameSpaceBut.setVisible(true);
                                CreateTab.this.addNameSpaceText.setVisible(false);
                            }
                            CreateTab.this.stopTask();
                        }
                    });
                } else {
                    JOptionPane.showMessageDialog(CreateTab.this.window.parentJframe, "\u8bf7\u8f93\u5165\u547d\u540d\u7a7a\u95f4\u540d\u79f0", "\u5f02\u5e38", 0);
                }
            } else if (e.getKeyCode() == 27) {
                CreateTab.this.addNameSpaceBut.setVisible(true);
                CreateTab.this.addNameSpaceText.setVisible(false);
            }
        }
    }

    class CreateTable
    extends MouseAdapter {
        CreateTable() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            CreateTab.this.createTabBut.setEnabled(false);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            final String namespace = (String)CreateTab.this.nameSpaceList.getSelectedValue();
            final String table_name = CreateTab.this.addTableNameText.getText();
            final String column_family = CreateTab.this.columnFamilyText.getText();
            final String startRowkey = CreateTab.this.startRowkeyText.getText();
            final String endRowkey = CreateTab.this.endRowkeyText.getText();
            final String numRegions = CreateTab.this.numRegionsText.getText();
            final String maxVersion = CreateTab.this.maxVersionText.getText();
            final String timeLive = CreateTab.this.timeLiveText.getText();
            if (StringUtil.isEmpty(namespace)) {
                JOptionPane.showMessageDialog(CreateTab.this.getFrame(), "\u8bf7\u9009\u62e9\u547d\u540d\u7a7a\u95f4", "\u8b66\u544a", 2);
                CreateTab.this.createTabBut.setEnabled(true);
                return;
            }
            if (StringUtil.isEmpty(table_name)) {
                JOptionPane.showMessageDialog(CreateTab.this.getFrame(), "\u8bf7\u8f93\u5165\u8868\u540d", "\u8b66\u544a", 2);
                CreateTab.this.createTabBut.setEnabled(true);
                return;
            }
            if (StringUtil.isEmpty(column_family)) {
                JOptionPane.showMessageDialog(CreateTab.this.getFrame(), "\u8bf7\u8f93\u5165\u81f3\u5c11\u4e00\u4e2a\u5217\u65cf", "\u8b66\u544a", 2);
                CreateTab.this.createTabBut.setEnabled(true);
                return;
            }
            if (!(StringUtil.isEmpty(startRowkey) && StringUtil.isEmpty(endRowkey) && StringUtil.isEmpty(numRegions) || !StringUtil.isEmpty(startRowkey) && !StringUtil.isEmpty(endRowkey) && !StringUtil.isEmpty(numRegions))) {
                JOptionPane.showMessageDialog(CreateTab.this.getFrame(), "\u5206\u533a\u4fe1\u606f\u4e0d\u5b8c\u6574", "\u8b66\u544a", 2);
                CreateTab.this.createTabBut.setEnabled(true);
                return;
            }
            CreateTab.this.startTask();
            CreateTab.this.getSingleThreadPool().execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (!(StringUtil.isEmpty(startRowkey) || StringUtil.isEmpty(endRowkey) || StringUtil.isEmpty(numRegions))) {
                            ColumnFamilyParam columnFamilyParam = new ColumnFamilyParam();
                            columnFamilyParam.put((Object)ColumnFamilyParam.ColumnFamilyFieldEnum.COLUMN_FAMILY_NAME, (Object)column_family);
                            if (StringUtil.isEmpty(maxVersion)) {
                                columnFamilyParam.put((Object)ColumnFamilyParam.ColumnFamilyFieldEnum.MAX_VERSION, (Object)maxVersion);
                            }
                            if (StringUtil.isEmpty(timeLive)) {
                                columnFamilyParam.put((Object)ColumnFamilyParam.ColumnFamilyFieldEnum.TIME_TO_LIVE, (Object)timeLive);
                            }
                            SwingConstants.hbaseAdapter.createTable(String.valueOf(namespace) + ":" + table_name, null, MyBytesUtil.toBytes(startRowkey), MyBytesUtil.toBytes(endRowkey), Integer.parseInt(numRegions), new ColumnFamilyParam[]{columnFamilyParam});
                        } else {
                            SwingConstants.hbaseAdapter.createTable(String.valueOf(namespace) + ":" + table_name, new String[]{column_family});
                        }
                        JOptionPane.showMessageDialog(CreateTab.this.getFrame(), "\u6210\u529f", "\u63d0\u793a", 1);
                    }
                    catch (Exception e2) {
                        JOptionPane.showMessageDialog(CreateTab.this.getFrame(), e2.getMessage(), "\u9519\u8bef", 0);
                    }
                    CreateTab.this.stopTask();
                }
            });
        }
    }

    class DelNamespaceAdapter
    extends MouseAdapter {
        DelNamespaceAdapter() {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            final String namespace = (String)CreateTab.this.nameSpaceList.getSelectedValue();
            if (JOptionPane.showConfirmDialog(CreateTab.this.getFrame(), "\u786e\u5b9a\u547d\u540d\u7a7a\u95f4" + namespace + "\u5417?") == 0) {
                CreateTab.this.getSingleThreadPool().execute(new Runnable(){

                    @Override
                    public void run() {
                        CreateTab.this.startTask();
                        try {
                            SwingConstants.hbaseAdapter.deleteNameSpace(namespace);
                            CreateTab.this.nameSpaceList.setListData(SwingConstants.hbaseAdapter.listNameSpace());
                            CreateTab.this.nameSpaceList.setSelectedIndex(-1);
                            CreateTab.this.refreshCreateTableText();
                        }
                        catch (Exception e) {
                            CreateTab.this.exceptionAlert(e);
                            return;
                        }
                        CreateTab.this.stopTask();
                    }
                });
            }
        }
    }

    class EditSettingsAdapter
    extends KeyAdapter {
        EditSettingsAdapter() {
        }

        @Override
        public void keyReleased(KeyEvent e) {
            CreateTab.this.refreshCreateTableText();
        }
    }

    class RefreshNameSpaceAdapter
    extends MouseAdapter {
        RefreshNameSpaceAdapter() {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            CreateTab.this.getSingleThreadPool().execute(new Runnable(){

                @Override
                public void run() {
                    CreateTab.this.startTask();
                    try {
                        CreateTab.this.nameSpaceList.setListData(SwingConstants.hbaseAdapter.listNameSpace());
                    }
                    catch (Exception e1) {
                        CreateTab.this.exceptionAlert(e1);
                        return;
                    }
                    CreateTab.this.stopTask();
                }
            });
        }
    }
}

