/*
 * Decompiled with CFR 0.152.
 */
package com.lm.hbase.adapter;

import com.lm.hbase.adapter.QualifierColumn;
import com.lm.hbase.adapter.entity.QualifierValue;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class ColumnFamily {
    private LinkedHashMap<byte[], QualifierValue> columns = new LinkedHashMap();
    private String familyName;
    private byte[] familyNameBytes;
    private int cursor = 0;
    private QualifierColumn qualifierColumn = null;

    public ColumnFamily(byte[] familyNameBytes) {
        this.familyName = new String(familyNameBytes, 0, familyNameBytes.length, Charset.forName("UTF-8"));
        this.familyNameBytes = familyNameBytes;
    }

    public QualifierValue get() {
        return this.columns.get(null);
    }

    public QualifierValue get(byte[] qualifier) {
        return this.columns.get(qualifier);
    }

    public void add(byte[] qualifier, QualifierValue value) {
        if (qualifier == null || qualifier.length == 0) {
            qualifier = null;
        }
        this.columns.put(qualifier, value);
    }

    public int hasNext() {
        Iterator<Map.Entry<byte[], QualifierValue>> iterator = this.columns.entrySet().iterator();
        int index = 0;
        while (iterator.hasNext()) {
            Map.Entry<byte[], QualifierValue> entry = iterator.next();
            if (index == this.cursor) {
                this.qualifierColumn = new QualifierColumn(entry.getKey() == null ? null : entry.getKey(), entry.getValue() == null ? null : entry.getValue().getQualifier());
                ++this.cursor;
                return 1;
            }
            ++index;
        }
        this.qualifierColumn = null;
        return -1;
    }

    public Map.Entry<String, QualifierColumn> next() {
        return new Map.Entry<String, QualifierColumn>(){

            @Override
            public QualifierColumn setValue(QualifierColumn value) {
                return null;
            }

            @Override
            public QualifierColumn getValue() {
                return ColumnFamily.this.qualifierColumn;
            }

            @Override
            public String getKey() {
                return ColumnFamily.this.familyName;
            }
        };
    }

    public Map<byte[], QualifierValue> getColumns() {
        return this.columns;
    }

    public String getFamilyName() {
        return this.familyName;
    }

    public byte[] getFamilyNameBytes() {
        return this.familyNameBytes;
    }

    public String toString() {
        StringBuilder rowString = new StringBuilder();
        for (Map.Entry<byte[], QualifierValue> entry : this.columns.entrySet()) {
            rowString.append("{" + (entry.getKey() == null ? "NULL" : new String(entry.getKey(), 0, entry.getKey().length, Charset.forName("UTF-8"))) + ":" + (entry.getValue() == null ? "NULL" : entry.getValue().getDisplayValue()) + "}");
        }
        return rowString.toString();
    }
}

