/*
 * Decompiled with CFR 0.152.
 */
package com.bulenkov.darcula.ui;

import com.bulenkov.darcula.DarculaUIUtil;
import com.bulenkov.darcula.ui.DarculaMenuItemUIBase;
import com.bulenkov.iconloader.util.EmptyIcon;
import com.bulenkov.iconloader.util.GraphicsConfig;
import com.bulenkov.iconloader.util.Gray;
import com.bulenkov.iconloader.util.UIUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.IconUIResource;
import sun.swing.MenuItemLayoutHelper;

public class DarculaCheckBoxMenuItemUI
extends DarculaMenuItemUIBase {
    public static ComponentUI createUI(JComponent c) {
        return new DarculaCheckBoxMenuItemUI();
    }

    @Override
    protected String getPropertyPrefix() {
        return "CheckBoxMenuItem";
    }

    @Override
    protected void paintMenuItem(Graphics g, JComponent c, Icon checkIcon, Icon arrowIcon, Color background, Color foreground, int defaultTextIconGap) {
        super.paintMenuItem(g, c, new IconUIResource(EmptyIcon.create((int)((float)(14 * DarculaUIUtil.getScaleFactor()) + 0.5f))), arrowIcon, background, foreground, defaultTextIconGap);
    }

    @Override
    protected void paintCheckIcon(Graphics g2, MenuItemLayoutHelper lh, MenuItemLayoutHelper.LayoutResult lr, Color holdc, Color foreground) {
        Graphics2D g = (Graphics2D)g2;
        GraphicsConfig config = new GraphicsConfig(g);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_DEFAULT);
        g.translate(lr.getCheckRect().x + 2, lr.getCheckRect().y + 2);
        int scaleFactor = DarculaUIUtil.getScaleFactor();
        int sz = 13 * scaleFactor;
        g.setPaint(new GradientPaint(sz / 2, 1.0f, Gray._110, sz / 2, sz, Gray._95));
        g.fillRoundRect(0, 0, sz, sz - 1, 4 * scaleFactor, 4 * scaleFactor);
        g.setPaint(new GradientPaint(sz / 2, 1.0f, Gray._120.withAlpha(90), sz / 2, sz, Gray._105.withAlpha(90)));
        g.drawRoundRect(0, UIUtil.isUnderDarcula() ? 1 : 0, sz, sz - 1, 4 * scaleFactor, 4 * scaleFactor);
        g.setPaint(Gray._40.withAlpha(180));
        g.drawRoundRect(0, 0, sz, sz - 1, 4 * scaleFactor, 4 * scaleFactor);
        if (lh.getMenuItem().isSelected()) {
            g.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
            g.setStroke(new BasicStroke(2.0f * (float)scaleFactor, 1, 1));
            g.setPaint(Gray._30);
            g.drawLine(4 * scaleFactor, 7 * scaleFactor, 7 * scaleFactor, 10 * scaleFactor);
            g.drawLine(7 * scaleFactor, 10 * scaleFactor, sz, 2 * scaleFactor);
            g.setPaint(Gray._170);
            g.drawLine(4 * scaleFactor, 5 * scaleFactor, 7 * scaleFactor, 8 * scaleFactor);
            g.drawLine(7 * scaleFactor, 8 * scaleFactor, sz, 0);
        }
        g.translate(-lr.getCheckRect().x - 2, -lr.getCheckRect().y - 2);
        config.restore();
        g.setColor(foreground);
    }
}

