/*
 * Decompiled with CFR 0.152.
 */
package com.bulenkov.darcula.ui;

import com.bulenkov.darcula.DarculaUIUtil;
import com.bulenkov.iconloader.util.DoubleColor;
import com.bulenkov.iconloader.util.GraphicsConfig;
import com.bulenkov.iconloader.util.GraphicsUtil;
import com.bulenkov.iconloader.util.Gray;
import com.bulenkov.iconloader.util.UIUtil;
import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.geom.Area;
import java.awt.geom.RoundRectangle2D;
import javax.swing.JFormattedTextField;
import javax.swing.JSpinner;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.plaf.UIResource;

public class DarculaSpinnerBorder
implements Border,
UIResource {
    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        JSpinner spinner = (JSpinner)c;
        JFormattedTextField editor = UIUtil.findComponentOfType(spinner, JFormattedTextField.class);
        int scaleFactor = DarculaUIUtil.getScaleFactor();
        int x1 = x + 1 * scaleFactor;
        int y1 = y + 3 * scaleFactor;
        int width1 = width - 2 * scaleFactor;
        int height1 = height - 6 * scaleFactor;
        boolean focused = c.isEnabled() && c.isVisible() && editor != null && editor.hasFocus();
        GraphicsConfig config = GraphicsUtil.setupAAPainting(g);
        if (c.isOpaque()) {
            g.setColor(UIUtil.getPanelBackground());
            g.fillRect(x, y, width, height);
        }
        g.setColor(UIUtil.getTextFieldBackground());
        g.fillRoundRect(x1, y1, width1, height1, 5 * scaleFactor, 5 * scaleFactor);
        g.setColor(UIManager.getColor(spinner.isEnabled() ? "Spinner.darcula.enabledButtonColor" : "Spinner.darcula.disabledButtonColor"));
        if (editor != null) {
            int off = editor.getBounds().x + editor.getWidth() + ((JSpinner)c).getInsets().left + 1 * scaleFactor;
            Area rect = new Area(new RoundRectangle2D.Double(x1, y1, width1, height1, 5 * scaleFactor, 5 * scaleFactor));
            Area blueRect = new Area(new Rectangle(off, y1, 22 * scaleFactor, height1));
            rect.intersect(blueRect);
            ((Graphics2D)g).fill(rect);
            if (UIUtil.isUnderDarcula()) {
                g.setColor(Gray._100);
                g.drawLine(off, y1, off, height1 + 2 * scaleFactor);
            }
        }
        if (!c.isEnabled()) {
            ((Graphics2D)g).setComposite(AlphaComposite.getInstance(3, 0.4f));
        }
        if (focused) {
            DarculaUIUtil.paintFocusRing(g, x1 + 2 * scaleFactor, y1, width1 - 3 * scaleFactor, height1);
        } else {
            g.setColor(new DoubleColor(Gray._149, Gray._100));
            g.drawRoundRect(x1, y1, width1, height1, 5 * scaleFactor, 5 * scaleFactor);
        }
        config.restore();
    }

    @Override
    public Insets getBorderInsets(Component c) {
        int scaleFactor = DarculaUIUtil.getScaleFactor();
        return new InsetsUIResource(5 * scaleFactor, 7 * scaleFactor, 5 * scaleFactor, 7 * scaleFactor);
    }

    @Override
    public boolean isBorderOpaque() {
        return true;
    }
}

