/*
 * Decompiled with CFR 0.152.
 */
package com.bulenkov.darcula.ui;

import com.bulenkov.darcula.DarculaUIUtil;
import com.bulenkov.darcula.ui.DarculaMenuItemUIBase;
import com.bulenkov.iconloader.util.ColorUtil;
import com.bulenkov.iconloader.util.EmptyIcon;
import com.bulenkov.iconloader.util.GraphicsConfig;
import com.bulenkov.iconloader.util.Gray;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.IconUIResource;
import sun.swing.MenuItemLayoutHelper;

public class DarculaRadioButtonMenuItemUI
extends DarculaMenuItemUIBase {
    public static ComponentUI createUI(JComponent c) {
        return new DarculaRadioButtonMenuItemUI();
    }

    @Override
    protected String getPropertyPrefix() {
        return "RadioButtonMenuItem";
    }

    @Override
    protected void paintMenuItem(Graphics g, JComponent c, Icon checkIcon, Icon arrowIcon, Color background, Color foreground, int defaultTextIconGap) {
        super.paintMenuItem(g, c, new IconUIResource(EmptyIcon.create((int)((float)(14 * DarculaUIUtil.getScaleFactor()) + 0.5f))), arrowIcon, background, foreground, defaultTextIconGap);
    }

    @Override
    protected void paintCheckIcon(Graphics g2, MenuItemLayoutHelper lh, MenuItemLayoutHelper.LayoutResult lr, Color holdc, Color foreground) {
        Graphics2D g = (Graphics2D)g2;
        GraphicsConfig config = new GraphicsConfig(g);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_DEFAULT);
        g.translate(lr.getCheckRect().x + 1, lr.getCheckRect().y + 1);
        int scaleFactor = DarculaUIUtil.getScaleFactor();
        int rad = 5 * scaleFactor;
        boolean x = false;
        boolean y = false;
        int w = 13 * scaleFactor;
        int h = 13 * scaleFactor;
        g.translate(0, 0);
        Color bg = lh.getMenuItem().getBackground();
        g.setPaint(new GradientPaint(0.0f, 0.0f, ColorUtil.shift(bg, 1.5), 0.0f, 16.0f, ColorUtil.shift(bg, 1.2)));
        g.fillOval(0, 1, w - 1, h - 1);
        g.setPaint(new GradientPaint(w / 2, 1.0f, Gray._160.withAlpha(90), w / 2, h, Gray._100.withAlpha(90)));
        g.drawOval(0, 2, w - 1, h - 1);
        g.setPaint(Gray._40.withAlpha(200));
        g.drawOval(0, 1, w - 1, h - 1);
        if (lh.getMenuItem().isSelected()) {
            boolean enabled = lh.getMenuItem().isEnabled();
            g.setColor(UIManager.getColor(enabled ? "RadioButton.darcula.selectionEnabledShadowColor" : "RadioButton.darcula.selectionDisabledShadowColor"));
            g.fillOval((w - rad) / 2, h / 2 - rad / 2 + 1, rad, rad);
            g.setColor(UIManager.getColor(enabled ? "RadioButton.darcula.selectionEnabledColor" : "RadioButton.darcula.selectionDisabledColor"));
            g.fillOval((w - rad) / 2, h / 2 - rad / 2, rad, rad);
        }
        config.restore();
        g.translate(0, 0);
        g.translate(-lr.getCheckRect().x - 1, -lr.getCheckRect().y - 1);
        config.restore();
    }
}

