/*
 * Decompiled with CFR 0.152.
 */
package com.lm.hbase.tab;

import com.alibaba.fastjson.JSON;
import com.lm.hbase.adapter.entity.HBasePageModel;
import com.lm.hbase.adapter.entity.HbaseQualifier;
import com.lm.hbase.common.ImageIconConstons;
import com.lm.hbase.swing.HandleCore;
import com.lm.hbase.swing.HbaseGui;
import com.lm.hbase.swing.SwingConstants;
import com.lm.hbase.tab.DefaultValueTextField;
import com.lm.hbase.tab.TabAbstract;
import com.lm.hbase.util.Chooser;
import com.lm.hbase.util.DateUtil;
import com.lm.hbase.util.MyBytesUtil;
import com.lm.hbase.util.StringUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ScrollPaneLayout;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;

public class QueryTab
extends TabAbstract {
    private static final byte[] COMBOBOX_DEFAULT_VALUE = "--".getBytes();
    private JList<String> list = null;
    private JButton refreshTableButton;
    private JButton searchButton = new JButton("\u67e5\u8be2", ImageIconConstons.SEARCH_ICON);
    private JButton deleteButton;
    private DefaultValueTextField textField_start_rowkey;
    private DefaultValueTextField textField_end_rowkey;
    private JTextField textField_version;
    private JTextField textField_pageSize;
    private DefaultValueTextField textField_rowKey_prefix;
    private JButton nextpage_button;
    private JTable contentTable;
    private JScrollPane tableScroll;
    private JTextField textField_min_stamp;
    private JTextField textField_max_stamp;
    private JLabel bottom_message_label;
    private JComboBox<HbaseQualifier> fieldsComboBox;
    private JComboBox<String> fieldTypeComboBox;
    private JComboBox<String> comparatorComboBox;
    private JComboBox<String> filterOperatorComboBox;
    private JTextField filterValueTextField;
    private static HBasePageModel pageModel;

    public QueryTab(HbaseGui window) {
        super(window);
    }

    @Override
    public String getTitle() {
        return "\u67e5\u8be2";
    }

    @Override
    public JPanel initializePanel() {
        JPanel select = new JPanel();
        select.setLayout(new BorderLayout(0, 0));
        JPanel tableListPanel = new JPanel();
        tableListPanel.setBorder(new EtchedBorder(1, null, null));
        tableListPanel.setLayout(new BorderLayout(1, 1));
        select.add((Component)tableListPanel, "West");
        this.list = new JList();
        this.list.setFixedCellHeight(20);
        this.list.getSelectionModel().setSelectionMode(0);
        JScrollPane jlistScroll = new JScrollPane(this.list);
        jlistScroll.setBorder(new TitledBorder("TABLES"));
        jlistScroll.setLayout(new ScrollPaneLayout());
        tableListPanel.add(jlistScroll);
        JPopupMenu popupMenu = new JPopupMenu();
        popupMenu.setToolTipText("");
        popupMenu.setAlignmentX(0.5f);
        this.addPopup(this.list, popupMenu);
        JMenuItem removeTableItem = new JMenuItem("\u5220\u9664\u8868");
        popupMenu.add(removeTableItem);
        JMenuItem truncateTableItem = new JMenuItem("\u6e05\u7a7a\u8868");
        popupMenu.add(truncateTableItem);
        popupMenu.addSeparator();
        JMenuItem countItem = new JMenuItem("\u7edf\u8ba1\u603b\u6570");
        popupMenu.add(countItem);
        this.refreshTableButton = new JButton("\u5237\u65b0", ImageIconConstons.UPDATE_ICON);
        tableListPanel.add((Component)this.refreshTableButton, "North");
        JPanel searchPanel = new JPanel();
        searchPanel.setBorder(new EtchedBorder(1, null, null));
        select.add((Component)searchPanel, "Center");
        searchPanel.setLayout(new BorderLayout(0, 0));
        JPanel filtersPanel = new JPanel();
        filtersPanel.setBorder(new EtchedBorder(1, null, null));
        searchPanel.add((Component)filtersPanel, "North");
        filtersPanel.setLayout(new BorderLayout(0, 0));
        this.deleteButton = new JButton("\u5220\u9664", ImageIconConstons.GARBAGE_ICON);
        this.deleteButton.setEnabled(false);
        this.deleteButton.addMouseListener(new DeleteEvent());
        filtersPanel.add((Component)this.deleteButton, "West");
        JPanel filterNorthPanel = new JPanel();
        filtersPanel.add((Component)filterNorthPanel, "Center");
        filterNorthPanel.setLayout(new BorderLayout());
        JPanel filterNorthPanel_center = new JPanel();
        filterNorthPanel.add((Component)filterNorthPanel_center, "Center");
        JLabel filterLabel = new JLabel(ImageIconConstons.OPTION_ICON);
        filterNorthPanel_center.add(filterLabel);
        this.textField_start_rowkey = new DefaultValueTextField("start rowkey");
        filterNorthPanel_center.add(this.textField_start_rowkey);
        this.textField_start_rowkey.setColumns(10);
        this.textField_end_rowkey = new DefaultValueTextField("end rowkey");
        filterNorthPanel_center.add(this.textField_end_rowkey);
        this.textField_end_rowkey.setColumns(10);
        this.textField_rowKey_prefix = new DefaultValueTextField("Rowkey\u524d\u7f00");
        filterNorthPanel_center.add(this.textField_rowKey_prefix);
        this.textField_rowKey_prefix.setColumns(10);
        JSeparator js1 = new JSeparator(1);
        js1.setPreferredSize(new Dimension(js1.getPreferredSize().width, 20));
        filterNorthPanel_center.add(js1);
        JLabel versionLabel = new JLabel("\u7248\u672c\u53f7:");
        filterNorthPanel_center.add(versionLabel);
        this.textField_version = new JTextField();
        filterNorthPanel_center.add(this.textField_version);
        this.textField_version.setColumns(2);
        this.textField_version.setText("1");
        JLabel label_1 = new JLabel(ImageIconConstons.PAGE_ICON);
        filterNorthPanel_center.add(label_1);
        this.textField_pageSize = new JTextField();
        this.textField_pageSize.setText("10");
        filterNorthPanel_center.add(this.textField_pageSize);
        this.textField_pageSize.setColumns(3);
        JSeparator js2 = new JSeparator(1);
        js2.setPreferredSize(new Dimension(js2.getPreferredSize().width, 20));
        filterNorthPanel_center.add(js2);
        JLabel timeScopeLabel = new JLabel(ImageIconConstons.CALENDAR_ICON);
        filterNorthPanel_center.add(timeScopeLabel);
        this.textField_min_stamp = new JTextField();
        Chooser.getInstance().register(this.textField_min_stamp);
        filterNorthPanel_center.add(this.textField_min_stamp);
        this.textField_min_stamp.setColumns(10);
        this.textField_max_stamp = new JTextField();
        Chooser.getInstance().register(this.textField_max_stamp);
        filterNorthPanel_center.add(this.textField_max_stamp);
        this.textField_max_stamp.setColumns(10);
        this.searchButton.addMouseListener(new SelectEvent());
        filterNorthPanel.add((Component)this.searchButton, "East");
        JPanel filterSouthPanel = new JPanel();
        filterSouthPanel.setLayout(new BorderLayout(0, 0));
        filtersPanel.add((Component)filterSouthPanel, "South");
        JPanel itemFilterWestPanel = new JPanel();
        itemFilterWestPanel.setLayout(new FlowLayout());
        filterSouthPanel.add((Component)itemFilterWestPanel, "West");
        this.fieldsComboBox = new JComboBox();
        this.fieldsComboBox.addItem(new HbaseQualifier(COMBOBOX_DEFAULT_VALUE, COMBOBOX_DEFAULT_VALUE, "--"));
        this.fieldsComboBox.setEditable(true);
        itemFilterWestPanel.add(this.fieldsComboBox);
        this.fieldTypeComboBox = new JComboBox();
        this.fieldTypeComboBox.addItem("String");
        this.fieldTypeComboBox.addItem("Int");
        this.fieldTypeComboBox.addItem("Short");
        this.fieldTypeComboBox.addItem("Long");
        this.fieldTypeComboBox.addItem("Float");
        this.fieldTypeComboBox.addItem("Double");
        this.fieldTypeComboBox.addItem("BigDecimal");
        itemFilterWestPanel.add(this.fieldTypeComboBox);
        this.filterOperatorComboBox = new JComboBox();
        for (String item : SwingConstants.filterFactory.getCompareOpSimpleList()) {
            this.filterOperatorComboBox.addItem(item);
        }
        itemFilterWestPanel.add(this.filterOperatorComboBox);
        this.comparatorComboBox = new JComboBox();
        for (Class f : SwingConstants.filterFactory.getAllComparatorClass()) {
            this.comparatorComboBox.addItem(f.getSimpleName());
        }
        itemFilterWestPanel.add(this.comparatorComboBox);
        this.filterValueTextField = new JTextField();
        filterSouthPanel.add((Component)this.filterValueTextField, "Center");
        JPanel searchSouthPanel = new JPanel();
        searchSouthPanel.setBorder(new EtchedBorder(1, null, null));
        searchPanel.add((Component)searchSouthPanel, "South");
        searchSouthPanel.setLayout(new BorderLayout(0, 0));
        this.bottom_message_label = new JLabel("");
        this.bottom_message_label.setHorizontalAlignment(0);
        searchSouthPanel.add((Component)this.bottom_message_label, "Center");
        this.nextpage_button = new JButton("\u52a0\u8f7d\u4e0b\u4e00\u9875", ImageIconConstons.NEXT_ICON);
        this.nextpage_button.addMouseListener(new NextPage());
        searchSouthPanel.add((Component)this.nextpage_button, "East");
        this.contentTable = new JTable();
        this.tableScroll = new JScrollPane(this.contentTable);
        searchPanel.add((Component)this.tableScroll, "Center");
        removeTableItem.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                final String tableName = (String)QueryTab.this.list.getSelectedValue();
                if (JOptionPane.showConfirmDialog(QueryTab.this.getFrame(), "\u786e\u5b9a\u5220\u9664" + tableName + "\u8868\u5417?") == 0 && tableName != null) {
                    QueryTab.this.getSingleThreadPool().execute(new Runnable(){

                        @Override
                        public void run() {
                            QueryTab.this.startTask();
                            try {
                                SwingConstants.hbaseAdapter.dropTable(tableName);
                                JOptionPane.showMessageDialog(QueryTab.this.getFrame(), "\u5220\u9664\u6210\u529f", "\u63d0\u793a", 1);
                                String propertiesKey = String.valueOf((String)QueryTab.this.list.getSelectedValue()) + ".MATA";
                                SwingConstants.selectedConf.remove(propertiesKey);
                                QueryTab.this.cleanTable();
                                QueryTab.this.initTableList(QueryTab.this.list);
                            }
                            catch (Exception e) {
                                QueryTab.this.exceptionAlert(e);
                                return;
                            }
                            QueryTab.this.stopTask();
                        }
                    });
                    try {
                        QueryTab.this.initTableList(QueryTab.this.list);
                    }
                    catch (Exception e1) {
                        QueryTab.this.exceptionAlert(e1);
                        return;
                    }
                }
            }
        });
        this.refreshTableButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                QueryTab.this.refreshTableButton.setEnabled(false);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                QueryTab.this.getSingleThreadPool().execute(new Runnable(){

                    @Override
                    public void run() {
                        QueryTab.this.startTask();
                        try {
                            QueryTab.this.initTableList(QueryTab.this.list);
                        }
                        catch (Exception e) {
                            QueryTab.this.exceptionAlert(e);
                            return;
                        }
                        QueryTab.this.stopTask();
                    }
                });
            }
        });
        countItem.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                final String tableName = (String)QueryTab.this.list.getSelectedValue();
                if (JOptionPane.showConfirmDialog(QueryTab.this.getFrame(), "\u786e\u5b9a\u8fdb\u884c\u5417\uff1f\u5927\u8868\u53ef\u80fd\u9700\u8981\u8f83\u957f\u65f6\u95f4\u7edf\u8ba1") == 0 && tableName != null) {
                    QueryTab.this.getSingleThreadPool().execute(new Runnable(){

                        @Override
                        public void run() {
                            QueryTab.this.startTask();
                            try {
                                long count = SwingConstants.hbaseAdapter.rowCount(tableName);
                                JOptionPane.showMessageDialog(QueryTab.this.getFrame(), count, String.valueOf(tableName) + "\u6570\u636e\u603b\u6570", 1);
                            }
                            catch (Exception e) {
                                QueryTab.this.exceptionAlert(e);
                                return;
                            }
                            QueryTab.this.stopTask();
                        }
                    });
                }
            }
        });
        truncateTableItem.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                final String tableName = (String)QueryTab.this.list.getSelectedValue();
                if (JOptionPane.showConfirmDialog(QueryTab.this.getFrame(), "\u786e\u5b9a\u6e05\u7a7a" + tableName + "\u8868\u5417?") == 0 && tableName != null) {
                    QueryTab.this.getSingleThreadPool().execute(new Runnable(){

                        @Override
                        public void run() {
                            QueryTab.this.startTask();
                            try {
                                SwingConstants.hbaseAdapter.truncateTable(tableName, true);
                                JOptionPane.showMessageDialog(QueryTab.this.getFrame(), "\u5df2\u6e05\u7a7a", "\u63d0\u793a", 1);
                                QueryTab.this.cleanTable();
                                QueryTab.this.initTableList(QueryTab.this.list);
                            }
                            catch (Exception e) {
                                QueryTab.this.exceptionAlert(e);
                                return;
                            }
                            QueryTab.this.stopTask();
                        }
                    });
                }
            }
        });
        this.contentTable.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                QueryTab.this.resizeTable(true, QueryTab.this.contentTable, QueryTab.this.tableScroll);
            }
        });
        this.contentTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (QueryTab.this.contentTable.getSelectedRowCount() == 0) {
                    QueryTab.this.deleteButton.setEnabled(false);
                } else {
                    QueryTab.this.deleteButton.setEnabled(true);
                }
            }
        });
        this.list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    QueryTab.this.getSingleThreadPool().execute(new Runnable(){

                        @Override
                        public void run() {
                            QueryTab.this.startTask();
                            try {
                                QueryTab.this.loadMataData((String)QueryTab.this.list.getSelectedValue());
                                QueryTab.this.cleanTable();
                                QueryTab.this.textField_pageSize.setText("10");
                                QueryTab.this.query();
                            }
                            catch (Exception e) {
                                QueryTab.this.exceptionAlert(e);
                                return;
                            }
                            QueryTab.this.stopTask();
                        }
                    });
                }
            }
        });
        this.fieldsComboBox.addItemListener(new AutoAdapterFieldTypeItemListener());
        try {
            this.initTableList(this.list);
        }
        catch (Exception e) {
            this.exceptionAlert(e);
        }
        return select;
    }

    private void cleanTable() {
        this.contentTable.setModel(new DefaultTableModel());
        pageModel = null;
        HandleCore.cleanPageInfomation(this.bottom_message_label);
    }

    private HbaseQualifier customField(String inputString) {
        int sbIndex = inputString.indexOf(".");
        if (sbIndex <= 0) {
            return null;
        }
        return new HbaseQualifier(inputString.substring(0, sbIndex).getBytes(), inputString.substring(sbIndex + 1).getBytes(), "string");
    }

    @Override
    public void disableAll() {
        this.list.setEnabled(false);
        this.searchButton.setEnabled(false);
        this.nextpage_button.setEnabled(false);
        this.refreshTableButton.setEnabled(false);
    }

    @Override
    public void enableAll() {
        this.list.setEnabled(true);
        this.searchButton.setEnabled(true);
        this.nextpage_button.setEnabled(true);
        this.refreshTableButton.setEnabled(true);
    }

    private void loadMataData(String tableName) throws Exception {
        String propertiesKey = String.valueOf(this.list.getSelectedValue()) + ".MATA";
        String cacheMetaData = SwingConstants.selectedConf.getStringValue(propertiesKey);
        List qualifierList = SwingConstants.hbaseAdapter.getTableQualifiers(tableName);
        if (!StringUtil.isEmpty(cacheMetaData)) {
            Map metaData = (Map)JSON.parseObject((String)cacheMetaData, Map.class);
            for (HbaseQualifier item : qualifierList) {
                if (StringUtil.isEmpty((String)metaData.get(item.getDisplayName()))) continue;
                item.setType((String)metaData.get(item.getDisplayName()));
            }
        }
        this.fieldsComboBox.removeAllItems();
        for (HbaseQualifier hbaseQualifier : qualifierList) {
            this.fieldsComboBox.addItem(hbaseQualifier);
        }
    }

    private List<Object> getFilter() {
        String rowkeyPrefix;
        ArrayList<Object> fs = new ArrayList<Object>();
        HbaseQualifier colume = this.fieldsComboBox.getItemAt(this.fieldsComboBox.getSelectedIndex());
        if (colume == null && this.fieldsComboBox.getSelectedItem() != null && this.fieldsComboBox.getSelectedItem() instanceof HbaseQualifier) {
            colume = (HbaseQualifier)this.fieldsComboBox.getSelectedItem();
        }
        if (colume != null && !StringUtil.isEmpty(this.filterValueTextField.getText()) && !StringUtil.isEmpty(this.filterValueTextField.getText())) {
            String compareOpSimple = this.filterOperatorComboBox.getItemAt(this.filterOperatorComboBox.getSelectedIndex());
            String comparatorClassName = this.comparatorComboBox.getItemAt(this.comparatorComboBox.getSelectedIndex());
            String fieldType = this.fieldTypeComboBox.getItemAt(this.fieldTypeComboBox.getSelectedIndex());
            String fieldValue = this.filterValueTextField.getText();
            fs.add(SwingConstants.filterFactory.createSingleColumnValueFilter(colume.getFamily(), colume.getQualifier(), compareOpSimple, comparatorClassName, fieldType, fieldValue));
        }
        if (!StringUtil.isEmpty(rowkeyPrefix = this.textField_rowKey_prefix.getText())) {
            fs.add(SwingConstants.filterFactory.createRowkeyPrefixFilter(rowkeyPrefix.getBytes()));
        }
        if (fs.size() != 0) {
            return fs;
        }
        return null;
    }

    private void query() throws Exception {
        HandleCore.setPageInfomation(null, this.bottom_message_label);
        String tableName = this.list.getSelectedValue();
        Integer page = 10;
        try {
            page = Integer.parseInt(this.textField_pageSize.getText());
        }
        catch (Exception e2) {
            this.textField_pageSize.setText(page.toString());
        }
        Integer version = Integer.MAX_VALUE;
        try {
            version = Integer.parseInt(this.textField_version.getText());
        }
        catch (Exception e2) {
            this.textField_pageSize.setText(version.toString());
        }
        byte[] startRowKeyByte = null;
        byte[] endRowKeyByte = null;
        String startRowKey = this.textField_start_rowkey.getText();
        String endRowKey = this.textField_end_rowkey.getText();
        if (!StringUtil.isEmpty(startRowKey)) {
            startRowKeyByte = MyBytesUtil.toBytes(startRowKey);
        }
        if (!StringUtil.isEmpty(endRowKey)) {
            endRowKeyByte = MyBytesUtil.toBytes(endRowKey);
        }
        if (tableName != null) {
            pageModel = new HBasePageModel(page.intValue(), tableName);
            pageModel.setMinStamp(DateUtil.convertMinStamp(this.textField_min_stamp.getText(), "yyyy-MM-dd HH:mm:ss"));
            pageModel.setMaxStamp(DateUtil.convertMaxStamp(this.textField_max_stamp.getText(), "yyyy-MM-dd HH:mm:ss"));
            pageModel = SwingConstants.hbaseAdapter.scanResultByPageFilter(tableName, startRowKeyByte, endRowKeyByte, this.getFilter(), version.intValue(), pageModel, true, this.getMetaData());
            HandleCore.reloadTableFormat(tableName, this.contentTable, pageModel);
            HandleCore.setPageInfomation(pageModel, this.bottom_message_label);
        } else {
            JOptionPane.showMessageDialog(this.getFrame(), "\u8bf7\u5728\u53f3\u4fa7\u9009\u62e9\u8868", "\u63d0\u793a", 1);
        }
    }

    private Map<String, String> getMetaData() {
        String propertiesKey = String.valueOf(this.list.getSelectedValue()) + ".MATA";
        String mappingStr = SwingConstants.selectedConf.getStringValue(propertiesKey);
        Map typeMapping = null;
        if (!StringUtil.isEmpty(mappingStr)) {
            typeMapping = (Map)JSON.parseObject((String)mappingStr, Map.class);
        }
        return typeMapping;
    }

    class AutoAdapterFieldTypeItemListener
    implements ItemListener {
        AutoAdapterFieldTypeItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            HbaseQualifier item = null;
            if (QueryTab.this.fieldsComboBox.getSelectedIndex() > 0 && QueryTab.this.fieldsComboBox.getSelectedItem() instanceof HbaseQualifier) {
                item = (HbaseQualifier)QueryTab.this.fieldsComboBox.getSelectedItem();
            } else if (QueryTab.this.fieldsComboBox.getSelectedIndex() == -1 && QueryTab.this.fieldsComboBox.getSelectedItem() != null) {
                String inputString = QueryTab.this.fieldsComboBox.getSelectedItem().toString();
                item = QueryTab.this.customField(inputString);
                if (item == null) {
                    return;
                }
                QueryTab.this.fieldsComboBox.removeItemListener(this);
                QueryTab.this.fieldsComboBox.addItem(item);
                QueryTab.this.fieldsComboBox.setSelectedIndex(QueryTab.this.fieldsComboBox.getItemCount() - 1);
                QueryTab.this.fieldsComboBox.addItemListener(this);
            } else {
                return;
            }
            int i = 0;
            while (i < QueryTab.this.fieldTypeComboBox.getItemCount()) {
                String type = (String)QueryTab.this.fieldTypeComboBox.getItemAt(i);
                if (item.getType().equalsIgnoreCase(type)) {
                    QueryTab.this.fieldTypeComboBox.setSelectedIndex(i);
                }
                ++i;
            }
        }
    }

    class DeleteEvent
    extends MouseAdapter {
        DeleteEvent() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            QueryTab.this.deleteButton.setEnabled(false);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            QueryTab.this.startTask();
            QueryTab.this.getSingleThreadPool().execute(new Runnable(){

                @Override
                public void run() {
                    int selectedRowCount = QueryTab.this.contentTable.getSelectedRowCount();
                    String tableName = (String)QueryTab.this.list.getSelectedValue();
                    if (selectedRowCount > 0 || tableName != null) {
                        String[] rowkeys = new String[selectedRowCount];
                        int[] selectRowIndexs = QueryTab.this.contentTable.getSelectedRows();
                        int i = 0;
                        while (i < selectedRowCount) {
                            rowkeys[i] = QueryTab.this.contentTable.getValueAt(selectRowIndexs[i], 1).toString();
                            ++i;
                        }
                        try {
                            SwingConstants.hbaseAdapter.deleteRow(tableName, rowkeys);
                        }
                        catch (Exception e) {
                            QueryTab.this.exceptionAlert(e);
                            return;
                        }
                        DefaultTableModel model = (DefaultTableModel)QueryTab.this.contentTable.getModel();
                        while (QueryTab.this.contentTable.getSelectedRowCount() > 0) {
                            model.removeRow(QueryTab.this.contentTable.getSelectedRow());
                        }
                    } else {
                        QueryTab.this.deleteButton.setEnabled(false);
                    }
                    QueryTab.this.stopTask();
                }
            });
        }
    }

    class NextPage
    extends MouseAdapter {
        NextPage() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            QueryTab.this.nextpage_button.setEnabled(false);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            QueryTab.this.startTask();
            QueryTab.this.getSingleThreadPool().execute(new Runnable(){

                @Override
                public void run() {
                    if (pageModel == null) {
                        JOptionPane.showMessageDialog(QueryTab.this.getFrame(), "\u8bf7\u9009\u62e9\u8868\u5e76\u8fdb\u884c\u4e00\u6b21\u67e5\u8be2", "\u8b66\u544a", 2);
                        QueryTab.this.nextpage_button.setEnabled(true);
                        QueryTab.this.stopTask();
                        return;
                    }
                    if (pageModel.getQueryTotalCount() % pageModel.getPageSize() != 0) {
                        JOptionPane.showMessageDialog(QueryTab.this.getFrame(), "\u5df2\u7ecf\u5230\u4e86\u6700\u540e\u4e00\u9875", "\u8b66\u544a", 2);
                        QueryTab.this.nextpage_button.setEnabled(true);
                        QueryTab.this.stopTask();
                        return;
                    }
                    Integer page = 10;
                    try {
                        page = Integer.parseInt(QueryTab.this.textField_pageSize.getText());
                    }
                    catch (Exception e2) {
                        QueryTab.this.textField_pageSize.setText(page.toString());
                    }
                    Integer version = Integer.MAX_VALUE;
                    try {
                        version = Integer.parseInt(QueryTab.this.textField_version.getText());
                    }
                    catch (Exception e2) {
                        QueryTab.this.textField_pageSize.setText(version.toString());
                    }
                    byte[] startRowKeyByte = null;
                    byte[] endRowKeyByte = null;
                    String startRowKey = QueryTab.this.textField_start_rowkey.getText();
                    String endRowKey = QueryTab.this.textField_end_rowkey.getText();
                    if (!StringUtil.isEmpty(startRowKey)) {
                        startRowKeyByte = MyBytesUtil.toBytes(startRowKey);
                    }
                    if (!StringUtil.isEmpty(endRowKey)) {
                        endRowKeyByte = MyBytesUtil.toBytes(endRowKey);
                    }
                    pageModel.setMinStamp(DateUtil.convertMinStamp(QueryTab.this.textField_min_stamp.getText(), "yyyy-MM-dd HH:mm:ss"));
                    pageModel.setMaxStamp(DateUtil.convertMaxStamp(QueryTab.this.textField_max_stamp.getText(), "yyyy-MM-dd HH:mm:ss"));
                    try {
                        pageModel = SwingConstants.hbaseAdapter.scanResultByPageFilter(pageModel.getTableName(), startRowKeyByte, endRowKeyByte, QueryTab.this.getFilter(), version.intValue(), pageModel, false, QueryTab.this.getMetaData());
                        HandleCore.reloadTableFormat(pageModel.getTableName(), QueryTab.this.contentTable, pageModel);
                        HandleCore.setPageInfomation(pageModel, QueryTab.this.bottom_message_label);
                    }
                    catch (Exception e) {
                        QueryTab.this.exceptionAlert(e);
                        return;
                    }
                    QueryTab.this.stopTask();
                }
            });
        }
    }

    class SelectEvent
    extends MouseAdapter {
        SelectEvent() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            QueryTab.this.searchButton.setEnabled(false);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (QueryTab.this.searchButton.isEnabled()) {
                return;
            }
            QueryTab.this.getSingleThreadPool().execute(new Runnable(){

                @Override
                public void run() {
                    QueryTab.this.startTask();
                    try {
                        QueryTab.this.query();
                    }
                    catch (Exception e) {
                        QueryTab.this.exceptionAlert(e);
                        return;
                    }
                    QueryTab.this.stopTask();
                }
            });
        }
    }
}

